/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.util.CliTools;

public class CeParameters
implements ConfigStrucAligParams {
    protected int winSize;
    protected double rmsdThr;
    protected double rmsdThrJoin;
    protected double maxOptRMSD;
    protected ScoringStrategy scoringStrategy;
    protected int maxGapSize;
    protected boolean showAFPRanges;
    protected int sideChainScoringType;
    private boolean optimizeAlignment;
    protected static final double DEFAULT_GAP_OPEN = 5.0;
    protected static final double DEFAULT_GAP_EXTENSION = 0.5;
    protected static final double DISTANCE_INCREMENT = 0.5;
    protected static final double DEFAULT_oRmsdThr = 2.0;
    protected static final String DEFAULT_SUBSTITUTION_MATRIX = "PRLA000101";
    protected double gapOpen;
    protected double gapExtension;
    protected double distanceIncrement;
    protected double oRmsdThr;
    protected int maxNrIterationsForOptimization;
    protected SubstitutionMatrix<AminoAcidCompound> substitutionMatrix;
    protected double seqWeight;

    public CeParameters() {
        this.reset();
    }

    public String toString() {
        return "CeParameters [scoringStrategy=" + this.scoringStrategy + ", maxGapSize=" + this.maxGapSize + ", rmsdThr=" + this.rmsdThr + ", rmsdThrJoin=" + this.rmsdThrJoin + ", winSize=" + this.winSize + ", showAFPRanges=" + this.showAFPRanges + ", maxOptRMSD=" + this.maxOptRMSD + ", seqWeight=" + this.seqWeight + "]";
    }

    @Override
    public void reset() {
        this.winSize = 8;
        this.rmsdThr = 3.0;
        this.rmsdThrJoin = 4.0;
        this.scoringStrategy = ScoringStrategy.DEFAULT_SCORING_STRATEGY;
        this.maxGapSize = 30;
        this.showAFPRanges = false;
        this.maxOptRMSD = 99.0;
        this.gapOpen = 5.0;
        this.gapExtension = 0.5;
        this.distanceIncrement = 0.5;
        this.oRmsdThr = 2.0;
        this.maxNrIterationsForOptimization = Integer.MAX_VALUE;
        this.seqWeight = 0.0;
        this.optimizeAlignment = true;
    }

    public Integer getWinSize() {
        return this.winSize;
    }

    public void setWinSize(Integer winSize) {
        this.winSize = winSize;
    }

    public Double getRmsdThr() {
        return this.rmsdThr;
    }

    public void setRmsdThr(Double rmsdThr) {
        this.rmsdThr = rmsdThr;
    }

    public Double getRmsdThrJoin() {
        return this.rmsdThrJoin;
    }

    public void setRmsdThrJoin(Double rmsdThrJoin) {
        this.rmsdThrJoin = rmsdThrJoin;
    }

    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    public void setScoringStrategy(ScoringStrategy scoringStrategy) {
        this.scoringStrategy = scoringStrategy;
    }

    public void setMaxGapSize(Integer maxGapSize) {
        this.maxGapSize = maxGapSize;
    }

    public Integer getMaxGapSize() {
        return this.maxGapSize;
    }

    @Override
    public List<String> getUserConfigHelp() {
        ArrayList<String> params = new ArrayList<String>();
        String helpMaxGap = "This parameter configures the maximum gap size G, that is applied during the AFP extension. The larger the value, the longer the calculation time can become, Default value is 30. Set to 0 for no limit. ";
        String helpWinSize = "This configures the fragment size m of Aligned Fragment Pairs (AFPs).";
        params.add(helpMaxGap);
        params.add(helpWinSize);
        params.add("Which scoring function to use: " + CliTools.getEnumValuesAsString(ScoringStrategy.class));
        params.add("The maximum RMSD at which to stop alignment optimization. (default: unlimited=99)");
        params.add("Gap opening penalty during alignment optimization [default: 5.0].");
        params.add("Gap extension penalty during alignment optimization [default: 0.5].");
        return params;
    }

    @Override
    public List<String> getUserConfigParameters() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("MaxGapSize");
        params.add("WinSize");
        params.add("ScoringStrategy");
        params.add("MaxOptRMSD");
        params.add("GapOpen");
        params.add("GapExtension");
        return params;
    }

    @Override
    public List<String> getUserConfigParameterNames() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("max. gap size G (during AFP extension).");
        params.add("fragment size m");
        params.add("Which scoring function to use");
        params.add("RMSD threshold for alignment.");
        params.add("Gap open");
        params.add("Gap extension");
        return params;
    }

    @Override
    public List<Class> getUserConfigTypes() {
        ArrayList<Class> params = new ArrayList<Class>();
        params.add(Integer.class);
        params.add(Integer.class);
        params.add(ScoringStrategy.class);
        params.add(Double.class);
        params.add(Double.class);
        params.add(Double.class);
        return params;
    }

    public boolean isShowAFPRanges() {
        return this.showAFPRanges;
    }

    public void setShowAFPRanges(boolean showAFPRanges) {
        this.showAFPRanges = showAFPRanges;
    }

    public void setMaxOptRMSD(Double param) {
        if (param == null) {
            param = 99.0;
        }
        this.maxOptRMSD = param;
    }

    public Double getMaxOptRMSD() {
        return this.maxOptRMSD;
    }

    public Double getGapOpen() {
        return this.gapOpen;
    }

    public void setGapOpen(Double gapOpen) {
        this.gapOpen = gapOpen;
    }

    public Double getGapExtension() {
        return this.gapExtension;
    }

    public void setGapExtension(Double gapExtension) {
        this.gapExtension = gapExtension;
    }

    public Double getDistanceIncrement() {
        return this.distanceIncrement;
    }

    public void setDistanceIncrement(Double distanceIncrement) {
        this.distanceIncrement = distanceIncrement;
    }

    public Double getORmsdThr() {
        return this.oRmsdThr;
    }

    public void setORmsdThr(Double oRmsdThr) {
        this.oRmsdThr = oRmsdThr;
    }

    public int getMaxNrIterationsForOptimization() {
        return this.maxNrIterationsForOptimization;
    }

    public void setMaxNrIterationsForOptimization(int maxNrIterationsForOptimization) {
        this.maxNrIterationsForOptimization = maxNrIterationsForOptimization;
    }

    public double getSeqWeight() {
        return this.seqWeight;
    }

    public void setSeqWeight(double seqWeight) {
        this.seqWeight = seqWeight;
    }

    public SubstitutionMatrix<AminoAcidCompound> getSubstitutionMatrix() {
        if (this.substitutionMatrix == null) {
            this.substitutionMatrix = SubstitutionMatrixHelper.getMatrixFromAAINDEX((String)DEFAULT_SUBSTITUTION_MATRIX);
        }
        return this.substitutionMatrix;
    }

    public void setSubstitutionMatrix(SubstitutionMatrix<AminoAcidCompound> substitutionMatrix) {
        this.substitutionMatrix = substitutionMatrix;
    }

    public boolean isOptimizeAlignment() {
        return this.optimizeAlignment;
    }

    public void setOptimizeAlignment(boolean optimizeAlignment) {
        this.optimizeAlignment = optimizeAlignment;
    }

    public static enum ScoringStrategy {
        CA_SCORING("CA only"),
        SIDE_CHAIN_SCORING("Sidechain orientation"),
        SIDE_CHAIN_ANGLE_SCORING("Angle between sidechains"),
        CA_AND_SIDE_CHAIN_ANGLE_SCORING("CA distance+Angle between sidechains"),
        SEQUENCE_CONSERVATION("Sequence Conservation");

        public static ScoringStrategy DEFAULT_SCORING_STRATEGY;
        private String name;

        private ScoringStrategy(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        static {
            DEFAULT_SCORING_STRATEGY = CA_SCORING;
        }
    }
}

