/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.scop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.biojava.nbio.core.util.FileDownloadUtils;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.align.util.UserConfiguration;
import org.biojava.nbio.structure.scop.LocalScopDatabase;
import org.biojava.nbio.structure.scop.ScopCategory;
import org.biojava.nbio.structure.scop.ScopDescription;
import org.biojava.nbio.structure.scop.ScopDomain;
import org.biojava.nbio.structure.scop.ScopIOException;
import org.biojava.nbio.structure.scop.ScopMirror;
import org.biojava.nbio.structure.scop.ScopNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopInstallation
implements LocalScopDatabase {
    public static final String DEFAULT_VERSION = "2.08";
    private static final Logger logger = LoggerFactory.getLogger(ScopInstallation.class);
    private String scopVersion;
    private final List<ScopMirror> mirrors;
    public static final String claFileName = "dir.cla.scop.txt_";
    public static final String desFileName = "dir.des.scop.txt_";
    public static final String hieFileName = "dir.hie.scop.txt_";
    public static final String comFileName = "dir.com.scop.txt_";
    public static final String SCOP_DOWNLOAD = "http://scop.berkeley.edu/downloads/parse/";
    public static final String SCOP_DOWNLOAD_ALTERNATE = "http://scop.berkeley.edu/downloads/parse/";
    public static final String FILESPLIT = System.getProperty("file.separator");
    private String cacheLocation;
    private AtomicBoolean installedCla;
    private AtomicBoolean installedDes;
    private AtomicBoolean installedHie;
    private AtomicBoolean installedCom;
    private Map<Integer, List<String>> commentsMap;
    private Map<String, List<ScopDomain>> domainMap;
    private Map<Integer, ScopDescription> sunidMap;
    private Map<Integer, ScopNode> scopTree;

    public ScopInstallation(String cacheLocation) {
        this.setCacheLocation(cacheLocation);
        this.installedCla = new AtomicBoolean();
        this.installedCla.set(false);
        this.installedDes = new AtomicBoolean();
        this.installedDes.set(false);
        this.installedHie = new AtomicBoolean();
        this.installedHie.set(false);
        this.installedCom = new AtomicBoolean();
        this.installedCom.set(false);
        this.scopVersion = DEFAULT_VERSION;
        this.mirrors = new ArrayList<ScopMirror>(1);
        this.domainMap = new HashMap<String, List<ScopDomain>>();
        this.sunidMap = new HashMap<Integer, ScopDescription>();
        this.scopTree = new TreeMap<Integer, ScopNode>();
    }

    public void nullifyComments() {
        this.commentsMap = null;
        this.installedCom.set(false);
    }

    public ScopInstallation() {
        this(new UserConfiguration().getCacheFilePath());
    }

    public void ensureClaInstalled() throws IOException {
        if (this.installedCla.get()) {
            return;
        }
        if (!this.claFileAvailable()) {
            this.downloadClaFile();
        }
        this.parseClassification();
        this.installedCla.set(true);
    }

    public void ensureDesInstalled() throws IOException {
        if (this.installedDes.get()) {
            return;
        }
        if (!this.desFileAvailable()) {
            this.downloadDesFile();
        }
        this.parseDescriptions();
        this.installedDes.set(true);
    }

    public void ensureComInstalled() throws IOException {
        if (this.installedCom.get()) {
            return;
        }
        if (!this.comFileAvailable()) {
            this.downloadComFile();
        }
        this.parseComments();
        this.installedCom.set(true);
    }

    public void ensureHieInstalled() throws IOException {
        if (this.installedHie.get()) {
            return;
        }
        if (!this.hieFileAvailable()) {
            this.downloadHieFile();
        }
        this.parseHierarchy();
        this.installedHie.set(true);
    }

    @Override
    public List<ScopDescription> getByCategory(ScopCategory category) {
        try {
            this.ensureDesInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        ArrayList<ScopDescription> matches = new ArrayList<ScopDescription>();
        for (Integer i : this.sunidMap.keySet()) {
            ScopDescription sc = this.sunidMap.get(i);
            if (!sc.getCategory().equals(category)) continue;
            try {
                matches.add((ScopDescription)sc.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Could not clone " + ScopDescription.class + " subclass", e);
            }
        }
        return matches;
    }

    @Override
    public List<ScopDescription> filterByClassificationId(String query) {
        try {
            this.ensureDesInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        ArrayList<ScopDescription> matches = new ArrayList<ScopDescription>();
        for (Integer i : this.sunidMap.keySet()) {
            ScopDescription sc = this.sunidMap.get(i);
            if (!sc.getClassificationId().startsWith(query)) continue;
            matches.add(sc);
        }
        return matches;
    }

    @Override
    public List<ScopNode> getTree(ScopDomain domain) {
        ScopNode node = this.getScopNode(domain.getSunid());
        ArrayList<ScopNode> tree = new ArrayList<ScopNode>();
        while (node != null) {
            if ((node = this.getScopNode(node.getParentSunid())) == null) continue;
            tree.add(node);
        }
        Collections.reverse(tree);
        return tree;
    }

    @Override
    public List<ScopDomain> filterByDomainName(String query) {
        ArrayList<ScopDomain> domains = new ArrayList<ScopDomain>();
        if (query.length() < 5) {
            return domains;
        }
        String pdbId = query.substring(1, 5);
        List<ScopDomain> doms = this.getDomainsForPDB(pdbId);
        if (doms == null) {
            return domains;
        }
        query = query.toLowerCase();
        for (ScopDomain d : doms) {
            if (!d.getScopId().toLowerCase().contains(query)) continue;
            domains.add(d);
        }
        return domains;
    }

    @Override
    public List<ScopDescription> filterByDescription(String query) throws ScopIOException {
        try {
            this.ensureDesInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        query = query.toLowerCase();
        ArrayList<ScopDescription> matches = new ArrayList<ScopDescription>();
        for (Integer i : this.sunidMap.keySet()) {
            ScopDescription sc = this.sunidMap.get(i);
            if (!sc.getDescription().toLowerCase().startsWith(query)) continue;
            matches.add(sc);
        }
        return matches;
    }

    @Override
    public ScopDescription getScopDescriptionBySunid(int sunid) {
        try {
            this.ensureDesInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        return this.sunidMap.get(sunid);
    }

    @Override
    public List<ScopDomain> getDomainsForPDB(String pdbId) {
        try {
            this.ensureClaInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        List<ScopDomain> doms = this.domainMap.get(pdbId.toLowerCase());
        ArrayList<ScopDomain> retdoms = new ArrayList<ScopDomain>();
        if (doms == null) {
            return retdoms;
        }
        for (ScopDomain d : doms) {
            try {
                ScopDomain n = (ScopDomain)d.clone();
                retdoms.add(n);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(ScopDomain.class + " subclass does not support clone()", e);
            }
        }
        return retdoms;
    }

    @Override
    public ScopDomain getDomainByScopID(String scopId) {
        try {
            this.ensureClaInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        if (scopId.length() < 6) {
            throw new ScopIOException("Does not look like a scop ID! " + scopId);
        }
        String pdbId = scopId.substring(1, 5);
        List<ScopDomain> doms = this.getDomainsForPDB(pdbId);
        if (doms == null) {
            return null;
        }
        for (ScopDomain d : doms) {
            if (!d.getScopId().equalsIgnoreCase(scopId)) continue;
            return d;
        }
        return null;
    }

    @Override
    public ScopNode getScopNode(int sunid) {
        try {
            this.ensureHieInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        return this.scopTree.get(sunid);
    }

    private void parseClassification() throws IOException {
        File file = new File(this.getClaFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseClassification(buffer);
    }

    private void parseHierarchy() throws IOException {
        File file = new File(this.getHieFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseHierarchy(buffer);
    }

    private void parseHierarchy(BufferedReader buffer) throws IOException {
        String line;
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] spl = line.split("\t");
            if (spl.length != 3) {
                throw new IOException("parseHierarchy: Can't parse line " + line + " (length: " + spl.length + ")");
            }
            ++counter;
            int sunid = Integer.parseInt(spl[0]);
            int parentSunid = -1;
            if (sunid != 0) {
                parentSunid = Integer.parseInt(spl[1]);
            }
            String children = spl[2];
            String[] childIds = children.split(",");
            ArrayList<Integer> chis = new ArrayList<Integer>();
            for (String id : childIds) {
                if (id.equals("-")) continue;
                chis.add(Integer.parseInt(id));
            }
            ScopNode node = new ScopNode();
            node.setSunid(sunid);
            node.setParentSunid(parentSunid);
            node.setChildren(chis);
            this.scopTree.put(sunid, node);
        }
        logger.info("Parsed {} SCOP sunid nodes.", (Object)counter);
    }

    private void parseDescriptions() throws IOException {
        File file = new File(this.getDesFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseDescriptions(buffer);
    }

    private void parseComments() throws IOException {
        File file = new File(this.getComFilename());
        InputStreamProvider ips = new InputStreamProvider();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(ips.getInputStream(file)));
        this.parseComments(buffer);
    }

    private void parseComments(BufferedReader buffer) throws IOException {
        String line;
        this.commentsMap = new HashMap<Integer, List<String>>();
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split("!");
            int sunId = Integer.parseInt(parts[0].trim());
            if (parts.length == 1) {
                this.commentsMap.put(sunId, new ArrayList(1));
                continue;
            }
            ArrayList<String> comments = new ArrayList<String>(parts.length - 1);
            for (int i = 1; i < parts.length; ++i) {
                String trimmed = parts[i].trim();
                if (trimmed.isEmpty()) continue;
                comments.add(trimmed);
            }
            this.commentsMap.put(sunId, comments);
            ++counter;
        }
        logger.info("Parsed {} SCOP comments.", (Object)counter);
    }

    private void parseDescriptions(BufferedReader buffer) throws IOException {
        String line = null;
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] spl = line.split("\t");
            if (spl.length != 5) {
                throw new IOException("parseDescriptions: Can't parse line " + line + " (length: " + spl.length + ")");
            }
            ++counter;
            int sunID = Integer.parseInt(spl[0]);
            ScopCategory category = ScopCategory.fromString(spl[1]);
            String classificationId = spl[2];
            String name = spl[3];
            String desc = spl[4];
            ScopDescription c = new ScopDescription();
            c.setSunID(sunID);
            c.setCategory(category);
            c.setClassificationId(classificationId);
            c.setName(name);
            c.setDescription(desc);
            this.sunidMap.put(sunID, c);
        }
        logger.info("Parsed {} SCOP sunid descriptions.", (Object)counter);
    }

    private void parseClassification(BufferedReader buffer) throws IOException {
        String line = null;
        int counter = 0;
        while ((line = buffer.readLine()) != null) {
            List<Object> domainList;
            if (line.startsWith("#")) continue;
            String[] spl = line.split("\t");
            if (spl.length != 6) {
                throw new IOException("Can't parse line " + line);
            }
            ++counter;
            String scopId = spl[0];
            String pdbId = spl[1];
            String range = spl[2];
            String classificationId = spl[3];
            Integer sunid = Integer.parseInt(spl[4]);
            String tree = spl[5];
            ScopDomain d = new ScopDomain();
            d.setScopId(scopId);
            PdbId tempPdbId = null;
            try {
                tempPdbId = new PdbId(pdbId);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                logger.warn("could not parse line >>{}<<. Error Message: {}", (Object)line, (Object)e.getMessage());
            }
            d.setPdbId(tempPdbId);
            d.setRanges(this.extractRanges(range));
            d.setClassificationId(classificationId);
            d.setSunid(sunid);
            String[] treeSplit = tree.split(",");
            if (treeSplit.length != 7) {
                throw new IOException("Can't process: " + line);
            }
            int classId = Integer.parseInt(treeSplit[0].substring(3));
            int foldId = Integer.parseInt(treeSplit[1].substring(3));
            int superfamilyId = Integer.parseInt(treeSplit[2].substring(3));
            int familyId = Integer.parseInt(treeSplit[3].substring(3));
            int domainId = Integer.parseInt(treeSplit[4].substring(3));
            int speciesId = Integer.parseInt(treeSplit[5].substring(3));
            int px = Integer.parseInt(treeSplit[6].substring(3));
            d.setClassId(classId);
            d.setFoldId(foldId);
            d.setSuperfamilyId(superfamilyId);
            d.setFamilyId(familyId);
            d.setDomainId(domainId);
            d.setSpeciesId(speciesId);
            d.setPx(px);
            if (this.domainMap.containsKey(pdbId)) {
                domainList = this.domainMap.get(pdbId);
            } else {
                domainList = new ArrayList();
                this.domainMap.put(pdbId, domainList);
            }
            domainList.add(d);
        }
        logger.info("Parsed {} SCOP sunid domains.", (Object)counter);
    }

    private List<String> extractRanges(String range) {
        String[] rangeSpl = range.split(",");
        if (this.scopVersion.compareTo("1.73") < 0) {
            for (int i = 0; i < rangeSpl.length; ++i) {
                String subRange = rangeSpl[i];
                if (subRange.length() < 2 || subRange.charAt(1) == ':') continue;
                rangeSpl[i] = "_:" + subRange;
            }
        }
        List<String> ranges = Arrays.asList(rangeSpl);
        return ranges;
    }

    protected void downloadClaFile() throws FileNotFoundException, IOException {
        if (this.mirrors.size() < 1) {
            this.initScopURLs();
        }
        IOException exception = null;
        for (ScopMirror mirror : this.mirrors) {
            try {
                URL url = new URL(mirror.getClaURL(this.scopVersion));
                String localFileName = this.getClaFilename();
                File localFile = new File(localFileName);
                this.downloadFileFromRemote(url, localFile);
                return;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        throw new IOException("Unable to download SCOP .cla file", exception);
    }

    protected void downloadDesFile() throws FileNotFoundException, IOException {
        if (this.mirrors.size() < 1) {
            this.initScopURLs();
        }
        IOException exception = null;
        for (ScopMirror mirror : this.mirrors) {
            try {
                URL url = new URL(mirror.getDesURL(this.scopVersion));
                String localFileName = this.getDesFilename();
                File localFile = new File(localFileName);
                this.downloadFileFromRemote(url, localFile);
                return;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        throw new IOException("Unable to download SCOP .des file", exception);
    }

    protected void downloadHieFile() throws IOException {
        if (this.mirrors.size() < 1) {
            this.initScopURLs();
        }
        IOException exception = null;
        for (ScopMirror mirror : this.mirrors) {
            try {
                URL url = new URL(mirror.getHieURL(this.scopVersion));
                String localFileName = this.getHieFilename();
                File localFile = new File(localFileName);
                this.downloadFileFromRemote(url, localFile);
                return;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        throw new IOException("Unable to download SCOP .hie file", exception);
    }

    protected void downloadComFile() throws FileNotFoundException, IOException {
        if (this.mirrors.size() < 1) {
            this.initScopURLs();
        }
        IOException exception = null;
        for (ScopMirror mirror : this.mirrors) {
            try {
                URL url = new URL(mirror.getComURL(this.scopVersion));
                String localFileName = this.getComFilename();
                File localFile = new File(localFileName);
                this.downloadFileFromRemote(url, localFile);
                return;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        throw new IOException("Unable to download SCOP .com file", exception);
    }

    protected void downloadFileFromRemote(URL remoteURL, File localFile) throws IOException {
        logger.info("Downloading " + remoteURL + " to: " + localFile);
        FileDownloadUtils.createValidationFiles((URL)remoteURL, (File)localFile, null, (FileDownloadUtils.Hash)FileDownloadUtils.Hash.UNKNOWN);
        FileDownloadUtils.downloadFile((URL)remoteURL, (File)localFile);
        if (!FileDownloadUtils.validateFile((File)localFile)) {
            throw new IOException("Downloaded file invalid: " + localFile);
        }
    }

    private boolean claFileAvailable() {
        String fileName = this.getClaFilename();
        File f = new File(fileName);
        return f.exists() && FileDownloadUtils.validateFile((File)f);
    }

    private boolean desFileAvailable() {
        String fileName = this.getDesFilename();
        File f = new File(fileName);
        return f.exists() && FileDownloadUtils.validateFile((File)f);
    }

    private boolean hieFileAvailable() {
        String fileName = this.getHieFilename();
        File f = new File(fileName);
        return f.exists() && FileDownloadUtils.validateFile((File)f);
    }

    private boolean comFileAvailable() {
        String fileName = this.getComFilename();
        File f = new File(fileName);
        return f.exists() && FileDownloadUtils.validateFile((File)f);
    }

    protected String getClaFilename() {
        return this.cacheLocation + claFileName + this.scopVersion;
    }

    protected String getDesFilename() {
        return this.cacheLocation + desFileName + this.scopVersion;
    }

    protected String getHieFilename() {
        return this.cacheLocation + hieFileName + this.scopVersion;
    }

    protected String getComFilename() {
        return this.cacheLocation + comFileName + this.scopVersion;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public void setCacheLocation(String cacheLocation) {
        if (!((String)cacheLocation).endsWith(FILESPLIT)) {
            cacheLocation = (String)cacheLocation + FILESPLIT;
        }
        this.cacheLocation = cacheLocation;
    }

    @Override
    public String getScopVersion() {
        return this.scopVersion;
    }

    @Override
    public void setScopVersion(String scopVersion) {
        if (scopVersion == null) {
            throw new NullPointerException("Null scop version");
        }
        if (this.scopVersion.equals(scopVersion)) {
            return;
        }
        this.scopVersion = scopVersion;
        this.installedCla.set(false);
        this.installedDes.set(false);
        this.installedHie.set(false);
        this.installedCom.set(false);
    }

    public void addMirror(String scopDownloadURL) {
        this.mirrors.add(new ScopMirror(scopDownloadURL));
    }

    void addMirror(ScopMirror scopURLs) {
        this.mirrors.add(scopURLs);
    }

    public List<ScopMirror> getMirrors() {
        if (this.mirrors.isEmpty()) {
            this.initScopURLs();
        }
        return this.mirrors;
    }

    @Override
    public List<ScopDomain> getScopDomainsBySunid(Integer sunid) {
        try {
            this.ensureClaInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        ArrayList<ScopDomain> domains = new ArrayList<ScopDomain>();
        for (String pdbId : this.domainMap.keySet()) {
            for (ScopDomain d : this.domainMap.get(pdbId)) {
                try {
                    if (d.getPx() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getSpeciesId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getDomainId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getFamilyId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getSuperfamilyId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getFoldId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    if (d.getClassId() == sunid.intValue()) {
                        domains.add((ScopDomain)d.clone());
                        continue;
                    }
                    throw new RuntimeException("Type " + d + " not recognized");
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(ScopDomain.class + " subclass does not support clone()", e);
                }
            }
        }
        return domains;
    }

    @Override
    public List<String> getComments(int sunid) {
        try {
            this.ensureComInstalled();
        }
        catch (IOException e) {
            throw new ScopIOException(e);
        }
        if (!this.commentsMap.containsKey(sunid)) {
            return new ArrayList<String>(1);
        }
        return this.commentsMap.get(sunid);
    }

    private void initScopURLs() {
        if (!this.mirrors.isEmpty()) {
            return;
        }
        ScopMirror primary = new ScopMirror();
        ScopMirror alt = new ScopMirror("http://scop.berkeley.edu/downloads/parse/", "dir.cla.scop.%s.txt", "dir.des.scop.%s.txt", "dir.hie.scop.%s.txt", "dir.com.scop.%s.txt");
        this.mirrors.add(primary);
        this.mirrors.add(alt);
    }
}

