/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.Author;

public class JournalArticle
implements Serializable {
    private static final long serialVersionUID = 5062668226159515468L;
    private List<Author> authorList = new ArrayList<Author>();
    private List<Author> editorList = new ArrayList<Author>();
    private String title = "";
    private String ref = "";
    private String journalName = "";
    private String volume;
    private String startPage;
    private int publicationDate;
    private String publisher = "";
    private String refn = "";
    private String pmid = "";
    private String doi = "";
    private boolean published = false;

    public List<Author> getAuthorList() {
        return this.authorList;
    }

    public void setAuthorList(List<Author> authorList) {
        this.authorList = authorList;
    }

    public List<Author> getEditorList() {
        return this.editorList;
    }

    public void setEditorList(List<Author> editorList) {
        this.editorList = editorList;
    }

    public String getDoi() {
        return this.doi;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public void setIsPublished(Boolean state) {
        this.published = state;
    }

    public String getPmid() {
        return this.pmid;
    }

    public void setPmid(String pmid) {
        this.pmid = pmid;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getRefn() {
        return this.refn;
    }

    public void setRefn(String refn) {
        this.refn = refn;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    public int getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(int publicationDate) {
        this.publicationDate = publicationDate;
    }

    public boolean isPublished() {
        return this.published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        this.startPage = startPage;
    }

    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        StringBuilder jrnlString = new StringBuilder();
        StringBuilder authString = new StringBuilder("JRNL        AUTH   ");
        StringBuilder titlString = new StringBuilder("JRNL        TITL   ");
        StringBuilder editString = new StringBuilder("JRNL        EDIT   ");
        StringBuilder refString = new StringBuilder("JRNL        REF    ");
        StringBuilder publString = new StringBuilder("JRNL        PUBL   ");
        StringBuilder refnString = new StringBuilder("JRNL        REFN                   ");
        StringBuilder pmidString = new StringBuilder("JRNL        PMID   ");
        StringBuilder doiString = new StringBuilder("JRNL        DOI    ");
        for (Author author : this.authorList) {
            authString.append(author).append(",");
        }
        jrnlString.append((CharSequence)authString).append(eol);
        titlString.append(this.title);
        jrnlString.append((CharSequence)titlString).append(eol);
        if (!this.editorList.isEmpty()) {
            for (Author editor : this.editorList) {
                editString.append(editor).append(",");
            }
            jrnlString.append((CharSequence)editString).append(eol);
        }
        refString.append(this.ref);
        jrnlString.append((CharSequence)refString).append(eol);
        if (!"".equals(this.publisher)) {
            publString.append(this.publisher);
            jrnlString.append((CharSequence)publString).append(eol);
        }
        if (!"".equals(this.refn)) {
            refnString.append(this.refn);
            jrnlString.append((CharSequence)refnString).append(eol);
        }
        if (!"".equals(this.pmid)) {
            pmidString.append(this.pmid);
            jrnlString.append((CharSequence)pmidString).append(eol);
        }
        if (!"".equals(this.doi)) {
            doiString.append(this.doi);
            jrnlString.append((CharSequence)doiString).append(eol);
        }
        return jrnlString.toString();
    }
}

