/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.core.alignment.matrices.ScaledSubstitutionMatrix;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.ce.MatrixListener;
import org.biojava.nbio.structure.align.model.AFP;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.nbio.structure.align.util.AFPChainScorer;
import org.biojava.nbio.structure.geometry.Matrices;
import org.biojava.nbio.structure.geometry.SuperPositions;
import org.biojava.nbio.structure.jama.Matrix;

public class CECalculator {
    protected static final boolean isPrint = false;
    private static final boolean debug = false;
    int[] f1;
    int[] f2;
    double[][] dist1;
    double[][] dist2;
    protected double[][] mat;
    protected int[] bestTrace1;
    protected int[] bestTrace2;
    protected int[][] bestTraces1;
    protected int[][] bestTraces2;
    protected int nBestTrace;
    protected int nBestTraces;
    double[] d_ = new double[20];
    protected int[] bestTracesN;
    protected double bestTraceScore;
    protected int nTrace;
    protected double[] bestTracesScores;
    protected int[] trace1;
    protected int[] trace2;
    protected static final double zThr = -0.1;
    long timeStart = System.currentTimeMillis();
    long timeEnd;
    private int nAtom;
    private int[] align_se1;
    private int[] align_se2;
    private int lcmp;
    private int[] bestTraceLen;
    private Matrix r;
    private Atom t;
    protected int nTraces;
    private double z;
    private int[] traceIndexContainer;
    protected CeParameters params;
    protected static final int nIter = 1;
    private static final boolean distAll = false;
    List<MatrixListener> matrixListeners;
    private static final double[] scoreAv8 = new double[]{2.54, 2.51, 2.72, 3.01, 3.31, 3.61, 3.9, 4.19, 4.47, 4.74, 4.99, 5.22, 5.46, 5.7, 5.94, 6.13, 6.36, 6.52, 6.68, 6.91};
    private static final double[] scoreSd8 = new double[]{1.33, 0.88, 0.73, 0.71, 0.74, 0.8, 0.86, 0.92, 0.98, 1.04, 1.08, 1.1, 1.15, 1.19, 1.23, 1.25, 1.32, 1.34, 1.36, 1.45};
    private static final double[] gapsAv8 = new double[]{0.0, 11.5, 23.32, 35.95, 49.02, 62.44, 76.28, 90.26, 104.86, 119.97, 134.86, 150.54, 164.86, 179.57, 194.39, 209.38, 224.74, 238.96, 253.72, 270.79};
    private static final double[] gapsSd8 = new double[]{0.0, 9.88, 14.34, 17.99, 21.1, 23.89, 26.55, 29.0, 31.11, 33.1, 35.02, 36.03, 37.19, 38.82, 41.04, 43.35, 45.45, 48.41, 50.87, 52.27};
    private static final double[] scoreAv6 = new double[]{1.98, 1.97, 2.22, 2.54, 2.87, 3.18, 3.48, 3.77, 4.05, 4.31, 4.57, 4.82, 5.03, 5.24, 5.43, 5.64, 5.82, 6.02, 6.21, 6.42};
    private static final double[] scoreSd6 = new double[]{1.15, 0.73, 0.63, 0.64, 0.71, 0.8, 0.87, 0.95, 1.01, 1.07, 1.13, 1.19, 1.22, 1.25, 1.28, 1.32, 1.35, 1.39, 1.45, 1.5};
    private static final double[] gapsAv6 = new double[]{0.0, 10.12, 20.25, 31.29, 42.95, 55.2, 67.53, 80.15, 93.3, 106.47, 120.52, 134.38, 148.59, 162.58, 176.64, 191.23, 204.12, 218.64, 231.82, 243.43};
    private static final double[] gapsSd6 = new double[]{0.0, 9.8, 14.44, 18.14, 21.35, 24.37, 27.0, 29.68, 32.22, 34.37, 36.65, 38.63, 40.31, 42.16, 43.78, 44.98, 47.08, 49.09, 50.78, 52.15};
    private static final double[] tableZtoP = new double[]{1.0, 0.92, 0.841, 0.764, 0.689, 0.617, 0.549, 0.484, 0.424, 0.368, 0.317, 0.271, 0.23, 0.194, 0.162, 0.134, 0.11, 0.0891, 0.0719, 0.0574, 0.0455, 0.0357, 0.0278, 0.0214, 0.0164, 0.0124, 0.00932, 0.00693, 0.00511, 0.00373, 0.0027, 0.00194, 0.00137, 9.67E-4, 6.74E-4, 4.65E-4, 3.18E-4, 2.16E-4, 1.45E-4, 9.62E-5, 6.33E-5, 4.13E-5, 2.67E-5, 1.71E-5, 1.08E-5, 6.8E-6, 4.22E-6, 2.6E-6, 1.59E-6, 9.58E-7, 5.73E-7, 3.4E-7, 1.99E-7, 1.16E-7, 6.66E-8, 3.8E-8, 2.14E-8, 1.2E-8, 6.63E-9, 3.64E-9, 1.97E-9, 1.06E-9, 5.65E-10, 2.98E-10, 1.55E-10, 8.03E-11, 4.11E-11, 2.08E-11, 1.05E-11, 5.2E-12, 2.56E-12, 1.25E-12, 6.02E-13, 2.88E-13, 1.36E-13, 6.38E-14, 2.96E-14, 1.36E-14, 6.19E-15, 2.79E-15, 1.24E-15, 5.5E-16, 2.4E-16, 1.04E-16, 4.46E-17, 1.9E-17, 7.97E-18, 3.32E-18, 1.37E-18, 5.58E-19, 2.26E-19, 9.03E-20, 3.58E-20, 1.4E-20, 5.46E-21, 2.1E-21, 7.99E-22, 3.02E-22, 1.13E-22, 4.16E-23, 1.52E-23, 5.52E-24, 1.98E-24, 7.05E-25, 2.48E-25, 8.64E-26, 2.98E-26, 1.02E-26, 3.44E-27, 1.15E-27, 3.82E-28, 1.25E-28, 4.08E-29, 1.31E-29, 4.18E-30, 1.32E-30, 4.12E-31, 1.27E-31, 3.9E-32, 1.18E-32, 3.55E-33, 1.06E-33, 3.11E-34, 9.06E-35, 2.61E-35, 7.47E-36, 2.11E-36, 5.91E-37, 1.64E-37, 4.5E-38, 1.22E-38, 3.29E-39, 8.77E-40, 2.31E-40, 6.05E-41, 1.56E-41, 4.0E-42, 1.02E-42, 2.55E-43, 6.33E-44, 1.56E-44, 3.8E-45, 9.16E-46, 2.19E-46, 5.17E-47, 1.21E-47, 2.81E-48, 6.45E-49, 1.46E-49, 3.3E-50};
    private static final double[] tablePtoZ = new double[]{0.0, 0.73, 1.24, 1.64, 1.99, 2.3, 2.58, 2.83, 3.07, 3.29, 3.5, 3.7, 3.89, 4.07, 4.25, 4.42, 4.58, 4.74, 4.89, 5.04, 5.19, 5.33, 5.46, 5.6, 5.73, 5.86, 5.99, 6.11, 6.23, 6.35, 6.47, 6.58, 6.7, 6.81, 6.92, 7.02, 7.13, 7.24, 7.34, 7.44, 7.54, 7.64, 7.74, 7.84, 7.93, 8.03, 8.12, 8.21, 8.3, 8.4, 8.49, 8.57, 8.66, 8.75, 8.84, 8.92, 9.01, 9.09, 9.17, 9.25, 9.34, 9.42, 9.5, 9.58, 9.66, 9.73, 9.81, 9.89, 9.97, 10.04, 10.12, 10.19, 10.27, 10.34, 10.41, 10.49, 10.56, 10.63, 10.7, 10.77, 10.84, 10.91, 10.98, 11.05, 11.12, 11.19, 11.26, 11.32, 11.39, 11.46, 11.52, 11.59, 11.66, 11.72, 11.79, 11.85, 11.91, 11.98, 12.04, 12.1, 12.17, 12.23, 12.29, 12.35, 12.42, 12.48, 12.54, 12.6, 12.66, 12.72, 12.78, 12.84, 12.9, 12.96, 13.02, 13.07, 13.13, 13.19, 13.25, 13.31, 13.36, 13.42, 13.48, 13.53, 13.59, 13.65, 13.7, 13.76, 13.81, 13.87, 13.92, 13.98, 14.03, 14.09, 14.14, 14.19, 14.25, 14.3, 14.35, 14.41, 14.46, 14.51, 14.57, 14.62, 14.67, 14.72, 14.77, 14.83, 14.88, 14.93};

    public CECalculator(CeParameters params) {
        this.dist1 = new double[0][0];
        this.dist2 = new double[0][0];
        this.params = params;
        this.matrixListeners = new ArrayList<MatrixListener>();
    }

    public AFPChain extractFragments(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        int nse1 = ca1.length;
        int nse2 = ca2.length;
        afpChain.setCa1Length(nse1);
        afpChain.setCa2Length(nse2);
        int traceMaxSize = nse1 < nse2 ? nse1 : nse2;
        this.f1 = new int[nse1];
        this.f2 = new int[nse2];
        this.dist1 = this.initIntraDistmatrix(ca1, nse1);
        this.dist2 = this.initIntraDistmatrix(ca2, nse2);
        if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.SEQUENCE_CONSERVATION && this.params.getSeqWeight() < 1.0) {
            this.params.setSeqWeight(2.0);
        }
        int winSize = this.params.getWinSize();
        int winSizeComb1 = (winSize - 1) * (winSize - 2) / 2;
        this.traceIndexContainer = new int[traceMaxSize];
        for (int i = 0; i < traceMaxSize; ++i) {
            this.traceIndexContainer[i] = (i + 1) * i * winSize / 2 + (i + 1) * winSizeComb1;
        }
        this.mat = this.initSumOfDistances(nse1, nse2, winSize, winSizeComb1, ca1, ca2);
        return afpChain;
    }

    private double getDistanceWithSidechain(Atom ca1, Atom ca2) throws StructureException {
        if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.CA_SCORING) {
            return Calc.getDistance(ca1, ca2);
        }
        Group g1 = ca1.getGroup();
        Atom cb1 = null;
        if (g1.hasAtom("CB")) {
            cb1 = g1.getAtom("CB");
        }
        Group g2 = ca2.getGroup();
        Atom cb2 = null;
        if (g2.hasAtom("CB")) {
            cb2 = g2.getAtom("CB");
        }
        if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.SIDE_CHAIN_SCORING) {
            double dist = cb1 != null && cb2 != null ? Calc.getDistance(cb1, cb2) : Calc.getDistance(ca1, ca2);
            return dist;
        }
        if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.SIDE_CHAIN_ANGLE_SCORING) {
            double dist;
            if (cb1 != null && cb2 != null) {
                Atom c1 = Calc.subtract(cb1, ca1);
                Atom c2 = Calc.subtract(cb2, ca2);
                Atom newA = Calc.subtract(c2, c1);
                dist = Calc.amount(newA);
            } else {
                dist = 0.0;
            }
            return dist;
        }
        if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.CA_AND_SIDE_CHAIN_ANGLE_SCORING) {
            double dist = 0.0;
            if (cb1 != null && cb2 != null) {
                Atom cacb1 = Calc.subtract(cb1, ca1);
                Atom cacb2 = Calc.subtract(cb2, ca2);
                Atom newA = Calc.subtract(cacb2, cacb1);
                dist += Calc.amount(newA);
            }
            return dist += Calc.getDistance(ca1, ca2);
        }
        if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.SEQUENCE_CONSERVATION) {
            double dist = cb1 != null && cb2 != null ? Calc.getDistance(cb1, cb2) : Calc.getDistance(ca1, ca2);
            return dist;
        }
        return Calc.getDistance(ca1, ca2);
    }

    private double[][] initIntraDistmatrix(Atom[] ca, int nse) throws StructureException {
        double[][] intraDist = new double[nse][nse];
        for (int ise1 = 0; ise1 < nse; ++ise1) {
            for (int ise2 = 0; ise2 < nse; ++ise2) {
                intraDist[ise1][ise2] = this.getDistanceWithSidechain(ca[ise1], ca[ise2]);
            }
        }
        return intraDist;
    }

    public double[][] initSumOfDistances(int nse1, int nse2, int winSize, int winSizeComb1, Atom[] ca1, Atom[] ca2) {
        double[][] mat = new double[nse1][nse2];
        for (int ise1 = 0; ise1 < nse1; ++ise1) {
            for (int ise2 = 0; ise2 < nse2; ++ise2) {
                mat[ise1][ise2] = -1.0;
                if (ise1 > nse1 - winSize || ise2 > nse2 - winSize) continue;
                double d = 0.0;
                for (int is1 = 0; is1 < winSize - 2; ++is1) {
                    for (int is2 = is1 + 2; is2 < winSize; ++is2) {
                        d += Math.abs(this.dist1[ise1 + is1][ise1 + is2] - this.dist2[ise2 + is1][ise2 + is2]);
                    }
                }
                mat[ise1][ise2] = d / (double)winSizeComb1;
            }
        }
        return mat;
    }

    public void traceFragmentMatrix(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        double rmsdThr = this.params.getRmsdThr();
        double oldBestTraceScore = 10000.0;
        this.bestTraceScore = 100.0;
        this.nBestTrace = 0;
        int nBestTrace0 = 0;
        int winSize = this.params.getWinSize();
        int winSizeComb1 = (winSize - 1) * (winSize - 2) / 2;
        boolean distAll = false;
        int winSizeComb2 = distAll ? winSize * winSize : winSize;
        double rmsdThrJoin = this.params.getRmsdThrJoin();
        int nse1 = ca1.length;
        int nse2 = ca2.length;
        int traceMaxSize = nse1 < nse2 ? nse1 : nse2;
        this.bestTrace1 = new int[traceMaxSize];
        this.bestTrace2 = new int[traceMaxSize];
        this.trace1 = new int[traceMaxSize];
        this.trace2 = new int[traceMaxSize];
        int[] traceIndex = new int[traceMaxSize];
        int[] traceIterLevel = new int[traceMaxSize];
        int gapMax = this.params.getMaxGapSize();
        int iterDepth = gapMax > 0 ? gapMax * 2 + 1 : traceMaxSize;
        double[][] traceScore = new double[traceMaxSize][iterDepth];
        this.nTraces = 0;
        long tracesLimit = 50000000L;
        double score = -1.0;
        double score0 = -1.0;
        double score1 = -1.0;
        double score2 = -1.0;
        int jse1 = 0;
        int jse2 = 0;
        int bestTracesMax = 30;
        this.bestTraces1 = new int[bestTracesMax][traceMaxSize];
        this.bestTraces2 = new int[bestTracesMax][traceMaxSize];
        this.bestTracesN = new int[bestTracesMax];
        this.bestTracesScores = new double[bestTracesMax];
        for (int it = 0; it < bestTracesMax; ++it) {
            this.bestTracesN[it] = 0;
            this.bestTracesScores[it] = 100.0;
        }
        this.nBestTraces = 0;
        int newBestTrace = 0;
        double traceTotalScore = 0.0;
        double traceScoreMax = 0.0;
        double userRMSDMax = this.params.getMaxOptRMSD();
        for (int iter = 0; !(iter >= 1 || iter > 2 && oldBestTraceScore <= this.bestTraceScore); ++iter) {
            int ise22;
            int ise21;
            int ise12;
            int ise11;
            oldBestTraceScore = this.bestTraceScore;
            if (iter == 1) {
                double z0 = this.zStrAlign(winSize, this.nBestTrace, this.bestTraceScore, this.bestTrace1[this.nBestTrace] + winSize - this.bestTrace1[0] + this.bestTrace2[this.nBestTrace] + winSize - this.bestTrace2[0] - this.nBestTrace * 2 * winSize);
                if (z0 < -0.1) break;
                nBestTrace0 = this.nBestTrace;
                this.nBestTrace = 0;
                this.bestTraceScore = 100.0;
                this.nTraces = 0;
            }
            if (iter == 0) {
                ise11 = 0;
                ise12 = nse1;
                ise21 = 0;
                ise22 = nse2;
            } else {
                if (iter == 1) {
                    ise11 = this.bestTrace1[0];
                    ise12 = this.bestTrace1[0] + 1;
                    ise21 = this.bestTrace2[0];
                    ise22 = this.bestTrace2[0] + 1;
                } else {
                    ise11 = this.bestTrace1[0] - 1;
                    ise12 = this.bestTrace1[0] + 2;
                    ise21 = this.bestTrace2[0] - 1;
                    ise22 = this.bestTrace2[0] + 2;
                }
                if (ise11 < 0) {
                    ise11 = 0;
                }
                if (ise12 > nse1) {
                    ise12 = nse1;
                }
                if (ise21 < 0) {
                    ise21 = 0;
                }
                if (ise22 > nse2) {
                    ise22 = nse2;
                }
            }
            for (int ise1_ = ise11; ise1_ < ise12; ++ise1_) {
                for (int ise2_ = ise21; ise2_ < ise22; ++ise2_) {
                    int ise1 = ise1_;
                    int ise2 = ise2_;
                    if (iter > 1 && ise1 == ise11 + 1 && ise2 == ise21 + 1 || iter == 0 && (ise1 > nse1 - winSize * (this.nBestTrace - 1) || ise2 > nse2 - winSize * (this.nBestTrace - 1)) || this.mat[ise1][ise2] < 0.0 || this.mat[ise1][ise2] > rmsdThr || this.mat[ise1][ise2] > userRMSDMax) continue;
                    this.nTrace = 0;
                    this.trace1[this.nTrace] = ise1;
                    this.trace2[this.nTrace] = ise2;
                    traceIndex[this.nTrace] = 0;
                    traceIterLevel[this.nTrace] = 0;
                    score0 = this.mat[ise1][ise2];
                    ++this.nTrace;
                    boolean isTraceUp = true;
                    int traceIndex_ = 0;
                    while (this.nTrace > 0) {
                        int jdir;
                        int jgap;
                        int kse2;
                        int kse1 = this.trace1[this.nTrace - 1] + winSize;
                        for (kse2 = this.trace2[this.nTrace - 1] + winSize; kse1 <= nse1 - winSize - 1 && kse2 <= nse2 - winSize - 1 && !(this.mat[kse1][kse2] >= 0.0); ++kse1, ++kse2) {
                        }
                        traceIndex_ = -1;
                        if (isTraceUp) {
                            int nBestExtTrace = this.nTrace;
                            double bestExtScore = 100.0;
                            for (int it = 0; it < iterDepth; ++it) {
                                int mse2;
                                int mse1;
                                jgap = (it + 1) / 2;
                                jdir = (it + 1) % 2;
                                if (jdir == 0) {
                                    mse1 = kse1 + jgap;
                                    mse2 = kse2;
                                } else {
                                    mse1 = kse1;
                                    mse2 = kse2 + jgap;
                                }
                                if (mse1 > nse1 - winSize - 1 || mse2 > nse2 - winSize - 1 || this.mat[mse1][mse2] < 0.0 || this.mat[mse1][mse2] > rmsdThr || this.mat[mse1][mse2] > userRMSDMax) continue;
                                ++this.nTraces;
                                if ((long)this.nTraces > tracesLimit) {
                                    return;
                                }
                                score = 0.0;
                                score = this.getScoreFromDistanceMatrices(mse1, mse2, winSize);
                                score1 = score / (double)(this.nTrace * winSize);
                                if (score1 > rmsdThrJoin || score1 > userRMSDMax) continue;
                                score2 = score1;
                                if (this.nTrace <= nBestExtTrace && (this.nTrace != nBestExtTrace || !(score2 < bestExtScore))) continue;
                                bestExtScore = score2;
                                nBestExtTrace = this.nTrace;
                                traceIndex_ = it;
                                traceScore[this.nTrace - 1][traceIndex_] = score1;
                            }
                        }
                        if (traceIndex_ != -1) {
                            jgap = (traceIndex_ + 1) / 2;
                            jdir = (traceIndex_ + 1) % 2;
                            if (jdir == 0) {
                                jse1 = kse1 + jgap;
                                jse2 = kse2;
                            } else {
                                jse1 = kse1;
                                jse2 = kse2 + jgap;
                            }
                            if (iter == 0) {
                                score1 = (traceScore[this.nTrace - 1][traceIndex_] * (double)winSizeComb2 * (double)this.nTrace + this.mat[jse1][jse2] * (double)winSizeComb1) / (double)(winSizeComb2 * this.nTrace + winSizeComb1);
                                score2 = this.getScore2(jse1, jse2, traceScore, traceIndex_, traceIndex, winSizeComb1, winSizeComb2, score0, score1);
                                if (score2 > rmsdThrJoin) {
                                    traceIndex_ = -1;
                                } else if (score2 > userRMSDMax) {
                                    traceIndex_ = -1;
                                } else {
                                    traceScore[this.nTrace - 1][traceIndex_] = score2;
                                    traceTotalScore = score2;
                                }
                            } else {
                                if (traceScoreMax > rmsdThrJoin && this.nBestTrace >= nBestTrace0) {
                                    traceIndex_ = -1;
                                }
                                traceTotalScore = traceScoreMax;
                            }
                        }
                        if (traceIndex_ == -1) {
                            --this.nTrace;
                            isTraceUp = false;
                            continue;
                        }
                        int n = this.nTrace - 1;
                        traceIterLevel[n] = traceIterLevel[n] + 1;
                        this.trace1[this.nTrace] = jse1;
                        this.trace2[this.nTrace] = jse2;
                        traceIndex[this.nTrace] = traceIndex_;
                        traceIterLevel[this.nTrace] = 0;
                        ++this.nTrace;
                        isTraceUp = true;
                        if (this.nTrace > this.nBestTrace || this.nTrace == this.nBestTrace && this.bestTraceScore > traceTotalScore) {
                            for (int itrace = 0; itrace < this.nTrace; ++itrace) {
                                this.bestTrace1[itrace] = this.trace1[itrace];
                                this.bestTrace2[itrace] = this.trace2[itrace];
                            }
                            this.bestTraceScore = traceTotalScore;
                            this.nBestTrace = this.nTrace;
                        }
                        if (iter != 0) continue;
                        newBestTrace = this.doIter0(newBestTrace, traceTotalScore, bestTracesMax);
                    }
                }
            }
        }
        if (this.params.isShowAFPRanges()) {
            System.out.println("fragment length: " + this.params.getWinSize());
            System.out.println("ntraces : " + this.nTraces);
        }
    }

    protected double getScore2(int jse1, int jse2, double[][] traceScore, int traceIndex_, int[] traceIndex, int winSizeComb1, int winSizeComb2, double score0, double score1) {
        double val = 0.0;
        val = this.nTrace > 1 ? traceScore[this.nTrace - 2][traceIndex[this.nTrace - 1]] : score0;
        double score2 = (val * (double)this.traceIndexContainer[this.nTrace - 1] + score1 * (double)(this.traceIndexContainer[this.nTrace] - this.traceIndexContainer[this.nTrace - 1])) / (double)this.traceIndexContainer[this.nTrace];
        return score2;
    }

    protected int doIter0(int newBestTrace, double traceTotalScore, double bestTracesMax) {
        if (this.nTrace > this.bestTracesN[newBestTrace] || this.nTrace == this.bestTracesN[newBestTrace] && this.bestTracesScores[newBestTrace] > traceTotalScore) {
            for (int itrace = 0; itrace < this.nTrace; ++itrace) {
                this.bestTraces1[newBestTrace][itrace] = this.trace1[itrace];
                this.bestTraces2[newBestTrace][itrace] = this.trace2[itrace];
                this.bestTracesN[newBestTrace] = this.nTrace;
                this.bestTracesScores[newBestTrace] = traceTotalScore;
            }
            if (this.nTrace > this.nBestTrace) {
                this.nBestTrace = this.nTrace;
            }
            if ((double)this.nBestTraces < bestTracesMax) {
                ++this.nBestTraces;
                ++newBestTrace;
            }
            if ((double)this.nBestTraces == bestTracesMax) {
                newBestTrace = 0;
                double scoreTmp = this.bestTracesScores[0];
                int nTraceTmp = this.bestTracesN[0];
                for (int ir = 1; ir < this.nBestTraces; ++ir) {
                    if (this.bestTracesN[ir] >= nTraceTmp && (this.bestTracesN[ir] != nTraceTmp || !(scoreTmp < this.bestTracesScores[ir]))) continue;
                    nTraceTmp = this.bestTracesN[ir];
                    scoreTmp = this.bestTracesScores[ir];
                    newBestTrace = ir;
                }
            }
        }
        return newBestTrace;
    }

    protected double getScoreFromDistanceMatrices(int mse1, int mse2, int winSize) {
        double score = 0.0;
        for (int itrace = 0; itrace < this.nTrace; ++itrace) {
            score += Math.abs(this.dist1[this.trace1[itrace]][mse1] - this.dist2[this.trace2[itrace]][mse2]);
            score += Math.abs(this.dist1[this.trace1[itrace] + winSize - 1][mse1 + winSize - 1] - this.dist2[this.trace2[itrace] + winSize - 1][mse2 + winSize - 1]);
            for (int id = 1; id < winSize - 1; ++id) {
                score += Math.abs(this.dist1[this.trace1[itrace] + id][mse1 + winSize - 1 - id] - this.dist2[this.trace2[itrace] + id][mse2 + winSize - 1 - id]);
            }
        }
        return score;
    }

    public void nextStep(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (this.nBestTrace > 0) {
            this.checkBestTraces(afpChain, ca1, ca2);
        } else {
            this.noBestTrace();
        }
        this.convertAfpChain(afpChain, ca1, ca2);
        AFPAlignmentDisplay.getAlign(afpChain, ca1, ca2);
        double tmScore = AFPChainScorer.getTMScore(afpChain, ca1, ca2, false);
        afpChain.setTMScore(tmScore);
    }

    private void checkBestTraces(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws StructureException {
        int jt;
        double rmsdNew;
        this.z = 0.0;
        int winSize = this.params.getWinSize();
        int nse1 = ca1.length;
        int nse2 = ca2.length;
        int traceMaxSize = nse1 < nse2 ? nse1 : nse2;
        this.align_se1 = new int[nse1 + nse2];
        this.align_se2 = new int[nse1 + nse2];
        this.lcmp = 0;
        Atom[] strBuf1 = new Atom[traceMaxSize];
        Atom[] strBuf2 = new Atom[traceMaxSize];
        double rmsd = 100.0;
        int iBestTrace = 0;
        for (int ir = 0; ir < this.nBestTraces; ++ir) {
            if (this.bestTracesN[ir] != this.nBestTrace || !(rmsd > (rmsdNew = this.getRMSDForBestTrace(ir, strBuf1, strBuf2, this.bestTracesN, this.bestTraces1, this.bestTrace2, winSize, ca1, ca2)))) continue;
            iBestTrace = ir;
            rmsd = rmsdNew;
        }
        for (int it = 0; it < this.bestTracesN[iBestTrace]; ++it) {
            this.bestTrace1[it] = this.bestTraces1[iBestTrace][it];
            this.bestTrace2[it] = this.bestTraces2[iBestTrace][it];
        }
        this.nBestTrace = this.bestTracesN[iBestTrace];
        this.bestTraceScore = this.bestTracesScores[iBestTrace];
        int[] traceLen = new int[traceMaxSize];
        this.bestTraceLen = new int[traceMaxSize];
        int strLen = 0;
        strLen = 0;
        int nGaps = 0;
        this.nTrace = this.nBestTrace;
        for (jt = 0; jt < this.nBestTrace; ++jt) {
            this.trace1[jt] = this.bestTrace1[jt];
            this.trace2[jt] = this.bestTrace2[jt];
            traceLen[jt] = winSize;
            if (jt >= this.nBestTrace - 1) continue;
            nGaps += this.bestTrace1[jt + 1] - this.bestTrace1[jt] - winSize + this.bestTrace2[jt + 1] - this.bestTrace2[jt] - winSize;
        }
        this.nBestTrace = 0;
        int it = 0;
        while (it < this.nTrace) {
            int cSize = traceLen[it];
            for (jt = it + 1; jt < this.nTrace && this.trace1[jt] - this.trace1[jt - 1] - traceLen[jt - 1] == 0 && this.trace2[jt] - this.trace2[jt - 1] - traceLen[jt - 1] == 0; ++jt) {
                cSize += traceLen[jt];
            }
            this.bestTrace1[this.nBestTrace] = this.trace1[it];
            this.bestTrace2[this.nBestTrace] = this.trace2[it];
            this.bestTraceLen[this.nBestTrace] = cSize;
            ++this.nBestTrace;
            strLen += cSize;
            it = jt;
        }
        int is = 0;
        for (jt = 0; jt < this.nBestTrace; ++jt) {
            for (int i = 0; i < this.bestTraceLen[jt]; ++i) {
                this.setStrBuf(strBuf1, is + i, ca1, this.bestTrace1[jt] + i);
                this.setStrBuf(strBuf2, is + i, ca2, this.bestTrace2[jt] + i);
            }
            is += this.bestTraceLen[jt];
        }
        rmsd = this.calc_rmsd(strBuf1, strBuf2, strLen, true);
        boolean isCopied = false;
        for (int it2 = 1; it2 < this.nBestTrace; ++it2) {
            boolean wasBest = false;
            block8: for (int idir = -1; idir <= 1 && !wasBest; idir += 2) {
                for (int idep = 1; idep <= winSize / 2; ++idep) {
                    if (!isCopied) {
                        for (jt = 0; jt < this.nBestTrace; ++jt) {
                            this.trace1[jt] = this.bestTrace1[jt];
                            this.trace2[jt] = this.bestTrace2[jt];
                            traceLen[jt] = this.bestTraceLen[jt];
                        }
                    }
                    isCopied = false;
                    int n = it2 - 1;
                    traceLen[n] = traceLen[n] + idir;
                    int n2 = it2;
                    traceLen[n2] = traceLen[n2] - idir;
                    int n3 = it2;
                    this.trace1[n3] = this.trace1[n3] + idir;
                    int n4 = it2;
                    this.trace2[n4] = this.trace2[n4] + idir;
                    is = 0;
                    for (jt = 0; jt < this.nBestTrace; ++jt) {
                        for (int i = 0; i < traceLen[jt]; ++i) {
                            if (ca1[this.trace1[jt] + i].getX() > 1.0E10 || ca2[this.trace2[jt] + i].getX() > 1.0E10) continue block8;
                            strBuf1[is + i] = ca1[this.trace1[jt] + i];
                            strBuf2[is + i] = ca2[this.trace2[jt] + i];
                        }
                        is += traceLen[jt];
                    }
                    rmsdNew = this.calc_rmsd(strBuf1, strBuf2, strLen, true);
                    if (!(rmsdNew < rmsd)) continue block8;
                    for (jt = 0; jt < this.nBestTrace; ++jt) {
                        this.bestTrace1[jt] = this.trace1[jt];
                        this.bestTrace2[jt] = this.trace2[jt];
                        this.bestTraceLen[jt] = traceLen[jt];
                    }
                    isCopied = true;
                    wasBest = true;
                    rmsd = rmsdNew;
                }
            }
        }
        rmsdNew = this.calc_rmsd(strBuf1, strBuf2, strLen, true);
        afpChain.setTotalRmsdIni(rmsdNew);
        afpChain.setTotalLenIni(strBuf1.length);
        this.nAtom = strLen;
        this.z = this.zStrAlign(winSize, strLen / winSize, this.bestTraceScore, nGaps);
        if (this.params.isShowAFPRanges()) {
            System.out.println("win size: " + winSize + " strLen/winSize: " + strLen / winSize + " best trace score: " + String.format("%.2f", this.bestTraceScore) + " nr gaps: " + nGaps + " nr residues: " + this.nAtom);
            System.out.println(String.format("size=%d rmsd=%.2f z=%.1f gaps=%d(%.1f%%) comb=%d", this.nAtom, rmsd, this.z, nGaps, (double)nGaps * 100.0 / (double)this.nAtom, this.nTraces));
            System.out.println("Best Trace, before optimization");
            for (int k = 0; k < this.nBestTrace; ++k) {
                System.out.println(String.format("(%d,%d,%d) ", this.bestTrace1[k] + 1, this.bestTrace2[k] + 1, this.bestTraceLen[k]));
            }
        }
        ArrayList<AFP> afpSet = new ArrayList<AFP>();
        for (int afp = 0; afp < this.nBestTrace; ++afp) {
            AFP afpI = new AFP();
            afpI.setFragLen(this.bestTraceLen[afp]);
            afpI.setP1(this.bestTrace1[afp] + 1);
            afpI.setP2(this.bestTrace2[afp] + 1);
            afpSet.add(afpI);
        }
        afpChain.setAfpSet(afpSet);
        if (this.params.isOptimizeAlignment() && this.z >= -0.1) {
            nGaps = this.optimizeSuperposition(afpChain, nse1, nse2, strLen, rmsd, ca1, ca2, nGaps, strBuf1, strBuf2);
        } else {
            int lali_x_ = 0;
            for (int k = 0; k < this.nBestTrace; ++k) {
                int l;
                for (l = 0; l < this.bestTraceLen[k]; ++l) {
                    this.align_se1[this.lcmp + l] = this.bestTrace1[k] + l;
                    this.align_se2[this.lcmp + l] = this.bestTrace2[k] + l;
                }
                lali_x_ += this.bestTraceLen[k];
                this.lcmp += this.bestTraceLen[k];
                if (k >= this.nBestTrace - 1) continue;
                if (this.bestTrace1[k] + this.bestTraceLen[k] != this.bestTrace1[k + 1]) {
                    l = this.bestTrace1[k] + this.bestTraceLen[k];
                    while (l < this.bestTrace1[k + 1]) {
                        this.align_se1[this.lcmp] = l++;
                        this.align_se2[this.lcmp] = -1;
                        ++this.lcmp;
                    }
                }
                if (this.bestTrace2[k] + this.bestTraceLen[k] == this.bestTrace2[k + 1]) continue;
                l = this.bestTrace2[k] + this.bestTraceLen[k];
                while (l < this.bestTrace2[k + 1]) {
                    this.align_se1[this.lcmp] = -1;
                    this.align_se2[this.lcmp] = l++;
                    ++this.lcmp;
                }
            }
            this.nAtom = lali_x_;
            afpChain.setTotalRmsdOpt(afpChain.getTotalRmsdIni());
        }
        this.timeEnd = System.currentTimeMillis();
        long time_q = this.timeEnd - this.timeStart;
        double gapsP = (double)nGaps * 100.0 / (double)this.nAtom;
        afpChain.setCalculationTime(time_q);
        afpChain.setGapLen(nGaps);
        int[] optLen = new int[]{this.nAtom};
        afpChain.setOptLen(optLen);
        afpChain.setOptLength(this.nAtom);
        afpChain.setAlnLength(this.lcmp);
        afpChain.setProbability(this.z);
    }

    private void setStrBuf(Atom[] strBuf, int i, Atom[] ca, int j) {
        Group parent = ca[j].getGroup();
        int pos = 0;
        String atomName = ca[j].getName();
        Atom a = null;
        a = parent.getAtom(atomName);
        if (a != null) {
            strBuf[i] = a;
        }
        strBuf[i + pos] = a;
        ++pos;
    }

    private double getRMSDForBestTrace(int ir, Atom[] strBuf1, Atom[] strBuf2, int[] bestTracesN2, int[][] bestTraces12, int[] bestTrace22, int winSize, Atom[] ca1, Atom[] ca2) throws StructureException {
        int is = 0;
        for (int jt = 0; jt < this.bestTracesN[ir]; ++jt) {
            for (int i = 0; i < winSize; ++i) {
                this.setStrBuf(strBuf1, is + i, ca1, this.bestTraces1[ir][jt] + i);
                this.setStrBuf(strBuf2, is + i, ca2, this.bestTraces2[ir][jt] + i);
            }
            is += winSize;
        }
        double rmsdNew = this.calc_rmsd(strBuf1, strBuf2, this.bestTracesN[ir] * winSize, true);
        return rmsdNew;
    }

    private void checkPrintRmsdNew(int traceMaxSize, int winSize, Atom[] ca1, Atom[] ca2) throws StructureException {
        int is = 0;
        Atom[] strBuf1 = new Atom[traceMaxSize];
        Atom[] strBuf2 = new Atom[traceMaxSize];
        for (int jt = 0; jt < this.nBestTrace; ++jt) {
            for (int i = 0; i < winSize; ++i) {
                this.setStrBuf(strBuf1, is + i, ca1, this.bestTrace1[jt] + i);
                this.setStrBuf(strBuf2, is + i, ca2, this.bestTrace2[jt] + i);
            }
            is += winSize;
        }
        double rmsdNew = this.calc_rmsd(strBuf1, strBuf2, this.nBestTrace * winSize, true);
    }

    private static char getOneLetter(Group g) {
        if (g == null) {
            return 'X';
        }
        return StructureTools.get1LetterCode(g.getPDBName()).charValue();
    }

    private int optimizeSuperposition(AFPChain afpChain, int nse1, int nse2, int strLen, double rmsd, Atom[] ca1, Atom[] ca2, int nGaps, Atom[] strBuf1, Atom[] strBuf2) throws StructureException {
        Atom[] ca3 = new Atom[nse2];
        double rmsdLen = 0.0;
        boolean isRmsdLenAssigned = false;
        int nAtomPrev = -1;
        double oRmsdThr = this.params.getORmsdThr();
        double distanceIncrement = this.params.getDistanceIncrement();
        double maxUserRMSD = this.params.getMaxOptRMSD();
        this.nAtom = 0;
        int counter = -1;
        int maxNrIterations = this.params.getMaxNrIterationsForOptimization();
        while (((double)this.nAtom < (double)strLen * 0.95 || isRmsdLenAssigned && rmsd < rmsdLen * 1.1 && nAtomPrev != this.nAtom) && counter < maxNrIterations) {
            ++counter;
            nAtomPrev = this.nAtom;
            oRmsdThr += distanceIncrement;
            this.rot_mol(ca2, ca3, nse2, this.r, this.t);
            for (int ise1 = 0; ise1 < nse1; ++ise1) {
                for (int ise2 = 0; ise2 < nse2; ++ise2) {
                    double dist = this.getDistanceWithSidechain(ca1[ise1], ca3[ise2]);
                    this.mat[ise1][ise2] = oRmsdThr - dist;
                }
            }
            if (this.params.getScoringStrategy() == CeParameters.ScoringStrategy.SEQUENCE_CONSERVATION) {
                this.mat = CECalculator.updateMatrixWithSequenceConservation(this.mat, ca1, ca2, this.params);
            }
            this.mat = this.notifyMatrixListener(this.mat);
            double gapOpen = this.params.getGapOpen();
            double gapExtension = this.params.getGapExtension();
            double score = this.dpAlign(nse1, nse2, gapOpen, gapExtension, false, false);
            afpChain.setAlignScore(score);
            this.nAtom = 0;
            nGaps = 0;
            for (int ia = 0; ia < this.lcmp; ++ia) {
                if (this.align_se1[ia] != -1 && this.align_se2[ia] != -1) {
                    strBuf1[this.nAtom] = ca1[this.align_se1[ia]];
                    strBuf2[this.nAtom] = ca2[this.align_se2[ia]];
                    ++this.nAtom;
                    continue;
                }
                ++nGaps;
            }
            if (this.nAtom < 4) continue;
            rmsd = this.calc_rmsd(strBuf1, strBuf2, this.nAtom, false);
            if ((double)this.nAtom >= (double)strLen * 0.95 && !isRmsdLenAssigned) {
                rmsdLen = rmsd;
                isRmsdLenAssigned = true;
            }
            afpChain.setBlockRmsd(new double[]{rmsd});
            afpChain.setOptRmsd(new double[]{rmsd});
            afpChain.setTotalRmsdOpt(rmsd);
            afpChain.setChainRmsd(rmsd);
            if (!(rmsd >= maxUserRMSD)) continue;
            break;
        }
        this.nBestTrace = 0;
        boolean newBestTrace = true;
        for (int ia = 0; ia < this.lcmp; ++ia) {
            if (this.align_se1[ia] != -1 && this.align_se2[ia] != -1) {
                if (newBestTrace) {
                    this.bestTrace1[this.nBestTrace] = this.align_se1[ia];
                    this.bestTrace2[this.nBestTrace] = this.align_se2[ia];
                    this.bestTraceLen[this.nBestTrace] = 0;
                    newBestTrace = false;
                    ++this.nBestTrace;
                }
                int n = this.nBestTrace - 1;
                this.bestTraceLen[n] = this.bestTraceLen[n] + 1;
                continue;
            }
            newBestTrace = true;
        }
        return nGaps;
    }

    public static double[][] updateMatrixWithSequenceConservation(double[][] max, Atom[] ca1, Atom[] ca2, CeParameters params) {
        Matrix origM = new Matrix(max);
        SubstitutionMatrix<AminoAcidCompound> substMatrix = params.getSubstitutionMatrix();
        int internalScale = 1;
        if (substMatrix instanceof ScaledSubstitutionMatrix) {
            ScaledSubstitutionMatrix scaledMatrix = (ScaledSubstitutionMatrix)substMatrix;
            internalScale = scaledMatrix.getScale();
        }
        AminoAcidCompoundSet set = AminoAcidCompoundSet.getAminoAcidCompoundSet();
        for (int i = 0; i < origM.getRowDimension(); ++i) {
            for (int j = 0; j < origM.getColumnDimension(); ++j) {
                double val = origM.get(i, j);
                Atom a1 = ca1[i];
                Atom a2 = ca2[j];
                AminoAcidCompound ac1 = set.getCompoundForString(a1.getGroup().getChemComp().getOneLetterCode());
                AminoAcidCompound ac2 = set.getCompoundForString(a2.getGroup().getChemComp().getOneLetterCode());
                if (ac1 == null || ac2 == null) continue;
                short aaScore = substMatrix.getValue((Compound)ac1, (Compound)ac2);
                double weightedScore = (double)(aaScore / internalScale) * params.getSeqWeight();
                origM.set(i, j, val += weightedScore);
            }
        }
        max = origM.getArray();
        return max;
    }

    private double[][] notifyMatrixListener(double[][] mat2) {
        for (MatrixListener li : this.matrixListeners) {
            mat2 = li.matrixInOptimizer(mat2);
        }
        return mat2;
    }

    private boolean[][] notifyBreakFlagListener(boolean[][] brkFlag) {
        for (MatrixListener li : this.matrixListeners) {
            brkFlag = li.initializeBreakFlag(brkFlag);
        }
        return brkFlag;
    }

    public void addMatrixListener(MatrixListener li) {
        this.matrixListeners.add(li);
    }

    private double dpAlign(int nSeq1, int nSeq2, double gapI, double gapE, boolean isGlobal1, boolean isGlobal2) {
        double sum_brk;
        int k;
        double sum;
        int j;
        int i;
        boolean ge = gapE != 0.0;
        boolean[][] brk_flg = new boolean[nSeq1][nSeq2];
        for (i = 0; i < nSeq1; ++i) {
            brk_flg[i] = new boolean[nSeq2];
        }
        brk_flg = this.notifyBreakFlagListener(brk_flg);
        if (!ge) {
            for (i = nSeq1 - 1; i >= 0; --i) {
                for (j = nSeq2 - 1; j >= 0; --j) {
                    brk_flg[i][j] = false;
                    if (j < nSeq2 - 1 && i < nSeq1 - 1) {
                        sum = this.mat[i + 1][j + 1];
                    } else {
                        sum = 0.0;
                        if (isGlobal1 && i != nSeq1 - 1 || isGlobal2 && j != nSeq2 - 1) {
                            sum = -gapI;
                        }
                    }
                    if (j + 1 < nSeq2) {
                        for (k = i + 2; k < nSeq1; ++k) {
                            if (!(this.mat[k][j + 1] - gapI > sum)) continue;
                            sum = this.mat[k][j + 1] - gapI;
                        }
                    }
                    if (i + 1 < nSeq1) {
                        for (k = j + 2; k < nSeq2; ++k) {
                            if (!(this.mat[i + 1][k] - gapI > sum)) continue;
                            sum = this.mat[i + 1][k] - gapI;
                        }
                    }
                    if ((sum += this.mat[i][j]) < (sum_brk = (isGlobal1 ? -gapI : 0.0) + (isGlobal2 ? -gapI : 0.0))) {
                        sum = sum_brk;
                        brk_flg[i][j] = true;
                    }
                    this.mat[i][j] = sum;
                }
            }
        } else {
            for (i = nSeq1 - 1; i >= 0; --i) {
                for (j = nSeq2 - 1; j >= 0; --j) {
                    brk_flg[i][j] = false;
                    if (j < nSeq2 - 1 && i < nSeq1 - 1) {
                        sum = this.mat[i + 1][j + 1];
                    } else {
                        sum = 0.0;
                        if (isGlobal1 && i != nSeq1 - 1) {
                            sum = -gapI - gapE * (double)(nSeq1 - i - 1);
                        }
                        if (isGlobal2 && j != nSeq2 - 1) {
                            sum = -gapI - gapE * (double)(nSeq2 - j - 1);
                        }
                    }
                    if (j + 1 < nSeq2) {
                        for (k = i + 2; k < nSeq1; ++k) {
                            if (!(this.mat[k][j + 1] - gapI - gapE * (double)(k - i - 1) > sum)) continue;
                            sum = this.mat[k][j + 1] - gapI - gapE * (double)(k - i - 1);
                        }
                    }
                    if (i + 1 < nSeq1) {
                        for (k = j + 2; k < nSeq2; ++k) {
                            if (!(this.mat[i + 1][k] - gapI - gapE * (double)(k - j - 1) > sum)) continue;
                            sum = this.mat[i + 1][k] - gapI - gapE * (double)(k - j - 1);
                        }
                    }
                    if ((sum += this.mat[i][j]) < (sum_brk = (isGlobal1 ? -gapI - gapE * (double)(nSeq1 - 1 - i) : 0.0) + (isGlobal2 ? -gapI - gapE * (double)(nSeq2 - 1 - j) : 0.0))) {
                        sum = sum_brk;
                        brk_flg[i][j] = true;
                    }
                    this.mat[i][j] = sum;
                }
            }
        }
        int is = 0;
        int js = 0;
        this.lcmp = 0;
        double sum_ret = this.mat[0][0];
        for (i = 0; i < nSeq1; ++i) {
            for (j = 0; j < nSeq2; ++j) {
                if (i == 0 && j == 0) continue;
                sum = this.mat[i][j];
                if (isGlobal1) {
                    sum += -gapI - gapE * (double)i;
                }
                if (isGlobal2) {
                    sum += -gapI - gapE * (double)j;
                }
                if (!(sum > sum_ret)) continue;
                sum_ret = sum;
                is = i;
                js = j;
            }
        }
        i = is;
        for (j = js; i < nSeq1 && j < nSeq2; ++i, ++j) {
            int iMax = i;
            int jMax = j;
            sum = this.mat[i][j];
            if (!ge) {
                for (k = i + 1; k < nSeq1; ++k) {
                    if (!(this.mat[k][j] - gapI > sum)) continue;
                    iMax = k;
                    jMax = j;
                    sum = this.mat[k][j] - gapI;
                }
                for (k = j + 1; k < nSeq2; ++k) {
                    if (!(this.mat[i][k] - gapI > sum)) continue;
                    iMax = i;
                    jMax = k;
                    sum = this.mat[i][k] - gapI;
                }
            } else {
                for (k = i + 1; k < nSeq1; ++k) {
                    if (!(this.mat[k][j] - gapI - gapE * (double)(k - i) > sum)) continue;
                    iMax = k;
                    jMax = j;
                    sum = this.mat[k][j] - gapI - gapE * (double)(k - i);
                }
                for (k = j + 1; k < nSeq2; ++k) {
                    if (!(this.mat[i][k] - gapI - gapE * (double)(k - j) > sum)) continue;
                    iMax = i;
                    jMax = k;
                    sum = this.mat[i][k] - gapI - gapE * (double)(k - j);
                }
            }
            k = i;
            while (k < iMax) {
                this.align_se1[this.lcmp] = k++;
                this.align_se2[this.lcmp] = -1;
                ++this.lcmp;
                ++i;
            }
            k = j;
            while (k < jMax) {
                this.align_se1[this.lcmp] = -1;
                this.align_se2[this.lcmp] = k++;
                ++this.lcmp;
                ++j;
            }
            this.align_se1[this.lcmp] = iMax;
            this.align_se2[this.lcmp] = jMax;
            ++this.lcmp;
            if (brk_flg[i][j]) break;
        }
        return sum_ret;
    }

    private void rot_mol(Atom[] caA, Atom[] caB, int nse2, Matrix m, Atom shift) throws StructureException {
        for (int l = 0; l < nse2; ++l) {
            Atom a = caA[l];
            Group g = (Group)a.getGroup().clone();
            Calc.rotate(g, m);
            Calc.shift(g, shift);
            caB[l] = g.getAtom(a.getName());
        }
    }

    public double calc_rmsd(Atom[] pro1, Atom[] pro2, int strLen, boolean storeTransform) throws StructureException {
        Atom[] cod1 = this.getAtoms(pro1, strLen, false);
        Atom[] cod2 = this.getAtoms(pro2, strLen, true);
        Matrix4d trans = SuperPositions.superpose(Calc.atomsToPoints(cod1), Calc.atomsToPoints(cod2));
        Matrix matrix = Matrices.getRotationJAMA(trans);
        Atom shift = Calc.getTranslationVector(trans);
        if (storeTransform) {
            this.r = matrix;
            this.t = shift;
        }
        for (Atom a : cod2) {
            Calc.transform(a.getGroup(), trans);
        }
        return Calc.rmsd(cod1, cod2);
    }

    private Atom[] getAtoms(Atom[] ca, int length, boolean clone) throws StructureException {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (int i = 0; i < length; ++i) {
            Atom a;
            if (clone) {
                Group g = (Group)ca[i].getGroup().clone();
                a = g.getAtom(ca[i].getName());
            } else {
                a = ca[i];
            }
            atoms.add(a);
        }
        return atoms.toArray(new Atom[atoms.size()]);
    }

    private void noBestTrace() {
    }

    private double zToP(double z) {
        int ind = (int)(z / 0.1);
        if (ind < 0) {
            ind = 0;
        }
        if (ind > 149) {
            ind = 149;
        }
        return tableZtoP[ind];
    }

    private double pToZ(double p) {
        int ind = (int)(-Math.log10(p) * 3.0);
        if (ind < 0) {
            ind = 0;
        }
        if (ind > 149) {
            ind = 149;
        }
        return tablePtoZ[ind];
    }

    private double zByZ(double z1, double z2) {
        double p1 = this.zToP(z1);
        double p2 = this.zToP(z2);
        return this.pToZ(p1 * p2);
    }

    protected double zStrAlign(int winSize, int nTrace, double score, int nGaps) {
        double z1 = this.zScore(winSize, nTrace, score);
        double z2 = this.zGaps(winSize, nTrace, nGaps);
        return this.zByZ(z1, z2);
    }

    double zScore(int winSize, int nTrace, double score) {
        if (winSize == 8) {
            double scoreSd_;
            double scoreAv_;
            if (nTrace < 1) {
                return 0.0;
            }
            if (nTrace < 21) {
                scoreAv_ = scoreAv8[nTrace - 1];
                scoreSd_ = scoreSd8[nTrace - 1];
            } else {
                scoreAv_ = 0.209874 * (double)nTrace + 2.944714;
                scoreSd_ = 0.039487 * (double)nTrace + 0.675735;
            }
            if (score > scoreAv_) {
                return 0.0;
            }
            return (scoreAv_ - score) / scoreSd_;
        }
        if (winSize == 6) {
            double scoreSd_;
            double scoreAv_;
            if (nTrace < 1) {
                return 0.0;
            }
            if (nTrace < 21) {
                scoreAv_ = scoreAv6[nTrace - 1];
                scoreSd_ = scoreSd6[nTrace - 1];
            } else {
                scoreAv_ = 0.198534 * (double)nTrace + 2.636477;
                scoreSd_ = 0.040922 * (double)nTrace + 0.715636;
            }
            if (score > scoreAv_) {
                return 0.0;
            }
            return (scoreAv_ - score) / scoreSd_;
        }
        return 0.0;
    }

    double zGaps(int winSize, int nTrace, int nGaps) {
        if (nTrace < 2) {
            return 0.0;
        }
        if (winSize == 8) {
            double scoreSd_;
            double scoreAv_;
            if (nTrace < 21) {
                scoreAv_ = gapsAv8[nTrace - 1];
                scoreSd_ = gapsSd8[nTrace - 1];
            } else {
                scoreAv_ = 14.949173 * (double)nTrace - 14.581193;
                scoreSd_ = 2.045067 * (double)nTrace + 13.191095;
            }
            if ((double)nGaps > scoreAv_) {
                return 0.0;
            }
            return (scoreAv_ - (double)nGaps) / scoreSd_;
        }
        if (winSize == 6) {
            double scoreSd_;
            double scoreAv_;
            if (nTrace < 21) {
                scoreAv_ = gapsAv6[nTrace - 1];
                scoreSd_ = gapsSd6[nTrace - 1];
            } else {
                scoreAv_ = 13.57449 * (double)nTrace - 13.977223;
                scoreSd_ = 1.719977 * (double)nTrace + 19.615014;
            }
            if ((double)nGaps > scoreAv_) {
                return 0.0;
            }
            return (scoreAv_ - (double)nGaps) / scoreSd_;
        }
        return 0.0;
    }

    public void convertAfpChain(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        afpChain.setBlockNum(1);
        Matrix[] m = this.r != null ? new Matrix[]{this.r} : new Matrix[]{};
        Atom[] as = this.t != null ? new Atom[]{this.t} : new Atom[]{};
        afpChain.setBlockRotationMatrix(m);
        afpChain.setBlockShiftVector(as);
        int nse1 = ca1.length;
        int nse2 = ca2.length;
        if (nse1 > 0 && this.dist1.length > 0) {
            afpChain.setDisTable1(new Matrix(this.dist1));
        } else {
            afpChain.setDisTable1(Matrix.identity(3, 3));
        }
        if (nse2 > 0 && this.dist2.length > 0) {
            afpChain.setDisTable2(new Matrix(this.dist2));
        } else {
            afpChain.setDisTable2(Matrix.identity(3, 3));
        }
        char[] alnseq1 = new char[nse1 + nse2 + 1];
        char[] alnseq2 = new char[nse1 + nse2 + 1];
        char[] alnsymb = new char[nse1 + nse2 + 1];
        int[][][] optAln = new int[1][2][this.nAtom];
        afpChain.setOptAln(optAln);
        int pos = 0;
        int nrIdent = 0;
        int nrSim = 0;
        for (int ia = 0; ia < this.lcmp; ++ia) {
            char l1;
            if (this.align_se1[ia] != -1 && this.align_se2[ia] != -1) {
                optAln[0][0][pos] = this.align_se1[ia];
                optAln[0][1][pos] = this.align_se2[ia];
                l1 = CECalculator.getOneLetter(ca1[this.align_se1[ia]].getGroup());
                char l2 = CECalculator.getOneLetter(ca2[this.align_se2[ia]].getGroup());
                alnseq1[ia] = Character.toUpperCase(l1);
                alnseq2[ia] = Character.toUpperCase(l2);
                alnsymb[ia] = 32;
                if (l1 == l2) {
                    ++nrIdent;
                    ++nrSim;
                    alnsymb[ia] = 124;
                } else if (AFPAlignmentDisplay.aaScore(l1, l2) > 0) {
                    ++nrSim;
                    alnsymb[ia] = 58;
                }
                ++pos;
                continue;
            }
            alnsymb[ia] = 32;
            if (this.align_se1[ia] == -1) {
                alnseq1[ia] = 45;
            } else {
                l1 = CECalculator.getOneLetter(ca1[this.align_se1[ia]].getGroup());
                alnseq1[ia] = Character.toUpperCase(l1);
            }
            if (this.align_se2[ia] == -1) {
                alnseq2[ia] = 45;
                continue;
            }
            char l2 = CECalculator.getOneLetter(ca2[this.align_se2[ia]].getGroup());
            alnseq2[ia] = Character.toUpperCase(l2);
        }
        afpChain.setAlnseq1(alnseq1);
        afpChain.setAlnseq2(alnseq2);
        afpChain.setAlnsymb(alnsymb);
        if (pos > 0) {
            afpChain.setIdentity((double)nrIdent * 1.0 / (double)pos);
            afpChain.setSimilarity((double)nrSim * 1.0 / (double)pos);
        } else {
            afpChain.setIdentity(0.0);
            afpChain.setSimilarity(0.0);
        }
    }

    public int getnAtom() {
        return this.nAtom;
    }

    public void setnAtom(int nAtom) {
        this.nAtom = nAtom;
    }

    public int getLcmp() {
        return this.lcmp;
    }

    public void setLcmp(int lcmp) {
        this.lcmp = lcmp;
    }

    public int[] getAlign_se1() {
        return this.align_se1;
    }

    public void setAlign_se1(int[] alignSe1) {
        this.align_se1 = alignSe1;
    }

    public int[] getAlign_se2() {
        return this.align_se2;
    }

    public void setAlign_se2(int[] alignSe2) {
        this.align_se2 = alignSe2;
    }

    public double[][] getMatMatrix() {
        return this.mat;
    }

    public void setMatMatrix(double[][] matrix) {
        this.mat = matrix;
    }

    public Matrix getRotationMatrix() {
        return this.r;
    }

    public Atom getShift() {
        return this.t;
    }

    public double[][] getDist1() {
        return this.dist1;
    }

    public void setDist1(double[][] dist1) {
        this.dist1 = dist1;
    }

    public double[][] getDist2() {
        return this.dist2;
    }

    public void setDist2(double[][] dist2) {
        this.dist2 = dist2;
    }
}

