/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class MethodInvocationTreeImpl
extends AbstractTypedTree
implements MethodInvocationTree {
    private final ExpressionTree methodSelect;
    private final List<ExpressionTree> arguments;

    public MethodInvocationTreeImpl(AstNode astNode, ExpressionTree methodSelect, List<ExpressionTree> arguments) {
        super(astNode);
        this.methodSelect = Preconditions.checkNotNull(methodSelect);
        this.arguments = Preconditions.checkNotNull(arguments);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.METHOD_INVOCATION;
    }

    public List<Tree> typeArguments() {
        return ImmutableList.of();
    }

    public ExpressionTree methodSelect() {
        return this.methodSelect;
    }

    public List<ExpressionTree> arguments() {
        return this.arguments;
    }

    public void accept(TreeVisitor visitor) {
        visitor.visitMethodInvocation((MethodInvocationTree)this);
    }
}

