/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class NewClassTreeImpl
extends AbstractTypedTree
implements NewClassTree {
    private final ExpressionTree enclosingExpression;
    private final ExpressionTree identifier;
    private final List<ExpressionTree> arguments;
    @Nullable
    private final ClassTree classBody;

    public NewClassTreeImpl(AstNode astNode, @Nullable ExpressionTree enclosingExpression, ExpressionTree identifier, List<ExpressionTree> arguments, @Nullable ClassTree classBody) {
        super(astNode);
        this.enclosingExpression = enclosingExpression;
        this.identifier = Preconditions.checkNotNull(identifier);
        this.arguments = Preconditions.checkNotNull(arguments);
        this.classBody = classBody;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NEW_CLASS;
    }

    @Nullable
    public ExpressionTree enclosingExpression() {
        return this.enclosingExpression;
    }

    public List<Tree> typeArguments() {
        return ImmutableList.of();
    }

    public Tree identifier() {
        return this.identifier;
    }

    public List<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Nullable
    public ClassTree classBody() {
        return this.classBody;
    }

    public void accept(TreeVisitor visitor) {
        visitor.visitNewClass((NewClassTree)this);
    }
}

