/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import org.sonar.java.resolve.BytecodeCompleter;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;

public class Symbols {
    final Symbol.PackageSymbol rootPackage = new Symbol.PackageSymbol("", null);
    final Symbol.PackageSymbol defaultPackage = new Symbol.PackageSymbol("", this.rootPackage);
    final Symbol.TypeSymbol predefClass = new Symbol.TypeSymbol(1, "", this.rootPackage);
    final Type.ClassType unknownType;
    final Symbol.TypeSymbol unknownSymbol;
    final Symbol.TypeSymbol arrayClass;
    final Symbol.TypeSymbol methodClass;
    final Symbol.TypeSymbol noSymbol;
    final Type byteType;
    final Type charType;
    final Type shortType;
    final Type intType;
    final Type longType;
    final Type floatType;
    final Type doubleType;
    final Type booleanType;
    final Type nullType;
    final Type voidType;
    final Type objectType;
    final Type cloneableType;
    final Type serializableType;
    final Type classType;
    final Type stringType;

    public Symbols(BytecodeCompleter bytecodeCompleter) {
        this.predefClass.members = new Scope(this.predefClass);
        ((Type.ClassType)this.predefClass.type).interfaces = ImmutableList.of();
        this.unknownSymbol = new Symbol.TypeSymbol(1, "", this.rootPackage);
        this.unknownSymbol.members = new Scope(this.unknownSymbol);
        this.unknownType = new Type.ClassType(this.unknownSymbol){

            @Override
            public String toString() {
                return "!unknown!";
            }
        };
        this.unknownType.tag = 14;
        this.unknownType.interfaces = ImmutableList.of();
        this.unknownSymbol.type = this.unknownType;
        this.noSymbol = new Symbol.TypeSymbol(0, "", this.rootPackage);
        this.methodClass = new Symbol.TypeSymbol(1, "", this.noSymbol);
        this.byteType = this.initType(1, "byte");
        this.charType = this.initType(2, "char");
        this.shortType = this.initType(3, "short");
        this.intType = this.initType(4, "int");
        this.longType = this.initType(5, "long");
        this.floatType = this.initType(6, "float");
        this.doubleType = this.initType(7, "double");
        this.booleanType = this.initType(8, "boolean");
        this.nullType = this.initType(13, "<nulltype>");
        this.voidType = this.initType(9, "void");
        bytecodeCompleter.init(this);
        Symbol.PackageSymbol javalang = bytecodeCompleter.enterPackage("java.lang");
        javalang.members = new Scope.StarImportScope(javalang, bytecodeCompleter);
        javalang.members.enter(javalang);
        this.objectType = bytecodeCompleter.loadClass((String)"java.lang.Object").type;
        this.classType = bytecodeCompleter.loadClass((String)"java.lang.Class").type;
        this.stringType = bytecodeCompleter.loadClass((String)"java.lang.String").type;
        this.cloneableType = bytecodeCompleter.loadClass((String)"java.lang.Cloneable").type;
        this.serializableType = bytecodeCompleter.loadClass((String)"java.io.Serializable").type;
        this.arrayClass = new Symbol.TypeSymbol(1, "Array", this.noSymbol);
        Type.ClassType arrayClassType = (Type.ClassType)this.arrayClass.type;
        arrayClassType.supertype = this.objectType;
        arrayClassType.interfaces = ImmutableList.of(this.cloneableType, this.serializableType);
        this.arrayClass.members = new Scope(this.arrayClass);
        this.arrayClass.members().enter(new Symbol.VariableSymbol(17, "length", this.intType, (Symbol)this.arrayClass));
        this.enterOperators();
    }

    private Type initType(int tag, String name) {
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(1, name, this.rootPackage);
        symbol.members = new Scope(symbol);
        this.predefClass.members.enter(symbol);
        ((Type.ClassType)symbol.type).interfaces = ImmutableList.of();
        symbol.type.tag = tag;
        return symbol.type;
    }

    private void enterOperators() {
        for (String op : new String[]{"+", "-", "*", "/", "%"}) {
            for (Type type : Arrays.asList(this.doubleType, this.floatType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, type);
            }
        }
        for (String op : new String[]{"&", "|", "^"}) {
            for (Type type : Arrays.asList(this.booleanType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, type);
            }
        }
        for (String op : new String[]{"<<", ">>", ">>>"}) {
            this.enterBinop(op, this.longType, this.longType, this.longType);
            this.enterBinop(op, this.intType, this.longType, this.intType);
            this.enterBinop(op, this.longType, this.intType, this.longType);
            this.enterBinop(op, this.intType, this.intType, this.intType);
        }
        for (String op : new String[]{"<", ">", ">=", "<="}) {
            for (Type type : Arrays.asList(this.doubleType, this.floatType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, this.booleanType);
            }
        }
        for (String op : new String[]{"==", "!="}) {
            for (Type type : Arrays.asList(this.objectType, this.booleanType, this.doubleType, this.floatType, this.longType, this.intType)) {
                this.enterBinop(op, type, type, this.booleanType);
            }
        }
        this.enterBinop("&&", this.booleanType, this.booleanType, this.booleanType);
        this.enterBinop("||", this.booleanType, this.booleanType, this.booleanType);
        for (Type type : Arrays.asList(this.nullType, this.objectType, this.booleanType, this.doubleType, this.floatType, this.longType, this.intType)) {
            this.enterBinop("+", this.stringType, type, this.stringType);
            this.enterBinop("+", type, this.stringType, this.stringType);
        }
        this.enterBinop("+", this.stringType, this.stringType, this.stringType);
    }

    private void enterBinop(String name, Type left, Type right, Type result) {
        Type.MethodType type = new Type.MethodType(ImmutableList.of(left, right), result, ImmutableList.<Type>of(), this.methodClass);
        Symbol.MethodSymbol symbol = new Symbol.MethodSymbol(9, name, type, (Symbol)this.predefClass);
        this.predefClass.members.enter(symbol);
    }
}

