/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.matchers.MatcherPathElement;
import org.sonar.sslr.internal.matchers.TextUtils;
import org.sonar.sslr.internal.vm.ErrorTreeNode;
import org.sonar.sslr.parser.ParseError;

public class ParseErrorFormatter {
    private static final int SNIPPET_SIZE = 10;
    private static final int EXCERPT_SIZE = 40;

    public String format(ParseError parseError) {
        Preconditions.checkNotNull(parseError);
        InputBuffer inputBuffer = parseError.getInputBuffer();
        InputBuffer.Position position = inputBuffer.getPosition(parseError.getErrorIndex());
        StringBuilder sb = new StringBuilder();
        sb.append("Parse error at line ").append(position.getLine()).append(" column ").append(position.getColumn()).append(' ').append(parseError.getMessage()).append('\n');
        sb.append('\n');
        ParseErrorFormatter.appendSnippet(sb, inputBuffer, position);
        sb.append('\n');
        sb.append("Failed at rules:\n");
        ErrorTreeNode tree = ErrorTreeNode.buildTree(parseError.getFailedPaths());
        this.appendTree(sb, inputBuffer, tree);
        return sb.toString();
    }

    private void appendTree(StringBuilder sb, InputBuffer inputBuffer, ErrorTreeNode node) {
        ArrayList<ErrorTreeNode> nodes = Lists.newArrayList();
        while (node.children.size() == 1) {
            nodes.add(node);
            node = node.children.get(0);
        }
        this.appendTree(sb, inputBuffer, node, "", true);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            ParseErrorFormatter.appendPathElement(sb, inputBuffer, ((ErrorTreeNode)nodes.get((int)i)).pathElement);
        }
    }

    private void appendTree(StringBuilder sb, InputBuffer inputBuffer, ErrorTreeNode node, String prefix, boolean isTail) {
        boolean tail = true;
        for (int i = 0; i < node.children.size(); ++i) {
            this.appendTree(sb, inputBuffer, node.children.get(i), prefix + (isTail ? "  " : "| "), tail);
            tail = false;
        }
        sb.append(prefix + (isTail ? "/-" : "+-"));
        ParseErrorFormatter.appendPathElement(sb, inputBuffer, node.pathElement);
    }

    private static void appendPathElement(StringBuilder sb, InputBuffer inputBuffer, MatcherPathElement pathElement) {
        sb.append(((MutableParsingRule)pathElement.getMatcher()).getName());
        if (pathElement.getStartIndex() != pathElement.getEndIndex()) {
            sb.append(" consumed from ").append(inputBuffer.getPosition(pathElement.getStartIndex()).toString()).append(" to ").append(inputBuffer.getPosition(pathElement.getEndIndex() - 1).toString()).append(": ");
            int len = pathElement.getEndIndex() - pathElement.getStartIndex();
            if (len > 40) {
                len = 40;
                sb.append("...");
            }
            sb.append('\"');
            for (int i = pathElement.getEndIndex() - len; i < pathElement.getEndIndex(); ++i) {
                sb.append(TextUtils.escape(inputBuffer.charAt(i)));
            }
            sb.append('\"');
        }
        sb.append('\n');
    }

    private static void appendSnippet(StringBuilder sb, InputBuffer inputBuffer, InputBuffer.Position position) {
        int startLine = Math.max(position.getLine() - 10, 1);
        int endLine = Math.min(position.getLine() + 10, inputBuffer.getLineCount());
        int padding = Integer.toString(endLine).length();
        String lineNumberFormat = "%1$" + padding + "d: ";
        for (int line = startLine; line <= endLine; ++line) {
            sb.append(String.format(lineNumberFormat, line));
            sb.append(TextUtils.trimTrailingLineSeparatorFrom(inputBuffer.extractLine(line)).replace("\t", " ")).append('\n');
            if (line != position.getLine()) continue;
            for (int i = 1; i < position.getColumn() + padding + 2; ++i) {
                sb.append(' ');
            }
            sb.append("^\n");
        }
    }
}

