/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BracketMemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class BracketMemberExpressionTreeImpl
extends JavaScriptTree
implements BracketMemberExpressionTree {
    private ExpressionTree object;
    private final SyntaxToken openBracket;
    private final ExpressionTree property;
    private final SyntaxToken closeBracket;

    public BracketMemberExpressionTreeImpl(InternalSyntaxToken openBracket, ExpressionTree property, InternalSyntaxToken closeBracket) {
        super(Tree.Kind.BRACKET_MEMBER_EXPRESSION);
        this.openBracket = openBracket;
        this.property = property;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, (AstNode)((Object)property), closeBracket);
    }

    public BracketMemberExpressionTreeImpl complete(ExpressionTree object) {
        this.object = object;
        this.prependChildren((AstNode)((Object)object));
        return this;
    }

    @Override
    public ExpressionTree object() {
        return this.object;
    }

    @Override
    public SyntaxToken openBracket() {
        return this.openBracket;
    }

    @Override
    public ExpressionTree property() {
        return this.property;
    }

    @Override
    public SyntaxToken closeBracket() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BRACKET_MEMBER_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.object, this.property);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMemberExpression(this);
    }
}

