/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.DotMemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class DotMemberExpressionTreeImpl
extends JavaScriptTree
implements DotMemberExpressionTree {
    private ExpressionTree object;
    private final SyntaxToken dot;
    private final ExpressionTree property;

    public DotMemberExpressionTreeImpl(InternalSyntaxToken dot, ExpressionTree property) {
        super(Tree.Kind.DOT_MEMBER_EXPRESSION);
        this.dot = dot;
        this.property = property;
        this.addChildren(dot, (AstNode)((Object)property));
    }

    public DotMemberExpressionTreeImpl complete(ExpressionTree object) {
        this.object = object;
        this.prependChildren((AstNode)((Object)object));
        return this;
    }

    @Override
    public ExpressionTree object() {
        return this.object;
    }

    @Override
    public SyntaxToken dot() {
        return this.dot;
    }

    @Override
    public ExpressionTree property() {
        return this.property;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DOT_MEMBER_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.object, this.property);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMemberExpression(this);
    }
}

