/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.ReturnStatementTree;

public class ReturnStatementTreeImpl
extends JavaScriptTree
implements ReturnStatementTree {
    private SyntaxToken returnKeyword;
    private ExpressionTree expression;

    public ReturnStatementTreeImpl(AstNode eos) {
        super(Tree.Kind.RETURN_STATEMENT);
        this.addChild(eos);
    }

    public ReturnStatementTreeImpl(ExpressionTree expression, AstNode eos) {
        super(Tree.Kind.RETURN_STATEMENT);
        this.expression = expression;
        this.addChild((AstNode)((Object)expression));
        this.addChild(eos);
    }

    public ReturnStatementTreeImpl complete(InternalSyntaxToken returnKeyword) {
        Preconditions.checkState(this.returnKeyword == null, "Already completed");
        this.returnKeyword = returnKeyword;
        this.prependChildren(returnKeyword);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.RETURN_STATEMENT;
    }

    @Override
    public SyntaxToken returnKeyword() {
        return this.returnKeyword;
    }

    @Override
    @Nullable
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    @Nullable
    public Tree endOfStatement() {
        throw new UnsupportedOperationException("Not supported yet in the strongly typed AST.");
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator(this.expression);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitReturnStatement(this);
    }
}

