/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser.sslr;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.sonar.javascript.ast.parser.AstNodeSanitizer;
import org.sonar.javascript.parser.sslr.DelayedRuleInvocationExpression;
import org.sonar.javascript.parser.sslr.GrammarBuilder;
import org.sonar.javascript.parser.sslr.Input;
import org.sonar.javascript.parser.sslr.NonterminalBuilder;
import org.sonar.javascript.parser.sslr.Optional;
import org.sonar.javascript.parser.sslr.SyntaxTreeCreator;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.SequenceExpression;
import org.sonar.sslr.internal.vm.StringExpression;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;

public class ActionParser2
extends Parser {
    private final Charset charset;
    private final AstNodeSanitizer astNodeSanitzer = new AstNodeSanitizer();
    private final GrammarBuilderInterceptor grammarBuilderInterceptor;
    private final SyntaxTreeCreator<AstNode> syntaxTreeCreator;
    private final GrammarRuleKey rootRule;
    private final Grammar grammar;
    private final ParseRunner parseRunner;

    public ActionParser2(Charset charset, LexerlessGrammarBuilder b, Class grammarClass, Object treeFactory, GrammarRuleKey rootRule) {
        super(null);
        this.charset = charset;
        this.grammarBuilderInterceptor = new GrammarBuilderInterceptor(b);
        Enhancer grammarEnhancer = new Enhancer();
        grammarEnhancer.setSuperclass(grammarClass);
        grammarEnhancer.setCallback((Callback)this.grammarBuilderInterceptor);
        ActionMethodInterceptor actionMethodInterceptor = new ActionMethodInterceptor(this.grammarBuilderInterceptor);
        Enhancer actionEnhancer = new Enhancer();
        actionEnhancer.setSuperclass(treeFactory.getClass());
        actionEnhancer.setCallback((Callback)actionMethodInterceptor);
        Object grammar = grammarEnhancer.create(new Class[]{GrammarBuilder.class, treeFactory.getClass()}, new Object[]{this.grammarBuilderInterceptor, actionEnhancer.create()});
        for (Method method : grammarClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            try {
                method.invoke(grammar, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate(e);
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate(e);
            }
        }
        this.syntaxTreeCreator = new SyntaxTreeCreator(treeFactory, this.grammarBuilderInterceptor);
        b.setRootRule(rootRule);
        this.rootRule = rootRule;
        this.grammar = b.build();
        this.parseRunner = new ParseRunner(this.grammar.getRootRule());
    }

    public AstNode parse(List tokens) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AstNode parse(File file) {
        try {
            return this.parse(new Input(Files.toString(file, this.charset).toCharArray(), file.toURI()));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public AstNode parse(String source) {
        return this.parse(new Input(source.toCharArray()));
    }

    private AstNode parse(Input input) {
        ParsingResult result = this.parseRunner.parse(input.input());
        if (!result.isMatched()) {
            ParseError parseError = result.getParseError();
            InputBuffer inputBuffer = parseError.getInputBuffer();
            int line = inputBuffer.getPosition(parseError.getErrorIndex()).getLine();
            String message = new ParseErrorFormatter().format(parseError);
            throw new RecognitionException(line, message);
        }
        AstNode astNode = this.syntaxTreeCreator.create(result.getParseTreeRoot(), input);
        this.astNodeSanitzer.sanitize(astNode);
        return astNode;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public void setRootRule(Rule rootRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RuleDefinition getRootRule() {
        throw new UnsupportedOperationException();
    }

    public GrammarRuleKey rootRule() {
        return this.rootRule;
    }

    private static class DummyGrammarRuleKey
    implements GrammarRuleKey {
        private final Method method;
        private final String operator;
        private final ParsingExpression expression;

        public DummyGrammarRuleKey(Method method) {
            this.method = method;
            this.operator = null;
            this.expression = null;
        }

        public DummyGrammarRuleKey(String operator, ParsingExpression expression) {
            this.method = null;
            this.operator = operator;
            this.expression = expression;
        }

        public String toString() {
            if (this.operator != null) {
                return this.operator + "(" + this.expression + ")";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("f.");
            sb.append(this.method.getName());
            sb.append('(');
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length - 1; ++i) {
                sb.append(parameterTypes[i].getSimpleName());
                sb.append(", ");
            }
            if (parameterTypes.length > 0) {
                sb.append(parameterTypes[parameterTypes.length - 1].getSimpleName());
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static class ActionMethodInterceptor
    implements MethodInterceptor {
        private final GrammarBuilderInterceptor grammarBuilderInterceptor;

        public ActionMethodInterceptor(GrammarBuilderInterceptor grammarBuilderInterceptor) {
            this.grammarBuilderInterceptor = grammarBuilderInterceptor;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return proxy.invokeSuper(obj, args);
            }
            GrammarRuleKey ruleKey = this.grammarBuilderInterceptor.ruleKeyForAction(method);
            this.grammarBuilderInterceptor.replaceByRule(ruleKey, args.length);
            return null;
        }
    }

    public static class GrammarBuilderInterceptor
    implements MethodInterceptor,
    GrammarBuilder,
    NonterminalBuilder {
        private final LexerlessGrammarBuilder b;
        private final BiMap<Method, GrammarRuleKey> mapping = HashBiMap.create();
        private final BiMap<Method, GrammarRuleKey> actions = HashBiMap.create();
        private final Set<GrammarRuleKey> optionals = Sets.newHashSet();
        private final Set<GrammarRuleKey> oneOrMores = Sets.newHashSet();
        private final Set<GrammarRuleKey> zeroOrMores = Sets.newHashSet();
        private Method buildingMethod = null;
        private GrammarRuleKey ruleKey = null;
        private final Deque<ParsingExpression> expressionStack = new ArrayDeque<ParsingExpression>();

        public GrammarBuilderInterceptor(LexerlessGrammarBuilder b) {
            this.b = b;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (method.getDeclaringClass().equals(Object.class)) {
                return proxy.invokeSuper(obj, args);
            }
            if (this.buildingMethod != null) {
                this.push(new DelayedRuleInvocationExpression(this.b, this, method));
                return null;
            }
            this.buildingMethod = method;
            return proxy.invokeSuper(obj, args);
        }

        @Override
        public <T> NonterminalBuilder<T> nonterminal() {
            return this.nonterminal(new DummyGrammarRuleKey(this.buildingMethod));
        }

        @Override
        public <T> NonterminalBuilder<T> nonterminal(GrammarRuleKey ruleKey) {
            this.ruleKey = ruleKey;
            this.mapping.put(this.buildingMethod, this.ruleKey);
            return this;
        }

        public Object is(Object method) {
            Preconditions.checkState(this.expressionStack.size() == 1, "Unexpected stack size: " + this.expressionStack.size());
            ParsingExpression expression = this.pop();
            this.b.rule(this.ruleKey).is(expression);
            this.buildingMethod = null;
            this.ruleKey = null;
            return null;
        }

        @Override
        public <T> T firstOf(T ... methods) {
            FirstOfExpression expression = new FirstOfExpression(this.pop(methods.length));
            this.expressionStack.push(expression);
            return null;
        }

        @Override
        public <T> Optional<T> optional(T method) {
            ParsingExpression expression = this.pop();
            DummyGrammarRuleKey ruleKey = new DummyGrammarRuleKey("optional", expression);
            this.optionals.add(ruleKey);
            this.b.rule(ruleKey).is(this.b.optional(expression));
            this.invokeRule(ruleKey);
            return null;
        }

        @Override
        public <T> List<T> oneOrMore(T method) {
            ParsingExpression expression = this.pop();
            DummyGrammarRuleKey ruleKey = new DummyGrammarRuleKey("oneOrMore", expression);
            this.oneOrMores.add(ruleKey);
            this.b.rule(ruleKey).is(this.b.oneOrMore(expression));
            this.invokeRule(ruleKey);
            return null;
        }

        @Override
        public <T> Optional<List<T>> zeroOrMore(T method) {
            ParsingExpression expression = this.pop();
            DummyGrammarRuleKey ruleKey = new DummyGrammarRuleKey("zeroOrMore", expression);
            this.zeroOrMores.add(ruleKey);
            this.b.rule(ruleKey).is(this.b.zeroOrMore(expression));
            this.invokeRule(ruleKey);
            return null;
        }

        @Override
        public AstNode invokeRule(GrammarRuleKey ruleKey) {
            this.push(new DelayedRuleInvocationExpression(this.b, ruleKey));
            return null;
        }

        @Override
        public AstNode token(String value) {
            this.expressionStack.push(new StringExpression(value));
            return null;
        }

        public void replaceByRule(GrammarRuleKey ruleKey, int stackElements) {
            ParsingExpression expression = stackElements == 1 ? this.pop() : new SequenceExpression(this.pop(stackElements));
            this.b.rule(ruleKey).is(expression);
            this.invokeRule(ruleKey);
        }

        private ParsingExpression[] pop(int n) {
            ParsingExpression[] result = new ParsingExpression[n];
            for (int i = n - 1; i >= 0; --i) {
                result[i] = this.pop();
            }
            return result;
        }

        private ParsingExpression pop() {
            return this.expressionStack.pop();
        }

        private void push(ParsingExpression expression) {
            this.expressionStack.push(expression);
        }

        public GrammarRuleKey ruleKeyForAction(Method method) {
            GrammarRuleKey ruleKey = (GrammarRuleKey)this.actions.get(method);
            if (ruleKey == null) {
                method.setAccessible(true);
                ruleKey = new DummyGrammarRuleKey(method);
                this.actions.put(method, ruleKey);
            }
            return ruleKey;
        }

        @Nullable
        public Method actionForRuleKey(Object ruleKey) {
            return (Method)this.actions.inverse().get(ruleKey);
        }

        @Nullable
        public GrammarRuleKey ruleKeyForMethod(Method method) {
            return (GrammarRuleKey)this.mapping.get(method);
        }

        public boolean hasMethodForRuleKey(Object ruleKey) {
            return this.mapping.containsValue(ruleKey);
        }

        public boolean isOptionalRule(Object ruleKey) {
            return this.optionals.contains(ruleKey);
        }

        public boolean isOneOrMoreRule(Object ruleKey) {
            return this.oneOrMores.contains(ruleKey);
        }

        public boolean isZeroOrMoreRule(Object ruleKey) {
            return this.zeroOrMores.contains(ruleKey);
        }
    }
}

