/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser.sslr;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;

public class Input {
    private static final URI FAKE_URI = new File("tests://unittests").toURI();
    private final char[] input;
    private final URI uri;
    private final int[] newLineIndexes;

    public Input(char[] input) {
        this(input, FAKE_URI);
    }

    public Input(char[] input, URI uri) {
        int i;
        this.input = input;
        this.uri = uri;
        ArrayList<Integer> newLineIndexesBuilder = Lists.newArrayList();
        for (i = 0; i < input.length; ++i) {
            if (!Input.isNewLine(input, i)) continue;
            newLineIndexesBuilder.add(i + 1);
        }
        this.newLineIndexes = new int[newLineIndexesBuilder.size()];
        for (i = 0; i < this.newLineIndexes.length; ++i) {
            this.newLineIndexes[i] = (Integer)newLineIndexesBuilder.get(i);
        }
    }

    public char[] input() {
        return this.input;
    }

    public URI uri() {
        return this.uri;
    }

    public String substring(int from, int to) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < to; ++i) {
            sb.append(this.input[i]);
        }
        return sb.toString();
    }

    public int[] lineAndColumnAt(int index) {
        int[] result;
        result = new int[]{this.lineAt(index), index - this.lineStartIndex(result[0]) + 1};
        return result;
    }

    private int lineAt(int index) {
        int i = Arrays.binarySearch(this.newLineIndexes, index);
        return i >= 0 ? i + 2 : -i;
    }

    private int lineStartIndex(int line) {
        return line == 1 ? 0 : this.newLineIndexes[line - 2];
    }

    private static final boolean isNewLine(char[] input, int i) {
        return input[i] == '\n' || input[i] == '\r' && (i + 1 == input.length || input[i + 1] != '\n');
    }
}

