/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser.sslr;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.javascript.parser.sslr.ActionParser2;
import org.sonar.javascript.parser.sslr.Input;
import org.sonar.javascript.parser.sslr.Optional;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;

public class SyntaxTreeCreator<T> {
    private static final TokenType UNDEFINED_TOKEN_TYPE = new TokenType(){

        @Override
        public String getName() {
            return "TOKEN";
        }

        @Override
        public String getValue() {
            return this.getName();
        }

        @Override
        public boolean hasToBeSkippedFromAst(AstNode node) {
            return false;
        }

        public String toString() {
            return SyntaxTreeCreator.class.getSimpleName();
        }
    };
    private final Object treeFactory;
    private final ActionParser2.GrammarBuilderInterceptor mapping;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = Lists.newArrayList();
    private Input input;

    public SyntaxTreeCreator(Object treeFactory, ActionParser2.GrammarBuilderInterceptor mapping) {
        this.treeFactory = treeFactory;
        this.mapping = mapping;
    }

    public T create(ParseNode node, Input input) {
        this.input = input;
        this.trivias.clear();
        Object result = this.visit(node);
        if (result instanceof AstNode) {
            ((AstNode)result).hasToBeSkippedFromAst();
        }
        return (T)result;
    }

    private Object visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private Object visitNonTerminal(ParseNode node) {
        MutableParsingRule rule = (MutableParsingRule)node.getMatcher();
        GrammarRuleKey ruleKey = rule.getRuleKey();
        if (this.mapping.hasMethodForRuleKey(ruleKey)) {
            Preconditions.checkState(node.getChildren().size() == 1);
            return this.visit(node.getChildren().get(0));
        }
        if (this.mapping.isOptionalRule(ruleKey)) {
            Preconditions.checkState(node.getChildren().size() <= 1);
            if (node.getChildren().isEmpty()) {
                return Optional.absent();
            }
            Object child = this.visit(node.getChildren().get(0));
            if (child instanceof AstNode) {
                ((AstNode)child).hasToBeSkippedFromAst();
            }
            return Optional.of(child);
        }
        List<ParseNode> children = node.getChildren();
        ArrayList<Object> convertedChildren = Lists.newArrayList();
        for (ParseNode child : children) {
            Object result = this.visit(child);
            if (result == null) continue;
            if (result instanceof Optional && ((Optional)result).isPresent() && ((Optional)result).get() instanceof AstNode && ((AstNode)((Optional)result).get()).hasToBeSkippedFromAst()) {
                for (AstNode astNode : ((AstNode)((Optional)result).get()).getChildren()) {
                    convertedChildren.add(astNode);
                }
                continue;
            }
            if (result instanceof AstNode && ((AstNode)result).hasToBeSkippedFromAst()) {
                for (AstNode astNode : ((AstNode)result).getChildren()) {
                    convertedChildren.add(astNode);
                }
                continue;
            }
            convertedChildren.add(result);
        }
        if (this.mapping.isOneOrMoreRule(ruleKey)) {
            return Lists.newArrayList(convertedChildren);
        }
        if (this.mapping.isZeroOrMoreRule(ruleKey)) {
            return convertedChildren.isEmpty() ? Optional.absent() : Optional.of(Lists.newArrayList(convertedChildren));
        }
        Method method = this.mapping.actionForRuleKey(ruleKey);
        if (method == null) {
            Token token = null;
            for (Object e : convertedChildren) {
                if (!(e instanceof AstNode) || !((AstNode)e).hasToken()) continue;
                token = ((AstNode)e).getToken();
                break;
            }
            AstNode astNode = new AstNode(rule, rule.getName(), token);
            for (Object e : convertedChildren) {
                astNode.addChild((AstNode)e);
            }
            astNode.setFromIndex(node.getStartIndex());
            astNode.setToIndex(node.getEndIndex());
            return astNode;
        }
        try {
            return method.invoke(this.treeFactory, convertedChildren.toArray(new Object[convertedChildren.size()]));
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate(e);
        }
        catch (IllegalArgumentException e) {
            throw Throwables.propagate(e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate(e);
        }
    }

    private AstNode visitTerminal(ParseNode node) {
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.updateTokenPositionAndValue(node);
                this.tokenBuilder.setTrivia(Collections.<Trivia>emptyList());
                this.tokenBuilder.setType(GenericTokenType.COMMENT);
                this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + (Object)((Object)ruleMatcher.getTriviaKind()));
        }
        if (node.getMatcher() instanceof TokenExpression) {
            this.updateTokenPositionAndValue(node);
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            this.tokenBuilder.setType(ruleMatcher.getTokenType());
            if (ruleMatcher.getTokenType() == GenericTokenType.COMMENT) {
                this.tokenBuilder.setTrivia(Collections.<Trivia>emptyList());
                this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
                return null;
            }
        } else {
            this.updateTokenPositionAndValue(node);
            this.tokenBuilder.setType(UNDEFINED_TOKEN_TYPE);
        }
        Token token = this.tokenBuilder.setTrivia(this.trivias).build();
        this.trivias.clear();
        AstNode astNode = new AstNode(token);
        astNode.setFromIndex(node.getStartIndex());
        astNode.setToIndex(node.getEndIndex());
        return astNode;
    }

    private void updateTokenPositionAndValue(ParseNode node) {
        this.tokenBuilder.setGeneratedCode(false);
        int[] lineAndColumn = this.input.lineAndColumnAt(node.getStartIndex());
        this.tokenBuilder.setLine(lineAndColumn[0]);
        this.tokenBuilder.setColumn(lineAndColumn[1] - 1);
        this.tokenBuilder.setURI(this.input.uri());
        String value = this.input.substring(node.getStartIndex(), node.getEndIndex());
        this.tokenBuilder.setValueAndOriginalValue(value);
    }
}

