/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.python.api.PythonMetric;
import org.sonar.python.api.PythonTokenType;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;

public class FileLinesVisitor
extends SquidAstVisitor<Grammar>
implements AstAndTokenVisitor {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final Set<Integer> linesOfCode = Sets.newHashSet();
    private final Set<Integer> linesOfComments = Sets.newHashSet();
    private final FileSystem fileSystem;

    public FileLinesVisitor(FileLinesContextFactory fileLinesContextFactory, FileSystem fileSystem) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = fileSystem;
    }

    public void visitToken(Token token) {
        if (token.getType().equals(GenericTokenType.EOF)) {
            return;
        }
        if (!(token.getType().equals((Object)PythonTokenType.DEDENT) || token.getType().equals((Object)PythonTokenType.INDENT) || token.getType().equals((Object)PythonTokenType.NEWLINE))) {
            String[] tokenLines = token.getValue().split("\n", -1);
            for (int line = token.getLine(); line < token.getLine() + tokenLines.length; ++line) {
                this.linesOfCode.add(line);
            }
        }
        List trivias = token.getTrivia();
        for (Trivia trivia : trivias) {
            if (!trivia.isComment()) continue;
            this.linesOfComments.add(trivia.getToken().getLine());
        }
    }

    public void leaveFile(AstNode astNode) {
        InputFile inputFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(this.getContext().getFile()));
        if (inputFile == null) {
            throw new IllegalStateException("InputFile is null, but it should not be.");
        }
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        int fileLength = this.getContext().peekSourceCode().getInt((MetricDef)PythonMetric.LINES);
        for (int line = 1; line <= fileLength; ++line) {
            fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
            fileLinesContext.setIntValue("comment_lines_data", line, this.linesOfComments.contains(line) ? 1 : 0);
        }
        fileLinesContext.save();
        this.linesOfCode.clear();
        this.linesOfComments.clear();
    }
}

