/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.builders.booleans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.booleans.InPredicate;
import org.sql.generation.api.grammar.builders.booleans.InBuilder;
import org.sql.generation.api.grammar.common.NonBooleanExpression;
import org.sql.generation.implementation.grammar.booleans.InPredicateImpl;
import org.sql.generation.implementation.grammar.common.SQLBuilderBase;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class InBuilderImpl
extends SQLBuilderBase
implements InBuilder {
    private final NonBooleanExpression _left;
    private final List<NonBooleanExpression> _expressions;

    public InBuilderImpl(SQLProcessorAggregator processor, NonBooleanExpression left) {
        super(processor);
        NullArgumentException.validateNotNull((String)"left", (Object)left);
        this._left = left;
        this._expressions = new ArrayList<NonBooleanExpression>();
    }

    public InBuilder addValues(NonBooleanExpression ... expressions) {
        NullArgumentException.validateNotNull((String)"expressions", (Object)expressions);
        for (NonBooleanExpression exp : expressions) {
            NullArgumentException.validateNotNull((String)"expression", (Object)exp);
        }
        this._expressions.addAll(Arrays.asList(expressions));
        return this;
    }

    public InPredicate createExpression() {
        return new InPredicateImpl(this.getProcessor(), this._left, this._expressions);
    }
}

