/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.builders.definition;

import java.util.ArrayList;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.builders.definition.ForeignKeyConstraintBuilder;
import org.sql.generation.api.grammar.common.TableNameDirect;
import org.sql.generation.api.grammar.definition.table.ForeignKeyConstraint;
import org.sql.generation.api.grammar.definition.table.MatchType;
import org.sql.generation.api.grammar.definition.table.ReferentialAction;
import org.sql.generation.api.grammar.factories.ColumnsFactory;
import org.sql.generation.implementation.grammar.common.SQLBuilderBase;
import org.sql.generation.implementation.grammar.definition.table.ForeignKeyConstraintImpl;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyConstraintBuilderImpl
extends SQLBuilderBase
implements ForeignKeyConstraintBuilder {
    private final List<String> _sourceColumns;
    private final List<String> _targetColumns;
    private TableNameDirect _targetTable;
    private MatchType _matchType;
    private ReferentialAction _onUpdate;
    private ReferentialAction _onDelete;
    private final ColumnsFactory _c;

    public ForeignKeyConstraintBuilderImpl(SQLProcessorAggregator processor, ColumnsFactory c) {
        super(processor);
        NullArgumentException.validateNotNull((String)"Columns factory", (Object)c);
        this._c = c;
        this._sourceColumns = new ArrayList<String>();
        this._targetColumns = new ArrayList<String>();
    }

    public ForeignKeyConstraint createExpression() {
        return new ForeignKeyConstraintImpl(this.getProcessor(), this._c.colNames(this._sourceColumns), this._targetTable, this._targetColumns.size() == 0 ? null : this._c.colNames(this._targetColumns), this._matchType, this._onDelete, this._onUpdate);
    }

    public ForeignKeyConstraintBuilder addSourceColumns(String ... columnNames) {
        for (String name : columnNames) {
            this._sourceColumns.add(name);
        }
        return this;
    }

    public ForeignKeyConstraintBuilder addTargetColumns(String ... columnNames) {
        for (String name : columnNames) {
            this._targetColumns.add(name);
        }
        return this;
    }

    public ForeignKeyConstraintBuilder setTargetTableName(TableNameDirect tableName) {
        this._targetTable = tableName;
        return this;
    }

    public ForeignKeyConstraintBuilder setMatchType(MatchType matchType) {
        this._matchType = matchType;
        return this;
    }

    public ForeignKeyConstraintBuilder setOnUpdate(ReferentialAction action) {
        this._onUpdate = action;
        return this;
    }

    public ForeignKeyConstraintBuilder setOnDelete(ReferentialAction action) {
        this._onDelete = action;
        return this;
    }

    public List<String> getSourceColumns() {
        return this._sourceColumns;
    }

    public List<String> getTargetColumns() {
        return this._targetColumns;
    }

    public TableNameDirect getTableName() {
        return this._targetTable;
    }

    public MatchType getMatchType() {
        return this._matchType;
    }

    public ReferentialAction getOnUpdate() {
        return this._onUpdate;
    }

    public ReferentialAction getOnDelete() {
        return this._onDelete;
    }
}

