/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.transformation.pgsql;

import org.sql.generation.api.vendor.PostgreSQLVendor;
import org.sql.generation.implementation.transformation.QueryProcessing;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

public class QueryProcessing {
    private static final String LEGACY_LIMIT_PREFIX = "LIMIT";
    private static final String LEGACY_LIMIT_POSTFIX = null;
    private static final String LEGACY_OFFSET_PREFIX = "OFFSET";
    private static final String LEGACY_OFFSET_POSTFIX = null;

    public static class PgSQLLimitSpecificationProcessor
    extends QueryProcessing.LimitSpecificationProcessor {
        protected String getPrefix(SQLProcessorAggregator processor) {
            return ((PostgreSQLVendor)processor.getVendor()).legacyOffsetAndLimit() ? QueryProcessing.LEGACY_LIMIT_PREFIX : super.getPrefix(processor);
        }

        protected String getPostfix(SQLProcessorAggregator processor) {
            return ((PostgreSQLVendor)processor.getVendor()).legacyOffsetAndLimit() ? LEGACY_LIMIT_POSTFIX : super.getPostfix(processor);
        }
    }

    public static class PgSQLOffsetSpecificationProcessor
    extends QueryProcessing.OffsetSpecificationProcessor {
        protected String getPrefix(SQLProcessorAggregator processor) {
            return ((PostgreSQLVendor)processor.getVendor()).legacyOffsetAndLimit() ? QueryProcessing.LEGACY_OFFSET_PREFIX : super.getPrefix(processor);
        }

        protected String getPostfix(SQLProcessorAggregator processor) {
            return ((PostgreSQLVendor)processor.getVendor()).legacyOffsetAndLimit() ? LEGACY_OFFSET_POSTFIX : super.getPostfix(processor);
        }
    }

    public static class PgSQLQuerySpecificationProcessor
    extends QueryProcessing.QuerySpecificationProcessor {
        protected boolean isOffsetBeforeLimit(SQLProcessorAggregator processor) {
            return !((PostgreSQLVendor)processor.getVendor()).legacyOffsetAndLimit();
        }
    }
}

