/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce.binary;

import java.util.Hashtable;
import java.util.Vector;
import org.linuxmce.dce.DCEConnectionException;
import org.linuxmce.dce.Message;
import org.linuxmce.dce.MessageDeserializer;
import org.linuxmce.dce.MessageFactory;
import org.linuxmce.dce.util.BinaryData;
import org.linuxmce.dce.util.Serialize;

public class DCEMessageDeserializer
implements MessageDeserializer {
    private MessageFactory messageFactory;

    public DCEMessageDeserializer(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public Message deserialize(BinaryData data) {
        Message message;
        int magicStart = Serialize.readInt(data);
        if (magicStart != 1234) {
            throw new DCEConnectionException("Malformated message: magic number for start is not respected!");
        }
        try {
            message = this.messageFactory.createMessage(Serialize.readInt(data), Serialize.readInt(data), Serialize.readInt(data), Serialize.readInt(data), Serialize.readInt(data), Serialize.readInt(data), Serialize.readInt(data), Serialize.readInt(data), Serialize.readChar(data) != '0', Serialize.readInt(data), Serialize.readInt(data), Serialize.readChar(data) != '0', Serialize.readInt(data), Serialize.readString(data), this.getStringParameters(data), this.getDataParameters(data), this.getExtraMessages(data));
        }
        catch (Exception e) {
            throw new DCEConnectionException("Failed to parse message.", e);
        }
        int magicEnd = Serialize.readInt(data);
        if (magicEnd != 6789) {
            throw new DCEConnectionException("Malformated message: magic number for end message is not respected!");
        }
        return message;
    }

    private Vector getExtraMessages(BinaryData data) {
        Vector<Message> ret = new Vector<Message>();
        int nExtraMessages = Serialize.readInt(data);
        for (int i = 0; i < nExtraMessages; ++i) {
            int messageLength = Serialize.readInt(data);
            Message embed = this.deserialize(data);
            ret.add(embed);
        }
        return ret;
    }

    private Hashtable getDataParameters(BinaryData data) {
        Hashtable<Integer, byte[]> ret = new Hashtable<Integer, byte[]>();
        int nDataParameters = Serialize.readInt(data);
        for (int i = 0; i < nDataParameters; ++i) {
            int nKey = Serialize.readInt(data);
            byte[] pValue = Serialize.readBlock(data);
            ret.put(new Integer(nKey), pValue);
        }
        return ret;
    }

    private Hashtable getStringParameters(BinaryData data) {
        Hashtable<Integer, String> ret = new Hashtable<Integer, String>();
        int nStringParameters = Serialize.readInt(data);
        for (int i = 0; i < nStringParameters; ++i) {
            int nKey = Serialize.readInt(data);
            String sValue = Serialize.readString(data);
            ret.put(new Integer(nKey), sValue);
        }
        return ret;
    }
}

