/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce.util;

public class BlockingQueue {
    private Object[] theArray = new Object[10];
    private int currentSize;
    private int front;
    private int back;
    private static final int DEFAULT_CAPACITY = 10;

    public BlockingQueue() {
        this.makeEmpty();
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public void makeEmpty() {
        this.currentSize = 0;
        this.front = 0;
        this.back = -1;
    }

    public Object dequeue() {
        return this.dequeue(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue(int timeout) {
        try {
            Object[] objectArray = this.theArray;
            synchronized (this.theArray) {
                if (this.isEmpty()) {
                    if (timeout > 0) {
                        this.theArray.wait(timeout);
                    } else {
                        this.theArray.wait();
                    }
                }
                if (this.isEmpty()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                --this.currentSize;
                Object returnValue = this.theArray[this.front];
                this.front = this.increment(this.front);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return returnValue;
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void enqueue(Object x) {
        if (this.currentSize == this.theArray.length) {
            this.doubleQueue();
        }
        this.back = this.increment(this.back);
        this.theArray[this.back] = x;
        ++this.currentSize;
    }

    private int increment(int x) {
        if (++x == this.theArray.length) {
            x = 0;
        }
        return x;
    }

    private void doubleQueue() {
        Object[] newArray = new Object[this.theArray.length * 2];
        for (int i = 0; i < this.currentSize; ++i) {
            newArray[i] = this.theArray[this.front];
            this.front = this.increment(this.front);
        }
        this.theArray = newArray;
        this.front = 0;
        this.back = this.currentSize - 1;
    }
}

