/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce.util;

import org.linuxmce.dce.util.BinaryData;

public class Serialize {
    public static BinaryData writeInt(BinaryData data, int nValue) {
        byte[] pSmallData = new byte[4];
        pSmallData[3] = (byte)((nValue & 0xFF000000) >> 24);
        pSmallData[2] = (byte)((nValue & 0xFF0000) >> 16);
        pSmallData[1] = (byte)((nValue & 0xFF00) >> 8);
        pSmallData[0] = (byte)(nValue & 0xFF);
        return data.write(pSmallData);
    }

    public static BinaryData writeString(BinaryData data, String sValue) {
        data.write(sValue.getBytes());
        byte[] pSmallData = new byte[]{0};
        return data.write(pSmallData);
    }

    public static BinaryData writeChar(BinaryData data, char sValue) {
        return data.write(String.valueOf(sValue).getBytes());
    }

    public static BinaryData writeStringFront(BinaryData data, String sValue) {
        return data.writeFront(sValue.getBytes());
    }

    public static BinaryData writeBlock(BinaryData data, byte[] pValue) {
        Serialize.writeInt(data, pValue.length);
        return data.write(pValue);
    }

    public static int readInt(BinaryData data) {
        byte[] pSmallData = data.read(4);
        int value = ((256 + pSmallData[3]) % 256 << 24) + ((256 + pSmallData[2]) % 256 << 16) + ((256 + pSmallData[1]) % 256 << 8) + (256 + pSmallData[0]) % 256;
        return value;
    }

    public static char readChar(BinaryData data) {
        byte[] pSmallData = data.read(1);
        return (char)pSmallData[0];
    }

    public static String readString(BinaryData data) {
        return data.readString();
    }

    public static byte[] readBlock(BinaryData data) {
        int len = Serialize.readInt(data);
        byte[] pSmallData = data.read(len);
        return pSmallData;
    }

    public static String dumpByteArray(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            buf.append("0x");
            buf.append(Integer.toHexString((256 + bytes[i]) % 256));
            buf.append(", ");
        }
        return buf.toString();
    }
}

