/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.javasound.JSChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;

class JSClip
extends JSChannel {
    Clip line;
    Clip otherChannel = null;
    Clip reverbChannel = null;

    JSClip() {
    }

    @Override
    DataLine initDataLine(AudioInputStream ais) {
        try {
            this.audioFormat = ais.getFormat();
            if (this.audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || this.audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.audioFormat.getSampleRate(), this.audioFormat.getSampleSizeInBits() * 2, this.audioFormat.getChannels(), this.audioFormat.getFrameSize() * 2, this.audioFormat.getFrameRate(), true);
                ais = AudioSystem.getAudioInputStream(tmp, ais);
                this.audioFormat = tmp;
            }
            DataLine.Info info = new DataLine.Info(Clip.class, this.audioFormat);
            this.line = (Clip)AudioSystem.getLine(info);
            this.line.open(ais);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.line;
    }

    @Override
    boolean startSamples(int loopCount, float leftGain, float rightGain, int leftDelay, int rightDelay) {
        if (this.otherChannel == null || this.reverbChannel == null) {
            this.startSample(loopCount, leftGain, leftDelay);
        }
        if (this.ais == null) {
            return false;
        }
        Clip leftLine = this.line;
        Clip rightLine = this.otherChannel;
        double ZERO_EPS = 0.0039;
        double leftVolume = leftGain;
        double rightVolume = rightGain;
        this.startTime = System.currentTimeMillis();
        try {
            this.line.setLoopPoints(0, -1);
            this.line.loop(loopCount);
            this.line.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.startTime = 0L;
            return false;
        }
        return true;
    }

    @Override
    boolean startSample(int loopCount, float gain, int delay) {
        this.line.setFramePosition(0);
        this.line.setLoopPoints(0, -1);
        this.line.loop(loopCount);
        this.line.start();
        return true;
    }

    @Override
    int stopSample() {
        this.line.stop();
        this.startTime = 0L;
        return 0;
    }

    @Override
    int stopSamples() {
        this.line.stop();
        this.startTime = 0L;
        return 0;
    }

    public void update(LineEvent event) {
        if (event.getType().equals(LineEvent.Type.STOP)) {
            this.line.close();
        } else if (event.getType().equals(LineEvent.Type.CLOSE)) {
            // empty if block
        }
    }
}

