/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

class ImageScaler {
    int origW;
    int origH;
    Image origImage;

    ImageScaler(Image image, int w, int h) {
        this.origImage = image;
        this.origW = w;
        this.origH = h;
    }

    ImageScaler(BufferedImage image) {
        this.origImage = image;
        this.origW = image.getWidth();
        this.origH = image.getHeight();
    }

    int getClosestPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        for (int i = 1; i < 20; ++i) {
            if (value >= (powerValue *= 2)) continue;
            int minBound = powerValue / 2;
            if (powerValue - value > value - minBound) {
                return minBound;
            }
            return powerValue;
        }
        return 1;
    }

    Image getScaledImage() {
        int newWidth = this.getClosestPowerOf2(this.origW);
        int newHeight = this.getClosestPowerOf2(this.origH);
        if (newWidth == this.origW && newHeight == this.origH) {
            return this.origImage;
        }
        Image scaledImage = null;
        if (this.origImage instanceof BufferedImage) {
            BufferedImage origImageB = (BufferedImage)this.origImage;
            scaledImage = new BufferedImage(newWidth, newHeight, origImageB.getType());
            BufferedImage scaledImageB = (BufferedImage)scaledImage;
            float widthScale = (float)this.origW / (float)newWidth;
            float heightScale = (float)this.origH / (float)newHeight;
            int[] origPixels = ((DataBufferInt)origImageB.getRaster().getDataBuffer()).getData();
            int[] newPixels = ((DataBufferInt)scaledImageB.getRaster().getDataBuffer()).getData();
            for (int row = 0; row < newHeight; ++row) {
                for (int column = 0; column < newWidth; ++column) {
                    int oldRow = Math.min(this.origH - 1, (int)((float)row * heightScale + 0.5f));
                    int oldColumn = Math.min(this.origW - 1, (int)((float)column * widthScale + 0.5f));
                    newPixels[row * newWidth + column] = origPixels[oldRow * this.origW + oldColumn];
                }
            }
        } else {
            scaledImage = this.origImage.getScaledInstance(newWidth, newHeight, 1);
        }
        return scaledImage;
    }
}

