/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Edge;
import com.sun.j3d.utils.geometry.EdgeTable;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.ArrayList;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class NormalGenerator {
    private double creaseAngle;
    private ArrayList<ArrayList<Integer>> tally;
    private int[] coordInds;
    private int[] normalInds;
    private int[] colorInds;
    private int[][] texInds;
    private int[] stripCounts;
    private static long t1 = 0L;
    private static long t2 = 0L;
    private static long t3 = 0L;
    private static long t4 = 0L;
    private static long t5 = 0L;
    private static long t6 = 0L;
    private Triangulator tr = null;
    private int numTexSets;
    private static final int DEBUG = 0;

    private Vector3f[] calculatefacetNorms(GeometryInfo gi) {
        Point3f[] coordinates = gi.getCoordinates();
        Vector3f[] facetNorms = new Vector3f[this.coordInds.length / 3];
        Vector3f a = new Vector3f();
        Vector3f b = new Vector3f();
        if (gi.getOldPrim() != 2) {
            for (int t = 0; t < this.coordInds.length; t += 3) {
                a.sub((Tuple3f)coordinates[this.coordInds[t + 2]], (Tuple3f)coordinates[this.coordInds[t + 1]]);
                b.sub((Tuple3f)coordinates[this.coordInds[t + 0]], (Tuple3f)coordinates[this.coordInds[t + 1]]);
                facetNorms[t / 3] = new Vector3f();
                facetNorms[t / 3].cross(a, b);
                facetNorms[t / 3].normalize();
                if (!Float.isNaN(facetNorms[t / 3].x)) continue;
                facetNorms[t / 3].x = 1.0f;
                facetNorms[t / 3].z = 0.0f;
                facetNorms[t / 3].y = 0.0f;
            }
        } else {
            for (int t = 0; t < this.coordInds.length; t += 6) {
                a.sub((Tuple3f)coordinates[this.coordInds[t + 2]], (Tuple3f)coordinates[this.coordInds[t + 0]]);
                b.sub((Tuple3f)coordinates[this.coordInds[t + 5]], (Tuple3f)coordinates[this.coordInds[t + 1]]);
                facetNorms[t / 3] = new Vector3f();
                facetNorms[t / 3].cross(a, b);
                facetNorms[t / 3].normalize();
                if (Float.isNaN(facetNorms[t / 3].x)) {
                    facetNorms[t / 3].x = 1.0f;
                    facetNorms[t / 3].z = 0.0f;
                    facetNorms[t / 3].y = 0.0f;
                }
                facetNorms[t / 3 + 1] = new Vector3f(facetNorms[t / 3]);
            }
        }
        return facetNorms;
    }

    private int createHardEdges(Vector3f[] facetNorms) {
        int c;
        EdgeTable et = new EdgeTable(this.coordInds);
        this.tally = new ArrayList();
        int[] normalMap = new int[this.coordInds.length];
        int maxShare = 1;
        float threshold = (float)Math.cos(this.creaseAngle);
        for (c = 0; c < this.coordInds.length; ++c) {
            normalMap[c] = Integer.MAX_VALUE;
        }
        for (c = 0; c < this.coordInds.length; ++c) {
            boolean smooth;
            if (normalMap[c] != Integer.MAX_VALUE) continue;
            ArrayList<Integer> sharers = new ArrayList<Integer>();
            this.tally.add(sharers);
            sharers.add(new Integer(c));
            normalMap[c] = this.tally.size() - 1;
            boolean goingRight = true;
            Edge edge = new Edge(this.coordInds[c], this.coordInds[(c + 1) % 3 == 0 ? c - 2 : c + 1]);
            int endVertex = this.coordInds[c % 3 == 0 ? c + 2 : c - 1];
            int cur = c;
            do {
                Integer tableVal;
                if ((tableVal = et.get(edge.v2, edge.v1)) == null) {
                    smooth = false;
                } else {
                    int n = tableVal;
                    float cosine = facetNorms[cur / 3].dot(facetNorms[n / 3]);
                    boolean bl = smooth = cosine > threshold;
                    if (smooth) {
                        int centerv;
                        int n2 = centerv = (n + 1) % 3 == 0 ? n - 2 : n + 1;
                        if (this.coordInds[c] != this.coordInds[centerv]) {
                            int n3 = centerv = n % 3 == 0 ? n + 2 : n - 1;
                        }
                        if (normalMap[centerv] != Integer.MAX_VALUE) {
                            smooth = false;
                        } else {
                            normalMap[centerv] = this.tally.size() - 1;
                            sharers.add(new Integer(centerv));
                            if (sharers.size() > maxShare) {
                                maxShare = sharers.size();
                            }
                            cur = n;
                            if (goingRight) {
                                edge.v2 = this.coordInds[cur];
                            } else {
                                edge.v1 = this.coordInds[cur];
                            }
                        }
                    }
                }
                if (smooth || !goingRight) continue;
                goingRight = false;
                smooth = true;
                cur = c;
                edge = new Edge(this.coordInds[c % 3 == 0 ? c + 2 : c - 1], this.coordInds[c]);
            } while (smooth && (goingRight && edge.v2 != endVertex || !goingRight));
        }
        return maxShare;
    }

    private void calculateVertexNormals(GeometryInfo gi, Vector3f[] facetNorms, int maxShare) {
        Vector3f[] normals;
        if (this.creaseAngle != 0.0) {
            Vector3f[] fn = new Vector3f[maxShare];
            normals = new Vector3f[this.tally.size()];
            this.normalInds = new int[this.coordInds.length];
            for (int n = 0; n < this.tally.size(); ++n) {
                ArrayList<Integer> sharers = this.tally.get(n);
                int fnsize = 0;
                normals[n] = new Vector3f();
                for (int t = 0; t < sharers.size(); ++t) {
                    int f;
                    int v = sharers.get(t);
                    if (v == -1) continue;
                    int triangle = v / 3;
                    if (Float.isNaN(facetNorms[triangle].x)) continue;
                    for (f = 0; f < fnsize && !fn[f].equals((Tuple3f)facetNorms[triangle]); ++f) {
                    }
                    this.normalInds[v] = n;
                    if (f != fnsize) continue;
                    normals[n].add((Tuple3f)facetNorms[triangle]);
                    fn[fnsize++] = facetNorms[triangle];
                }
                normals[n].normalize();
                if (!Float.isNaN(normals[n].x)) continue;
                normals[n].x = 1.0f;
                normals[n].z = 0.0f;
                normals[n].y = 0.0f;
            }
        } else {
            normals = facetNorms;
            this.normalInds = new int[facetNorms.length * 3];
            for (int i = 0; i < facetNorms.length; ++i) {
                this.normalInds[i * 3 + 0] = i;
                this.normalInds[i * 3 + 1] = i;
                this.normalInds[i * 3 + 2] = i;
            }
        }
        gi.setNormals(normals);
    }

    private int[] triToQuadIndices(int[] oldList) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[oldList.length / 6 * 4];
        for (int q = 0; q < oldList.length / 6; ++q) {
            newList[q * 4 + 0] = oldList[q * 6 + 0];
            newList[q * 4 + 1] = oldList[q * 6 + 1];
            newList[q * 4 + 2] = oldList[q * 6 + 2];
            newList[q * 4 + 3] = oldList[q * 6 + 5];
        }
        return newList;
    }

    private void convertTriToQuad(GeometryInfo geom) {
        geom.setCoordinateIndices(this.triToQuadIndices(geom.getCoordinateIndices()));
        geom.setColorIndices(this.triToQuadIndices(geom.getColorIndices()));
        geom.setNormalIndices(this.triToQuadIndices(geom.getNormalIndices()));
        int num = geom.getTexCoordSetCount();
        for (int i = 0; i < num; ++i) {
            geom.setTextureCoordinateIndices(i, this.triToQuadIndices(geom.getTextureCoordinateIndices(i)));
        }
        geom.setPrimitive(2);
    }

    private int[] triToFanIndices(int[] sc, int[] oldList, int numVerts) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[numVerts];
        int vert1 = 0;
        int n = 0;
        for (int f = 0; f < sc.length; ++f) {
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            for (int t = 3; t < sc[f]; ++t) {
                newList[n++] = oldList[vert1 + 2];
                vert1 += 3;
            }
        }
        return newList;
    }

    private void convertTriToFan(GeometryInfo geom, int[] oldStripCounts) {
        int[] ni = geom.getNormalIndices();
        int tri = 0;
        ArrayList<Integer> newStripCounts = new ArrayList<Integer>(oldStripCounts.length + 100);
        for (int f = 0; f < oldStripCounts.length; ++f) {
            int stripCount = 3;
            for (int t = 0; t < oldStripCounts[f] - 3; ++t) {
                if (ni[tri * 3] == ni[(tri + 1) * 3] && ni[tri * 3 + 2] == ni[(tri + 1) * 3 + 1]) {
                    ++stripCount;
                } else {
                    newStripCounts.add(new Integer(stripCount));
                    stripCount = 3;
                }
                ++tri;
            }
            ++tri;
            newStripCounts.add(new Integer(stripCount));
        }
        int[] sc = new int[newStripCounts.size()];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = (Integer)newStripCounts.get(i);
        }
        newStripCounts = null;
        int c = 0;
        for (int i = 0; i < sc.length; ++i) {
            c += sc[i];
        }
        geom.setCoordinateIndices(this.triToFanIndices(sc, geom.getCoordinateIndices(), c));
        geom.setColorIndices(this.triToFanIndices(sc, geom.getColorIndices(), c));
        geom.setNormalIndices(this.triToFanIndices(sc, geom.getNormalIndices(), c));
        int num = geom.getTexCoordSetCount();
        for (int i = 0; i < num; ++i) {
            geom.setTextureCoordinateIndices(i, this.triToFanIndices(sc, geom.getTextureCoordinateIndices(i), c));
        }
        geom.setStripCounts(sc);
        geom.setPrimitive(3);
    }

    private int[] triToStripIndices(int[] sc, int[] oldList, int numVerts) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[numVerts];
        int vert1 = 0;
        int n = 0;
        for (int f = 0; f < sc.length; ++f) {
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            for (int t = 3; t < sc[f]; ++t) {
                newList[n++] = oldList[vert1 + 2 - t % 2];
                vert1 += 3;
            }
        }
        return newList;
    }

    private void convertTriToStrip(GeometryInfo geom, int[] oldStripCounts) {
        int[] ni = geom.getNormalIndices();
        int tri = 0;
        ArrayList<Integer> newStripCounts = new ArrayList<Integer>(oldStripCounts.length + 100);
        for (int f = 0; f < oldStripCounts.length; ++f) {
            int stripCount = 3;
            for (int t = 0; t < oldStripCounts[f] - 3; ++t) {
                if (t % 2 == 0) {
                    if (ni[tri * 3 + 1] == ni[(tri + 1) * 3] && ni[tri * 3 + 2] == ni[(tri + 1) * 3 + 2]) {
                        ++stripCount;
                    } else {
                        newStripCounts.add(new Integer(stripCount));
                        stripCount = 3;
                        if (t < oldStripCounts[f] - 4) {
                            newStripCounts.add(new Integer(3));
                            ++t;
                        }
                    }
                } else if (ni[tri * 3 + 1] == ni[(tri + 1) * 3 + 1] && ni[tri * 3 + 2] == ni[(tri + 1) * 3]) {
                    ++stripCount;
                } else {
                    newStripCounts.add(new Integer(stripCount));
                    stripCount = 3;
                }
                ++tri;
            }
            ++tri;
            newStripCounts.add(new Integer(stripCount));
        }
        int[] sc = new int[newStripCounts.size()];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = (Integer)newStripCounts.get(i);
        }
        newStripCounts = null;
        int c = 0;
        for (int i = 0; i < sc.length; ++i) {
            c += sc[i];
        }
        geom.setCoordinateIndices(this.triToStripIndices(sc, geom.getCoordinateIndices(), c));
        geom.setColorIndices(this.triToStripIndices(sc, geom.getColorIndices(), c));
        geom.setNormalIndices(this.triToStripIndices(sc, geom.getNormalIndices(), c));
        int num = geom.getTexCoordSetCount();
        for (int i = 0; i < num; ++i) {
            geom.setTextureCoordinateIndices(i, this.triToStripIndices(sc, geom.getTextureCoordinateIndices(i), c));
        }
        geom.setStripCounts(sc);
        geom.setPrimitive(4);
    }

    void convertBackToOldPrim(GeometryInfo geom, int oldPrim, int[] oldStripCounts) {
        if (oldPrim == 1) {
            return;
        }
        switch (oldPrim) {
            case 2: {
                this.convertTriToQuad(geom);
                break;
            }
            case 3: {
                this.convertTriToFan(geom, oldStripCounts);
                break;
            }
            case 4: {
                this.convertTriToStrip(geom, oldStripCounts);
            }
        }
    }

    public void generateNormals(GeometryInfo gi) {
        gi.setNormals((Vector3f[])null);
        gi.setNormalIndices(null);
        long time = 0L;
        if (gi.getPrimitive() == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(gi);
        } else {
            gi.rememberOldPrim();
            gi.convertToIndexedTriangles();
        }
        this.coordInds = gi.getCoordinateIndices();
        this.colorInds = gi.getColorIndices();
        this.normalInds = gi.getNormalIndices();
        this.numTexSets = gi.getTexCoordSetCount();
        this.texInds = new int[this.numTexSets][];
        for (int i = 0; i < this.numTexSets; ++i) {
            this.texInds[i] = gi.getTextureCoordinateIndices(i);
        }
        this.stripCounts = gi.getStripCounts();
        Vector3f[] facetNorms = this.calculatefacetNorms(gi);
        int maxShare = this.createHardEdges(facetNorms);
        this.calculateVertexNormals(gi, facetNorms, maxShare);
        gi.setCoordinateIndices(this.coordInds);
        gi.setColorIndices(this.colorInds);
        gi.setNormalIndices(this.normalInds);
        for (int i = 0; i < this.numTexSets; ++i) {
            gi.setTextureCoordinateIndices(i, this.texInds[i]);
        }
        gi.setStripCounts(this.stripCounts);
    }

    public void setCreaseAngle(double radians) {
        if (radians > Math.PI) {
            radians = Math.PI;
        }
        if (radians < 0.0) {
            radians = 0.0;
        }
        this.creaseAngle = radians;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public NormalGenerator(double radians) {
        this.creaseAngle = radians;
    }

    public NormalGenerator() {
        this(0.767944870877505);
    }
}

