/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTable;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.DanglingReferenceException;
import javax.media.j3d.SceneGraphObject;

public class StreamControl
extends Controller {
    protected String FILE_IDENT = new String("j3dsf");
    private DataInputStream inputStream;
    private DataOutputStream outputStream;

    public StreamControl(DataOutputStream out) {
        this.outputStream = out;
        this.symbolTable = new SymbolTable(this);
    }

    public StreamControl(DataInputStream in) {
        this.inputStream = in;
        this.symbolTable = new SymbolTable(this);
    }

    public void writeStreamHeader() throws IOException {
        this.outputStream.writeUTF(this.FILE_IDENT);
        this.outputStream.writeInt(this.outputFileVersion);
    }

    public void readStreamHeader() throws IOException {
        String ident = this.inputStream.readUTF();
        if (ident.equals("demo_j3s")) {
            throw new IOException("Use Java 3D Fly Through I/O instead of Java 3D Scenegraph I/O");
        }
        if (!ident.equals("j3dsf")) {
            throw new IOException("This is a File - use SceneGraphFileReader instead");
        }
        this.currentFileVersion = this.inputStream.readInt();
        if (this.currentFileVersion > this.outputFileVersion) {
            throw new IOException("Unsupported file version. This file was written using a new version of the SceneGraph IO API, please update your installtion to the latest version");
        }
    }

    public void addNamedObjects(HashMap namedObjects) {
        this.symbolTable.addNamedObjects(namedObjects);
    }

    @Override
    public void writeBranchGraph(BranchGroup bg, Serializable userData) throws IOException {
        try {
            SymbolTableData symbol = this.symbolTable.getSymbol((SceneGraphObject)bg);
            if (symbol == null) {
                symbol = this.symbolTable.createSymbol((SceneGraphObject)bg);
                symbol.branchGraphID = -1;
            }
            this.symbolTable.setBranchGraphRoot(symbol, 0L);
            this.symbolTable.startUnsavedNodeComponentFrame();
            SceneGraphObjectState state = this.createState((SceneGraphObject)bg, symbol);
            this.writeObject(this.outputStream, state);
            this.writeNodeComponents(this.outputStream);
            this.symbolTable.endUnsavedNodeComponentFrame();
            if (this.symbolTable.branchGraphHasDependencies(symbol.branchGraphID)) {
                throw new DanglingReferenceException();
            }
            this.symbolTable.clearUnshared();
            this.symbolTable.writeTable(this.outputStream);
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    public BranchGroup readBranchGraph(HashMap namedObjects) throws IOException {
        try {
            SceneGraphObjectState state = this.readObject(this.inputStream);
            this.readNodeComponents(this.inputStream);
            this.symbolTable.readTable(this.inputStream, true);
            this.symbolTable.setBranchGraphRoot(state.getSymbol(), 0L);
            state.buildGraph();
            if (namedObjects != null) {
                this.symbolTable.getNamedObjectMap(namedObjects);
            }
            return (BranchGroup)state.getNode();
        }
        catch (SGIORuntimeException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void readBranchGraphs(int[] graphs) throws IOException {
        for (int i = 0; i < graphs.length; ++i) {
            this.readBranchGraph(null);
        }
    }

    public void loadNodeComponent(SymbolTableData symbol) throws IOException {
        throw new IOException("Unable to load individual NodeComponents from Stream");
    }

    @Override
    public void close() throws IOException {
        super.reset();
    }

    @Override
    public long getFilePointer() {
        return 0L;
    }
}

