/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.NamedObjectException;
import com.sun.j3d.utils.scenegraph.io.ObjectNotLoadedException;
import com.sun.j3d.utils.scenegraph.io.SceneGraphObjectReferenceControl;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.RandomAccessFileControl;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NullSceneGraphObjectState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.media.j3d.Node;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.SceneGraphObject;

public class SymbolTable
implements SceneGraphObjectReferenceControl {
    private int nodeID = 1;
    private HashMap j3dNodeIndex;
    private ArrayList nodeIDIndex;
    private HashMap danglingReferences;
    private Stack unsavedNodeComponentsStack;
    private LinkedList sharedNodes;
    private HashMap namedObjects;
    private ArrayList branchGraphs;
    private ArrayList branchGraphDependencies;
    private Controller control;
    private int currentBranchGraphID = -1;
    private int nextBranchGraphID = 0;

    public SymbolTable(Controller control) {
        this.control = control;
        this.j3dNodeIndex = new HashMap();
        this.danglingReferences = new HashMap();
        this.nodeIDIndex = new ArrayList();
        this.nodeIDIndex.add(null);
        this.sharedNodes = new LinkedList();
        this.namedObjects = new HashMap();
        this.branchGraphs = new ArrayList();
        this.branchGraphDependencies = new ArrayList();
        this.unsavedNodeComponentsStack = new Stack();
    }

    private void checkforDanglingReferences() {
        ListIterator list = this.sharedNodes.listIterator();
        while (list.hasNext()) {
            SymbolTableData data = (SymbolTableData)list.next();
            if (data.branchGraphID != -3) continue;
            System.err.println("Warning : node " + data.j3dNode + " is referenced but is not attached to a BranchGraph");
            System.err.println("Setting reference to null. This scene may not look correct when loaded");
        }
    }

    private void removeNullDependencies(HashSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)it.next();
            if (symbol.branchGraphID != -3) continue;
            it.remove();
        }
    }

    public void writeTable(DataOutput out) throws IOException {
        int i;
        this.checkforDanglingReferences();
        ListIterator list = this.sharedNodes.listIterator();
        out.writeInt(this.sharedNodes.size());
        out.writeInt(this.nodeID);
        while (list.hasNext()) {
            SymbolTableData data = (SymbolTableData)list.next();
            data.writeObject(out);
        }
        String[] names = this.getNames();
        out.writeInt(names.length);
        for (i = 0; i < names.length; ++i) {
            out.writeUTF(names[i]);
            SceneGraphObject node = (SceneGraphObject)this.namedObjects.get(names[i]);
            SymbolTableData symbol = this.getSymbol(node);
            if (symbol != null) {
                out.writeInt(symbol.nodeID);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.branchGraphs.size());
        for (i = 0; i < this.branchGraphs.size(); ++i) {
            ((SymbolTableData)this.branchGraphs.get(i)).writeObject(out);
        }
        for (i = 0; i < this.branchGraphDependencies.size(); ++i) {
            HashSet set = (HashSet)this.branchGraphDependencies.get(i);
            if (set == null) {
                out.writeInt(0);
                continue;
            }
            this.removeNullDependencies(set);
            out.writeInt(set.size());
            for (SymbolTableData symbol : set) {
                out.writeInt(symbol.nodeID);
            }
        }
    }

    public void readTable(DataInput in, boolean streamRead) throws IOException {
        int j;
        int i;
        int size = in.readInt();
        this.nodeID = in.readInt();
        this.nodeIDIndexEnsureCapacity(this.nodeID);
        for (i = 0; i < size; ++i) {
            SymbolTableData symbol = new SymbolTableData(0, null, null, -1);
            symbol.readObject(in);
            if (streamRead) continue;
            this.sharedNodes.add(symbol);
            this.nodeIDIndex.set(symbol.nodeID, symbol);
        }
        size = in.readInt();
        for (j = 0; j < size; ++j) {
            String name = in.readUTF();
            int id = in.readInt();
            this.namedObjects.put(name, new Integer(id));
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.branchGraphs.add(null);
        }
        for (j = 0; j < size; ++j) {
            SymbolTableData tmp = new SymbolTableData(0, null, null, -1);
            tmp.readObject(in);
            SymbolTableData symbol = this.getSymbol(tmp.nodeID);
            if (symbol == null) {
                symbol = tmp;
                if (symbol.referenceCount > 1) {
                    this.sharedNodes.add(symbol);
                }
                this.nodeIDIndex.set(symbol.nodeID, symbol);
            }
            this.branchGraphs.set(j, symbol);
        }
        for (i = 0; i < size; ++i) {
            int setSize = in.readInt();
            if (setSize == 0) {
                this.branchGraphDependencies.add(null);
                continue;
            }
            HashSet<SymbolTableData> set = new HashSet<SymbolTableData>();
            this.branchGraphDependencies.add(set);
            for (int j2 = 0; j2 < setSize; ++j2) {
                set.add(this.getSymbol(in.readInt()));
            }
        }
    }

    public void setBranchGraphRoot(SymbolTableData symbol, long filePointer) {
        if (symbol.branchGraphID < 0) {
            symbol.branchGraphID = this.nextBranchGraphID++;
        }
        this.currentBranchGraphID = symbol.branchGraphID;
        for (int i = this.branchGraphs.size(); i < this.currentBranchGraphID + 1; ++i) {
            this.branchGraphs.add(null);
            this.branchGraphDependencies.add(null);
        }
        this.branchGraphs.set(this.currentBranchGraphID, symbol);
        symbol.branchGraphFilePointer = filePointer;
    }

    public SymbolTableData getBranchGraphRoot(int graphID) {
        return (SymbolTableData)this.branchGraphs.get(graphID);
    }

    public void setBranchGraphID(SymbolTableData symbol) {
        symbol.branchGraphID = this.currentBranchGraphID;
    }

    public int[] getBranchGraphDependencies(int graphID) {
        HashSet set = (HashSet)this.branchGraphDependencies.get(graphID);
        if (set == null) {
            return new int[0];
        }
        int[] ret = new int[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = ((SymbolTableData)it.next()).branchGraphID;
        }
        return ret;
    }

    public boolean branchGraphHasDependencies(int graphID) {
        HashSet set = (HashSet)this.branchGraphDependencies.get(graphID);
        return set != null && set.size() != 0;
    }

    public int getBranchGraphCount() {
        return this.branchGraphs.size();
    }

    public long getBranchGraphFilePosition(int graphID) {
        SymbolTableData symbol = (SymbolTableData)this.branchGraphs.get(graphID);
        return symbol.branchGraphFilePointer;
    }

    public SymbolTableData createSymbol(SceneGraphObject node) {
        SymbolTableData data = (SymbolTableData)this.j3dNodeIndex.get(node);
        SymbolTableData dangling = (SymbolTableData)this.danglingReferences.get(node);
        if (dangling != null) {
            data = dangling;
            data.branchGraphID = this.currentBranchGraphID;
            this.danglingReferences.remove(dangling);
        } else if (data == null) {
            data = new SymbolTableData(this.nodeID++, node, null, this.currentBranchGraphID);
            this.j3dNodeIndex.put(node, data);
            this.nodeIDIndex.add(data);
        } else if (data.j3dNode instanceof Node) {
            throw new RuntimeException("Object already in Symbol table " + node);
        }
        return data;
    }

    public SymbolTableData createSymbol(SceneGraphObjectState state, SceneGraphObject node, int nodeID) {
        SymbolTableData data = (SymbolTableData)this.j3dNodeIndex.get(node);
        if (data == null) {
            this.nodeIDIndexEnsureCapacity(nodeID);
            data = (SymbolTableData)this.nodeIDIndex.get(nodeID);
            if (data == null) {
                data = new SymbolTableData(nodeID, node, state, -2);
                this.j3dNodeIndex.put(node, data);
                this.nodeIDIndex.set(data.getNodeID(), data);
            } else if (data.getJ3dNode() == null) {
                data.j3dNode = node;
                data.nodeState = state;
                this.j3dNodeIndex.put(node, data);
            }
        } else {
            throw new SGIORuntimeException("Object already in Symbol table ");
        }
        return data;
    }

    private void nodeIDIndexEnsureCapacity(int size) {
        this.nodeIDIndex.ensureCapacity(size);
        int adjust = size - this.nodeIDIndex.size();
        for (int i = 0; i <= adjust; ++i) {
            this.nodeIDIndex.add(null);
        }
    }

    private SymbolTableData createDanglingSymbol(SceneGraphObject node) {
        SymbolTableData data = (SymbolTableData)this.j3dNodeIndex.get(node);
        if (data == null) {
            data = new SymbolTableData(this.nodeID++, node, null, -3);
            this.j3dNodeIndex.put(node, data);
            this.nodeIDIndex.add(data);
            this.danglingReferences.put(node, data);
        } else if (data.nodeState == null) {
            if (data.referenceCount == 1) {
                this.sharedNodes.add(data);
            }
            ++data.referenceCount;
        } else {
            throw new SGIORuntimeException("Object already in Symbol table ");
        }
        return data;
    }

    private SymbolTableData createNodeComponentSymbol(SceneGraphObject node) {
        SymbolTableData symbol = new SymbolTableData(this.nodeID++, node, null, this.currentBranchGraphID);
        symbol.isNodeComponent = true;
        this.j3dNodeIndex.put(node, symbol);
        this.nodeIDIndex.add(symbol);
        ((LinkedList)this.unsavedNodeComponentsStack.peek()).add(symbol);
        this.control.createState(symbol);
        return symbol;
    }

    public int getUnsavedNodeComponentsSize() {
        return ((LinkedList)this.unsavedNodeComponentsStack.peek()).size();
    }

    public ListIterator getUnsavedNodeComponents() {
        return ((LinkedList)this.unsavedNodeComponentsStack.peek()).listIterator(0);
    }

    public void startUnsavedNodeComponentFrame() {
        this.unsavedNodeComponentsStack.push(new LinkedList());
    }

    public void endUnsavedNodeComponentFrame() {
        this.unsavedNodeComponentsStack.pop();
        this.confirmInterGraphDependency();
    }

    private void confirmInterGraphDependency() {
        HashSet set = (HashSet)this.branchGraphDependencies.get(this.currentBranchGraphID);
        if (set == null) {
            return;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)it.next();
            if (symbol.branchGraphID != this.currentBranchGraphID) continue;
            it.remove();
        }
    }

    private void addInterGraphDependency(SymbolTableData symbol) {
        HashSet<SymbolTableData> set = (HashSet<SymbolTableData>)this.branchGraphDependencies.get(this.currentBranchGraphID);
        if (set == null) {
            set = new HashSet<SymbolTableData>();
            this.branchGraphDependencies.set(this.currentBranchGraphID, set);
        }
        set.add(symbol);
    }

    public void incNodeComponentRefCount(int nodeID) {
        if (nodeID == 0) {
            return;
        }
        SymbolTableData symbol = this.getSymbol(nodeID);
        ((NodeComponentState)symbol.nodeState).addSubReference();
        if (symbol.referenceCount == 1) {
            this.sharedNodes.add(symbol);
        }
        ++symbol.referenceCount;
    }

    @Override
    public int addReference(SceneGraphObject node) {
        if (node == null) {
            return 0;
        }
        SymbolTableData symbol = this.getSymbol(node);
        if (symbol == null) {
            if (node instanceof Node) {
                symbol = this.createDanglingSymbol(node);
                if (symbol.branchGraphID != this.currentBranchGraphID) {
                    this.addInterGraphDependency(symbol);
                    this.sharedNodes.add(symbol);
                }
            } else {
                symbol = this.createNodeComponentSymbol(node);
            }
            return symbol.nodeID;
        }
        return this.addReference(symbol);
    }

    public int addReference(SymbolTableData symbol) {
        if (symbol != null) {
            if (symbol.referenceCount == 1) {
                this.sharedNodes.add(symbol);
            }
            ++symbol.referenceCount;
            if (symbol.j3dNode instanceof NodeComponent && symbol.referenceCount > 1) {
                ((NodeComponentState)symbol.nodeState).addSubReference();
            }
            if (symbol.branchGraphID != this.currentBranchGraphID && symbol.j3dNode instanceof Node) {
                this.addInterGraphDependency(symbol);
            }
        } else {
            throw new SGIORuntimeException("Null Symbol");
        }
        return symbol.nodeID;
    }

    public int addBranchGraphReference(SceneGraphObject node, int branchGraphID) {
        if (node == null) {
            return 0;
        }
        SymbolTableData symbol = this.getSymbol(node);
        if (symbol != null) {
            if (symbol.referenceCount == 1) {
                this.sharedNodes.add(symbol);
            }
            ++symbol.referenceCount;
        } else {
            symbol = new SymbolTableData(this.nodeID++, node, null, -3);
            this.j3dNodeIndex.put(node, symbol);
            this.nodeIDIndex.add(symbol);
            this.danglingReferences.put(node, symbol);
        }
        symbol.branchGraphID = branchGraphID;
        for (int i = this.branchGraphs.size(); i < branchGraphID + 1; ++i) {
            this.branchGraphs.add(null);
            this.branchGraphDependencies.add(null);
        }
        this.branchGraphs.set(symbol.branchGraphID, symbol);
        return symbol.nodeID;
    }

    public boolean isLoaded(int nodeID) {
        SymbolTableData symbol = this.getSymbol(nodeID);
        if (symbol == null) {
            return false;
        }
        return symbol.j3dNode != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SceneGraphObject getJ3dNode(int nodeID) {
        if (nodeID == 0) {
            return null;
        }
        SymbolTableData symbol = this.getSymbol(nodeID);
        if (symbol.branchGraphID == -3) {
            return null;
        }
        if (symbol != null && symbol.j3dNode == null) {
            if (symbol.isNodeComponent && this.control instanceof RandomAccessFileControl) {
                try {
                    ((RandomAccessFileControl)this.control).loadNodeComponent(symbol);
                }
                catch (IOException e) {
                    System.out.println("FAILED to seek and load NodeComponent");
                    return null;
                }
            } else {
                System.out.println("WARNING - Object has not been loaded " + nodeID);
                System.out.println("Need to load branchgraph " + symbol.branchGraphID);
                return null;
            }
        }
        if (symbol == null) {
            throw new SGIORuntimeException("Missing Symbol " + nodeID);
        }
        if (!symbol.graphBuilt) {
            symbol.graphBuilt = true;
            symbol.nodeState.buildGraph();
        }
        return symbol.j3dNode;
    }

    public SymbolTableData getSymbol(SceneGraphObject node) {
        return (SymbolTableData)this.j3dNodeIndex.get(node);
    }

    public SymbolTableData getSymbol(int nodeID) {
        if (nodeID == 0 || nodeID > this.nodeIDIndex.size()) {
            return null;
        }
        return (SymbolTableData)this.nodeIDIndex.get(nodeID);
    }

    public SymbolTableData getSharedGroup(int nodeID) {
        SymbolTableData symbol = this.getSymbol(nodeID);
        if (symbol.nodeState == null && this.control instanceof RandomAccessFileControl) {
            try {
                ((RandomAccessFileControl)this.control).loadSharedGroup(symbol);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SGIORuntimeException("Internal error in getSharedGroup");
            }
        }
        return symbol;
    }

    public void setFilePosition(long ptr, SceneGraphObjectState state) {
        if (state instanceof NullSceneGraphObjectState) {
            return;
        }
        SymbolTableData symbol = this.getSymbol(state.getNodeID());
        symbol.filePosition = ptr;
    }

    public void addNamedObject(String name, SceneGraphObject object) {
        this.namedObjects.put(name, object);
    }

    public void addNamedObjects(HashMap map) {
        if (map != null) {
            this.namedObjects.putAll(map);
        }
    }

    public SceneGraphObject getNamedObject(String name) throws NamedObjectException, ObjectNotLoadedException {
        Object obj = this.namedObjects.get(name);
        if (obj == null) {
            throw new NamedObjectException("Unknown name :" + name);
        }
        if (obj instanceof SceneGraphObject) {
            return (SceneGraphObject)obj;
        }
        SymbolTableData symbol = this.getSymbol((Integer)obj);
        if (symbol == null || symbol.j3dNode == null) {
            throw new ObjectNotLoadedException(((Integer)obj).toString());
        }
        return symbol.j3dNode;
    }

    public String[] getNames() {
        return this.namedObjects.keySet().toArray(new String[0]);
    }

    public void getNamedObjectMap(HashMap map) {
        map.putAll(this.namedObjects);
    }

    public String toString() {
        int i;
        SymbolTableData data;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.nodeIDIndex.size(); ++i2) {
            data = (SymbolTableData)this.nodeIDIndex.get(i2);
            if (data == null) continue;
            buf.append(data.nodeID + " " + data.referenceCount + " " + data.filePosition + "  " + data.branchGraphID + "  " + data.nodeState + "\n");
        }
        buf.append("\nShared Objects\n");
        ListIterator l = this.sharedNodes.listIterator();
        while (l.hasNext()) {
            data = (SymbolTableData)l.next();
            buf.append(data.nodeID + " " + data.referenceCount + " " + data.filePosition + "  " + data.branchGraphID + "  " + data.j3dNode + "\n");
        }
        buf.append("\nNamed Objects\n");
        String[] names = this.getNames();
        for (i = 0; i < names.length; ++i) {
            buf.append(names[i] + "  " + this.namedObjects.get(names[i]));
        }
        buf.append("\nBranch Graphs\n");
        for (i = 0; i < this.branchGraphs.size(); ++i) {
            SymbolTableData data2 = (SymbolTableData)this.branchGraphs.get(i);
            if (data2 == null) {
                System.out.println("Data is null " + i + "  " + this.branchGraphs.size());
            }
            buf.append(data2.nodeID + " " + data2.referenceCount + " " + data2.filePosition + "  " + data2.branchGraphID + "  " + data2.j3dNode + " " + data2.nodeState + "\n");
        }
        buf.append("\nBranch Graph Dependencies\n");
        for (i = 0; i < this.branchGraphDependencies.size(); ++i) {
            buf.append("Graph " + i + " - ");
            HashSet set = (HashSet)this.branchGraphDependencies.get(i);
            if (set != null) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    buf.append(((SymbolTableData)it.next()).nodeID + " ");
                }
            }
            buf.append("\n");
        }
        buf.append("------------------");
        return buf.toString();
    }

    public void clear() {
        this.j3dNodeIndex.clear();
        this.nodeIDIndex.clear();
        while (!this.unsavedNodeComponentsStack.empty()) {
            this.unsavedNodeComponentsStack.pop();
        }
        this.danglingReferences.clear();
        this.sharedNodes.clear();
        this.namedObjects.clear();
        this.nodeID = 1;
    }

    public void clearUnshared() {
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            try {
                SymbolTableData symbol;
                Object obj = this.namedObjects.get(names[i]);
                if (!(obj instanceof Integer) || (symbol = this.getSymbol((Integer)obj)) == null || symbol.j3dNode == null) continue;
                this.namedObjects.put(names[i], symbol.j3dNode);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.j3dNodeIndex.clear();
        this.nodeIDIndex.clear();
        while (!this.unsavedNodeComponentsStack.empty()) {
            this.unsavedNodeComponentsStack.pop();
        }
        this.nodeIDIndexEnsureCapacity(this.nodeID);
        ListIterator list = this.sharedNodes.listIterator();
        while (list.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)list.next();
            this.nodeIDIndex.set(symbol.nodeID, symbol);
            this.j3dNodeIndex.put(symbol.j3dNode, symbol);
        }
        for (SymbolTableData symbol : this.danglingReferences.values()) {
            this.nodeIDIndex.set(symbol.nodeID, symbol);
            this.j3dNodeIndex.put(symbol.j3dNode, symbol);
        }
    }

    @Override
    public SceneGraphObject resolveReference(int nodeID) {
        return this.getJ3dNode(nodeID);
    }
}

