/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureCubeMap;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public abstract class TextureState
extends NodeComponentState {
    private int[] imageComponents;
    protected int width;
    protected int height;
    protected int format;
    protected int mipMapMode;
    protected int boundaryWidth;

    public TextureState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null && !(this.node instanceof TextureCubeMap)) {
            ImageComponent[] images = ((Texture)this.node).getImages();
            this.imageComponents = new int[images.length];
            for (int i = 0; i < images.length; ++i) {
                this.imageComponents[i] = control.getSymbolTable().addReference((SceneGraphObject)images[i]);
            }
        }
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeInt(((Texture)this.node).getMipMapMode());
        out.writeInt(((Texture)this.node).getWidth());
        out.writeInt(((Texture)this.node).getHeight());
        out.writeInt(((Texture)this.node).getFormat());
        out.writeInt(((Texture)this.node).getBoundaryWidth());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.mipMapMode = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.format = in.readInt();
        this.boundaryWidth = in.readInt();
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        Texture attr = (Texture)this.node;
        Color4f clr = new Color4f();
        attr.getBoundaryColor(clr);
        this.control.writeColor4f(out, clr);
        out.writeInt(attr.getBoundaryModeS());
        out.writeInt(attr.getBoundaryModeT());
        out.writeBoolean(attr.getEnable());
        out.writeInt(this.imageComponents.length);
        for (int i = 0; i < this.imageComponents.length; ++i) {
            out.writeInt(this.imageComponents[i]);
        }
        out.writeInt(attr.getMagFilter());
        out.writeInt(attr.getMinFilter());
        out.writeInt(attr.getBaseLevel());
        out.writeInt(attr.getMaximumLevel());
        out.writeFloat(attr.getMinimumLOD());
        out.writeFloat(attr.getMaximumLOD());
        Point3f lodOffset = new Point3f();
        attr.getLodOffset((Tuple3f)lodOffset);
        this.control.writePoint3f(out, lodOffset);
        out.writeInt(attr.getAnisotropicFilterMode());
        out.writeFloat(attr.getAnisotropicFilterDegree());
        int points = attr.getSharpenTextureFuncPointsCount();
        out.writeInt(points);
        if (points > 0) {
            float[] lod = new float[points];
            float[] pts = new float[points];
            attr.getSharpenTextureFunc(lod, pts);
            for (int i = 0; i < points; ++i) {
                out.writeFloat(lod[i]);
                out.writeFloat(pts[i]);
            }
        }
        points = attr.getFilter4FuncPointsCount();
        out.writeInt(points);
        if (points >= 4) {
            float[] weights = new float[points];
            attr.getFilter4Func(weights);
            for (int i = 0; i < points; ++i) {
                out.writeFloat(weights[i]);
            }
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        Texture attr = (Texture)this.node;
        attr.setBoundaryColor(this.control.readColor4f(in));
        attr.setBoundaryModeS(in.readInt());
        attr.setBoundaryModeT(in.readInt());
        attr.setEnable(in.readBoolean());
        this.imageComponents = new int[in.readInt()];
        for (int i = 0; i < this.imageComponents.length; ++i) {
            this.imageComponents[i] = in.readInt();
        }
        int mag = in.readInt();
        try {
            attr.setMagFilter(mag);
        }
        catch (IllegalArgumentException e) {
            if (mag == 5) {
                attr.setMagFilter(3);
            }
            if (mag == 4) {
                attr.setMagFilter(2);
            }
            attr.setMagFilter(0);
        }
        attr.setMinFilter(in.readInt());
        attr.setBaseLevel(in.readInt());
        attr.setMaximumLevel(in.readInt());
        attr.setMinimumLOD(in.readFloat());
        attr.setMaximumLOD(in.readFloat());
        attr.setLodOffset((Tuple3f)this.control.readPoint3f(in));
        attr.setAnisotropicFilterMode(in.readInt());
        attr.setAnisotropicFilterDegree(in.readFloat());
        int points = in.readInt();
        if (points > 0) {
            float[] lod = new float[points];
            float[] pts = new float[points];
            for (int i = 0; i < points; ++i) {
                lod[i] = in.readFloat();
                pts[i] = in.readFloat();
            }
            attr.setSharpenTextureFunc(lod, pts);
        }
        if ((points = in.readInt()) >= 4) {
            float[] weights = new float[points];
            for (int i = 0; i < points; ++i) {
                weights[i] = in.readFloat();
            }
            attr.setFilter4Func(weights);
        }
    }

    @Override
    public void addSubReference() {
        if (!(this.node instanceof TextureCubeMap)) {
            for (int i = 0; i < this.imageComponents.length; ++i) {
                this.control.getSymbolTable().incNodeComponentRefCount(this.imageComponents[i]);
            }
        }
    }

    @Override
    public void buildGraph() {
        if (!(this.node instanceof TextureCubeMap)) {
            for (int i = 0; i < this.imageComponents.length; ++i) {
                ((Texture)this.node).setImage(i, (ImageComponent)this.control.getSymbolTable().getJ3dNode(this.imageComponents[i]));
            }
        }
        super.buildGraph();
    }
}

