/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.sjep;

import java.util.Iterator;
import java.util.LinkedList;
import org.scijava.sjep.Operator;
import org.scijava.sjep.Tokens;

public class SyntaxTree
implements Iterable<SyntaxTree> {
    private final Object token;
    private SyntaxTree[] children;

    public SyntaxTree(LinkedList<Object> tokens) {
        this.token = tokens.removeLast();
        if (Tokens.isOperator(this.token)) {
            Operator op = (Operator)this.token;
            int arity = op.getArity();
            if (arity > 0) {
                this.children = new SyntaxTree[arity];
            }
            for (int i = this.children.length - 1; i >= 0; --i) {
                this.children[i] = new SyntaxTree(tokens);
            }
        }
    }

    public Object token() {
        return this.token;
    }

    public SyntaxTree child(int index) {
        return this.children[index];
    }

    public int count() {
        return this.children == null ? 0 : this.children.length;
    }

    public LinkedList<Object> postfix() {
        LinkedList<Object> queue = new LinkedList<Object>();
        this.postfix(queue);
        return queue;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public Iterator<SyntaxTree> iterator() {
        return new Iterator<SyntaxTree>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < SyntaxTree.this.count();
            }

            @Override
            public SyntaxTree next() {
                return SyntaxTree.this.child(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void postfix(LinkedList<Object> queue) {
        for (SyntaxTree child : this) {
            child.postfix(queue);
        }
        queue.add(this.token());
    }

    private String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + " '" + this.token + "'\n");
        String deeperPrefix = " " + prefix + "-";
        for (int i = 0; i < this.count(); ++i) {
            sb.append(this.child(i).toString(deeperPrefix));
        }
        return sb.toString();
    }
}

