/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.progress;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.progress.Progress;
import org.scijava.progress.TestSuiteTaskConsumer;

public class DefaultProgressTest {
    private static final long NUM_ITERATIONS = 100L;
    private static final long NUM_STAGES = 10L;

    @Test
    public void testUpdateWithoutDefinition() {
        Supplier<Long> progressible = () -> {
            int foo = 0;
            int i = 0;
            while ((long)i < 100L) {
                ++foo;
                ++i;
            }
            return 100L;
        };
        TestSuiteTaskConsumer listener = new TestSuiteTaskConsumer(0L);
        Progress.addListener(progressible, (Consumer)listener);
        Progress.register(progressible);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)listener.isComplete());
    }

    @Test
    public void testEmptyProgress() {
        Supplier<Long> progressible = () -> {
            Progress.defineTotal((long)0L);
            return 0L;
        };
        TestSuiteTaskConsumer listener = new TestSuiteTaskConsumer(0L);
        Progress.addListener(progressible, (Consumer)listener);
        Progress.register(progressible);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)listener.isComplete());
    }

    @Test
    public void testSingleStageReporter() {
        Supplier<Long> progressible = () -> {
            Progress.defineTotal((long)100L);
            int i = 0;
            while ((long)i < 100L) {
                Progress.update();
                ++i;
            }
            return 100L;
        };
        TestSuiteTaskConsumer listener = new TestSuiteTaskConsumer(100L);
        Progress.addListener(progressible, (Consumer)listener);
        Progress.register(progressible);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)listener.isComplete());
    }

    @Test
    public void testMultipleExecutions() {
        Supplier<Long> progressible = () -> {
            Progress.defineTotal((long)100L);
            int i = 0;
            while ((long)i < 100L) {
                Progress.update();
                ++i;
            }
            return 100L;
        };
        TestSuiteTaskConsumer listener = new TestSuiteTaskConsumer(100L);
        Progress.addListener(progressible, (Consumer)listener);
        Progress.register(progressible);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)listener.isComplete());
        listener.reset();
        Progress.register(progressible);
        progressible.get();
        Progress.complete();
    }

    @Test
    public void testMultiStageReporter() {
        Supplier<Long> progressible = () -> {
            Progress.defineTotal((long)1000L);
            int j = 0;
            while ((long)j < 10L) {
                int i = 0;
                while ((long)i < 100L) {
                    Progress.update();
                    ++i;
                }
                ++j;
            }
            return 1000L;
        };
        long expected = 1000L;
        TestSuiteTaskConsumer listener = new TestSuiteTaskConsumer(expected);
        Progress.addListener(progressible, (Consumer)listener);
        Progress.register(progressible);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)listener.isComplete());
    }

    @Test
    public void testGlobalTaskConsumer() {
        Supplier<Long> progressible = () -> {
            Progress.defineTotal((long)100L);
            int i = 0;
            while ((long)i < 100L) {
                Progress.update();
                ++i;
            }
            return 100L;
        };
        String id = "This is a global listener";
        TestSuiteTaskConsumer listener = new TestSuiteTaskConsumer(100L, id);
        Progress.addGlobalListener((Consumer)listener);
        Progress.register(progressible, (String)id);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)listener.isComplete());
    }

    @Test
    public void testTaskConsumer() {
        Supplier<Long> progressible = () -> {
            Progress.defineTotal((long)100L);
            int i = 0;
            while ((long)i < 100L) {
                Progress.update();
                ++i;
            }
            return 100L;
        };
        String goodId = "This one should be listened to";
        TestSuiteTaskConsumer goodListener = new TestSuiteTaskConsumer(100L, goodId);
        Progress.addGlobalListener((Consumer)goodListener);
        Progress.register(progressible, (String)goodId);
        String badId = "This one should not be listened to";
        TestSuiteTaskConsumer badListener = new TestSuiteTaskConsumer(100L, badId);
        Progress.addGlobalListener((Consumer)badListener);
        progressible.get();
        Progress.complete();
        Assertions.assertTrue((boolean)goodListener.isComplete());
        Assertions.assertEquals((double)0.0, (double)badListener.progress(), (double)1.0E-6);
    }
}

