/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import java.lang.reflect.Field;
import org.scijava.common3.Types;
import org.scijava.struct.AnnotatedParameterMember;
import org.scijava.struct.Member;
import org.scijava.struct.MemberInstance;
import org.scijava.struct.Parameter;
import org.scijava.struct.ParameterStructs;
import org.scijava.struct.Struct;
import org.scijava.struct.ValidityException;
import org.scijava.struct.ValueAccessible;
import org.scijava.struct.ValueAccessibleMemberInstance;

public class FieldParameterMember<T>
extends AnnotatedParameterMember<T>
implements ValueAccessible<T> {
    private final Field field;
    private final Class<?> structType;
    private final Struct struct;

    public FieldParameterMember(Field field, Class<?> structType) throws ValidityException {
        super(Types.typeOf((Field)field, structType), field.getAnnotation(Parameter.class));
        this.field = field;
        this.structType = structType;
        this.struct = this.isStruct() ? ParameterStructs.structOf(this.rawType()) : null;
    }

    public Field getField() {
        return this.field;
    }

    public T get(Object o) {
        try {
            Object value = ParameterStructs.field(this).get(o);
            return (T)value;
        }
        catch (IllegalAccessException exc) {
            return null;
        }
    }

    public void set(T value, Object o) {
        try {
            ParameterStructs.field(this).set(o, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public T getDefaultValue() {
        try {
            Object dummy = this.structType.newInstance();
            Object value = this.getField().get(dummy);
            return (T)value;
        }
        catch (IllegalAccessException | InstantiationException exc) {
            throw new IllegalStateException("Missing no-args constructor", exc);
        }
    }

    @Override
    public String key() {
        String key = this.getAnnotation().key();
        return key == null || key.isEmpty() ? this.field.getName() : key;
    }

    public Struct childStruct() {
        return this.struct;
    }

    public MemberInstance<T> createInstance(Object o) {
        return new ValueAccessibleMemberInstance((Member)this, o);
    }
}

