/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scijava.common3.Annotations;
import org.scijava.common3.Classes;
import org.scijava.common3.Types;
import org.scijava.struct.FieldParameterMember;
import org.scijava.struct.FunctionalParameterMember;
import org.scijava.struct.ItemIO;
import org.scijava.struct.ItemVisibility;
import org.scijava.struct.Member;
import org.scijava.struct.Parameter;
import org.scijava.struct.Parameters;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.ValidityException;
import org.scijava.struct.ValidityProblem;

public final class ParameterStructs {
    public static <C> StructInstance<C> create(C object) throws ValidityException {
        return ParameterStructs.structOf(object.getClass()).createInstance(object);
    }

    public static Struct structOf(Class<?> type) throws ValidityException {
        List<Member<?>> items = ParameterStructs.parse(type);
        return () -> items;
    }

    public static List<Member<?>> parse(Class<?> type) throws ValidityException {
        if (type == null) {
            return null;
        }
        ArrayList items = new ArrayList();
        ArrayList<ValidityProblem> problems = new ArrayList<ValidityProblem>();
        if (Modifier.isAbstract(type.getModifiers())) {
            problems.add(new ValidityProblem("Struct class is abstract"));
        }
        HashSet<String> names = new HashSet<String>();
        Class<?> paramsClass = ParameterStructs.findParametersDeclaration(type);
        if (paramsClass != null) {
            Parameters params = paramsClass.getAnnotation(Parameters.class);
            Class<?> functionalType = ParameterStructs.findFunctionalInterface(paramsClass);
            Parameter[] p = params.value();
            int paramCount = functionalType.getTypeParameters().length;
            Type[] itemTypes = Types.typeParamsOf(type, functionalType);
            if (p.length == paramCount) {
                for (int i = 0; i < p.length; ++i) {
                    Type itemType;
                    Class rawItemType;
                    String key = p[i].key();
                    boolean valid = ParameterStructs.checkValidity(p[i], key, rawItemType = Types.raw((Type)(itemType = i < itemTypes.length ? itemTypes[i] : null)), false, names, problems);
                    if (!valid) continue;
                    try {
                        FunctionalParameterMember item = new FunctionalParameterMember(itemType, p[i]);
                        names.add(key);
                        items.add(item);
                        continue;
                    }
                    catch (ValidityException exc) {
                        problems.addAll(exc.problems());
                    }
                }
            } else {
                problems.add(new ValidityProblem("Need " + paramCount + " parameters for " + functionalType.getName() + " but got " + p.length));
            }
        }
        List fields = Annotations.annotatedFields(type, Parameter.class);
        for (Field f : fields) {
            f.setAccessible(true);
            Parameter param = f.getAnnotation(Parameter.class);
            String name = f.getName();
            boolean isFinal = Modifier.isFinal(f.getModifiers());
            boolean valid = ParameterStructs.checkValidity(param, name, f.getType(), isFinal, names, problems);
            if (!valid) continue;
            try {
                FieldParameterMember item = new FieldParameterMember(f, type);
                names.add(name);
                items.add(item);
            }
            catch (ValidityException exc) {
                problems.addAll(exc.problems());
            }
        }
        if (!problems.isEmpty()) {
            throw new ValidityException(problems);
        }
        return items;
    }

    public static <T> Field field(Member<T> item) {
        if (item instanceof FieldParameterMember) {
            FieldParameterMember fpItem = (FieldParameterMember)item;
            return fpItem.getField();
        }
        return null;
    }

    private static boolean isImmutable(Class<?> type) {
        return Classes.isNumber(type) || Classes.isText(type) || Classes.isBoolean(type);
    }

    private static Class<?> findParametersDeclaration(Class<?> type) {
        if (type == null) {
            return null;
        }
        ArrayDeque types = new ArrayDeque();
        types.add(type);
        while (!types.isEmpty()) {
            Class candidate = (Class)types.pop();
            if (candidate.getAnnotation(Parameters.class) != null) {
                return candidate;
            }
            Class superType = candidate.getSuperclass();
            if (superType != null) {
                types.add(superType);
            }
            types.addAll(Arrays.asList(candidate.getInterfaces()));
        }
        return null;
    }

    private static Class<?> findFunctionalInterface(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (type.getAnnotation(FunctionalInterface.class) != null) {
            return type;
        }
        for (Class<?> iface : type.getInterfaces()) {
            Class<?> result = ParameterStructs.findFunctionalInterface(iface);
            if (result == null) continue;
            return result;
        }
        return ParameterStructs.findFunctionalInterface(type.getSuperclass());
    }

    private static boolean checkValidity(Parameter param, String name, Class<?> type, boolean isFinal, Set<String> names, ArrayList<ValidityProblem> problems) {
        String error;
        boolean isMessage;
        boolean valid = true;
        boolean bl = isMessage = param.visibility() == ItemVisibility.MESSAGE;
        if (isFinal && !isMessage) {
            error = "Invalid final parameter: " + name;
            problems.add(new ValidityProblem(error));
            valid = false;
        }
        if (names.contains(name)) {
            error = "Invalid duplicate parameter: " + name;
            problems.add(new ValidityProblem(error));
            valid = false;
        }
        if ((param.type() == ItemIO.CONTAINER || param.type() == ItemIO.MUTABLE) && ParameterStructs.isImmutable(type)) {
            error = "Immutable BOTH parameter: " + name;
            problems.add(new ValidityProblem(error));
            valid = false;
        }
        return valid;
    }
}

