/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.struct;

import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.struct.ItemIO;
import org.scijava.struct.Member;
import org.scijava.struct.MemberInstance;
import org.scijava.struct.Parameter;
import org.scijava.struct.ParameterStructs;
import org.scijava.struct.Parameters;
import org.scijava.struct.Struct;
import org.scijava.struct.StructInstance;
import org.scijava.struct.Structs;

public class StructTest {
    @Test
    public void testBasicStruct() {
        Struct p = ParameterStructs.structOf(VariousParameters.class);
        List items = p.members();
        this.assertParam("a", Integer.TYPE, ItemIO.INPUT, (Member)items.get(0));
        this.assertParam("b", (Type)((Object)Double.class), ItemIO.INPUT, (Member<?>)((Member)items.get(1)));
        this.assertParam("c", Byte.TYPE, ItemIO.INPUT, (Member)items.get(2));
        this.assertParam("d", (Type)((Object)Object.class), ItemIO.INPUT, (Member<?>)((Member)items.get(3)));
        this.assertParam("o", Double.TYPE, ItemIO.OUTPUT, (Member)items.get(4));
        this.assertParam("p", (Type)((Object)String.class), ItemIO.OUTPUT, (Member<?>)((Member)items.get(5)));
    }

    @Test
    public void testFunctionalParameters() {
        Struct info = ParameterStructs.structOf(TruncAndMultiply.class);
        List items = info.members();
        Assertions.assertEquals((int)3, (int)items.size());
        this.assertParam("input", (Type)((Object)Double.class), ItemIO.INPUT, (Member<?>)((Member)items.get(0)));
        this.assertParam("result", (Type)((Object)Long.class), ItemIO.OUTPUT, (Member<?>)((Member)items.get(1)));
        this.assertParam("multiplier", Long.TYPE, ItemIO.INPUT, (Member)items.get(2));
    }

    @Test
    public void testStructAccess() {
        Struct struct = ParameterStructs.structOf(VariousParameters.class);
        VariousParameters vp = new VariousParameters();
        vp.a = 5;
        vp.b = 3.3;
        vp.c = (byte)2;
        vp.d = "Hello";
        vp.o = 12.3;
        vp.p = "Goodbye";
        StructInstance vpInstance = struct.createInstance((Object)vp);
        Assertions.assertEquals((Object)5, (Object)vpInstance.member("a").get());
        Assertions.assertEquals((Object)3.3, (Object)vpInstance.member("b").get());
        Assertions.assertEquals((Object)2, (Object)vpInstance.member("c").get());
        Assertions.assertEquals((Object)"Hello", (Object)vpInstance.member("d").get());
        Assertions.assertEquals((Object)12.3, (Object)vpInstance.member("o").get());
        Assertions.assertEquals((Object)"Goodbye", (Object)vpInstance.member("p").get());
        vpInstance.member("a").set((Object)6);
        Assertions.assertEquals((int)6, (int)vp.a);
        vpInstance.member("p").set((Object)"Yo");
        Assertions.assertEquals((Object)"Yo", (Object)vp.p);
    }

    @Test
    public void testNestedStructs() {
        Struct hlpStruct = ParameterStructs.structOf(HighLevelParameters.class);
        List hlpMembers = hlpStruct.members();
        Member npMember = (Member)hlpMembers.get(0);
        this.assertParam("np", (Type)((Object)NestedParameters.class), ItemIO.INPUT, (Member<?>)npMember);
        this.assertParam("junk", (Type)((Object)String.class), ItemIO.INPUT, (Member<?>)((Member)hlpMembers.get(1)));
        Assertions.assertTrue((boolean)npMember.isStruct());
        Struct npStruct = npMember.childStruct();
        List npMembers = npStruct.members();
        this.assertParam("stuff", (Type)((Object)String.class), ItemIO.INPUT, (Member<?>)((Member)npMembers.get(0)));
        Member vpMember = (Member)npMembers.get(1);
        this.assertParam("vp", (Type)((Object)VariousParameters.class), ItemIO.INPUT, (Member<?>)vpMember);
        this.assertParam("things", (Type)((Object)String.class), ItemIO.OUTPUT, (Member<?>)((Member)npMembers.get(2)));
        Assertions.assertTrue((boolean)vpMember.isStruct());
        Struct vpStruct = vpMember.childStruct();
        Assertions.assertNotNull((Object)vpStruct);
        List vpMembers = vpStruct.members();
        this.assertParam("a", Integer.TYPE, ItemIO.INPUT, (Member)vpMembers.get(0));
        this.assertParam("b", (Type)((Object)Double.class), ItemIO.INPUT, (Member<?>)((Member)vpMembers.get(1)));
        this.assertParam("c", Byte.TYPE, ItemIO.INPUT, (Member)vpMembers.get(2));
        this.assertParam("d", (Type)((Object)Object.class), ItemIO.INPUT, (Member<?>)((Member)vpMembers.get(3)));
        this.assertParam("o", Double.TYPE, ItemIO.OUTPUT, (Member)vpMembers.get(4));
        this.assertParam("p", (Type)((Object)String.class), ItemIO.OUTPUT, (Member<?>)((Member)vpMembers.get(5)));
        NestedParameters np = new NestedParameters();
        np.vp = new VariousParameters();
        np.vp.a = 9;
        np.vp.b = 8.7;
        np.vp.c = (byte)6;
        np.vp.d = "asdf";
        np.vp.o = 5.4;
        np.vp.p = "fdsa";
        HashMap<CallSite, Object> nestedMembers = new HashMap<CallSite, Object>();
        StructInstance npInstance = npStruct.createInstance((Object)np);
        for (MemberInstance memberInstance : npInstance) {
            if (!memberInstance.member().isStruct()) continue;
            StructInstance nestedInstance = Structs.expand((MemberInstance)memberInstance);
            for (Member nestedMember : nestedInstance.struct()) {
                String key = memberInstance.member().key() + "." + nestedMember.key();
                nestedMembers.put((CallSite)((Object)key), nestedInstance.member(nestedMember.key()).get());
            }
        }
        Assertions.assertEquals((int)6, (int)nestedMembers.size());
        Assertions.assertEquals((Object)9, nestedMembers.get("vp.a"));
        Assertions.assertEquals((Object)8.7, nestedMembers.get("vp.b"));
        Assertions.assertEquals((Object)6, nestedMembers.get("vp.c"));
        Assertions.assertEquals((Object)"asdf", nestedMembers.get("vp.d"));
        Assertions.assertEquals((Object)5.4, nestedMembers.get("vp.o"));
        Assertions.assertEquals((Object)"fdsa", nestedMembers.get("vp.p"));
        String expectedString = "np: org.scijava.struct.StructTest$NestedParameters [INPUT]\n  stuff: java.lang.String [INPUT]\n  vp: org.scijava.struct.StructTest$VariousParameters [INPUT]\n    a: int [INPUT]\n    b: java.lang.Double [INPUT]\n    c: byte [INPUT]\n    d: java.lang.Object [INPUT]\n    o: double [OUTPUT]\n    p: java.lang.String [OUTPUT]\n  things: java.lang.String [OUTPUT]\njunk: java.lang.String [INPUT]";
        Assertions.assertEquals((Object)expectedString, (Object)Structs.toString((Struct)hlpStruct));
    }

    private void assertParam(String key, Type type, ItemIO ioType, Member<?> pMember) {
        Assertions.assertEquals((Object)key, (Object)pMember.key());
        Assertions.assertEquals((Object)type, (Object)pMember.type());
        Assertions.assertSame((Object)ioType, (Object)pMember.getIOType());
    }

    @Parameters(value={@Parameter(key="input"), @Parameter(type=ItemIO.OUTPUT, key="result")})
    public static class TruncAndMultiply
    implements Function<Double, Long> {
        @Parameter
        long multiplier;

        @Override
        public Long apply(Double t) {
            return (long)t.intValue() * this.multiplier;
        }
    }

    public static class HighLevelParameters {
        @Parameter(struct=true)
        private NestedParameters np;
        @Parameter
        private String junk;
    }

    public static class NestedParameters {
        @Parameter
        private String stuff;
        @Parameter(struct=true)
        private VariousParameters vp;
        @Parameter(type=ItemIO.OUTPUT)
        private String things;

        public void win() {
            this.things = "VfB Stuttgart";
        }
    }

    public static class VariousParameters {
        @Parameter
        public int a;
        @Parameter
        public Double b;
        @Parameter
        public byte c;
        @Parameter
        public Object d;
        @Parameter(type=ItemIO.OUTPUT)
        public double o;
        @Parameter(type=ItemIO.OUTPUT)
        public String p;
    }
}

