/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.sqlproc.engine.impl.SqlMetaType;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;

public class SqlUtils {
    static final String GET_PREFIX_BOOLEAN = "is";
    static final int GET_PREFIX_BOOLEAN_LEN = "is".length();
    static final String GET_PREFIX_COMMON = "get";
    static final int GET_PREFIX_COMMON_LEN = "get".length();
    static final String SET_PREFIX_COMMON = "set";
    static final int SET_PREFIX_COMMON_LEN = "set".length();

    private SqlUtils() {
    }

    static void appendJavaIdent(StringBuilder s, String ident) {
        int len;
        int n = len = ident != null ? ident.length() : 0;
        if (s != null && len > 0) {
            s.append(Character.toUpperCase(ident.charAt(0)));
            if (len > 1) {
                s.append(ident.substring(1));
            }
        }
    }

    static String is(String name) {
        int len = name != null ? name.length() : 0;
        return SqlUtils.is(name, len);
    }

    static String get(String name) {
        int len = name != null ? name.length() : 0;
        return SqlUtils.get(name, len);
    }

    static String set(String name) {
        int len = name != null ? name.length() : 0;
        return SqlUtils.set(name, len);
    }

    static String is(String name, int len) {
        StringBuilder s = new StringBuilder(len + GET_PREFIX_BOOLEAN_LEN);
        s.append(GET_PREFIX_BOOLEAN);
        SqlUtils.appendJavaIdent(s, name);
        return s.toString();
    }

    static String get(String name, int len) {
        StringBuilder s = new StringBuilder(len + GET_PREFIX_COMMON_LEN);
        s.append(GET_PREFIX_COMMON);
        SqlUtils.appendJavaIdent(s, name);
        return s.toString();
    }

    static String set(String name, int len) {
        StringBuilder s = new StringBuilder(len + SET_PREFIX_COMMON_LEN);
        s.append(SET_PREFIX_COMMON);
        SqlUtils.appendJavaIdent(s, name);
        return s.toString();
    }

    static Method getMethod(Class<?> clazz, String ... names) {
        for (String name : names) {
            try {
                Method m = clazz.getMethod(name, null);
                if (!Modifier.isPublic(m.getModifiers())) continue;
                return m;
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        if (clazz.getSuperclass() != null) {
            return SqlUtils.getMethod(clazz.getSuperclass(), names);
        }
        return null;
    }

    static Method getMethodIgnoreParameters(Class<?> clazz, String name) {
        Method m;
        block3: {
            m = null;
            try {
                Method[] mm = clazz.getMethods();
                if (mm == null) break block3;
                for (int i = 0; i < mm.length; ++i) {
                    if (!name.equals(mm[i].getName()) || !Modifier.isPublic(mm[i].getModifiers())) continue;
                    m = mm[i];
                    break;
                }
            }
            catch (SecurityException ex) {
                m = null;
            }
        }
        return m;
    }

    static Method getMethod(Class<?> clazz, Class<?> param, String ... names) {
        for (String name : names) {
            try {
                Method m = clazz.getMethod(name, param);
                if (!Modifier.isPublic(m.getModifiers())) continue;
                return m;
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        if (clazz.getSuperclass() != null) {
            return SqlUtils.getMethod(clazz.getSuperclass(), param, names);
        }
        return null;
    }

    static Method getMethod(Class<?> clazz, String name, Class<?> param) {
        return SqlUtils.getMethod(clazz, param, name);
    }

    static Method getSetter(Object pojo, String attributeName, Class<?> ... classes) {
        if (classes == null) {
            Method m = SqlUtils.getMethodIgnoreParameters(pojo.getClass(), SqlUtils.set(attributeName));
            return m;
        }
        for (Class<?> clazz : classes) {
            Method m = SqlUtils.getMethod(pojo.getClass(), SqlUtils.set(attributeName), clazz);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    static Method getMethodEnumToValue(Class<?> clazz) {
        return SqlUtils.getMethod(clazz, SqlProcessContext.getFeatures("METHODS_ENUM_IN"));
    }

    static Method getMethodValueToEnum(Class<?> clazz, Class<?> param) {
        return SqlUtils.getMethod(clazz, param, SqlProcessContext.getFeatures("METHODS_ENUM_OUT"));
    }

    static Method getMethodValueToEnum(Class<?> clazz) {
        Method m = SqlUtils.getMethod(clazz, Integer.class, SqlProcessContext.getFeatures("METHODS_ENUM_OUT"));
        if (m == null) {
            m = SqlUtils.getMethod(clazz, String.class, SqlProcessContext.getFeatures("METHODS_ENUM_OUT"));
        }
        return m;
    }

    static Class<?> getFieldType(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            return f.getType();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return SqlUtils.getFieldType(clazz.getSuperclass(), name);
            }
            return null;
        }
    }

    static Object invokeMethod(Object obj, String nameGet, String nameIs) {
        Method m = SqlUtils.getMethod(obj.getClass(), nameGet, nameIs);
        obj = SqlUtils.invokeMethod(m, obj);
        return obj;
    }

    static Object invokeMethod(Method m, Object obj) {
        Object result;
        if (m != null) {
            try {
                result = m.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            result = null;
        }
        return result;
    }

    static Object invokeMethod(Method m, Object obj, Object param) {
        Object result;
        if (m != null) {
            try {
                result = m.invoke(obj, param);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            result = null;
        }
        return result;
    }

    public static <E> Object getInstance(Class<E> resultClass) {
        Object instance = null;
        try {
            Constructor<E> constructor = resultClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isEmpty(Object obj, SqlType sqlType, boolean inSqlSetOrInsert) throws IllegalArgumentException {
        String value;
        String string = value = sqlType != null && sqlType.getValue() != null ? sqlType.getValue().toLowerCase() : null;
        if ("notnull".equals(value) && obj == null) {
            throw new IllegalArgumentException("notnull");
        }
        if (inSqlSetOrInsert && obj == null) {
            return true;
        }
        if ("any".equals(value)) {
            return true;
        }
        if ("null".equals(value)) {
            return obj == null;
        }
        if (obj == null) {
            return false;
        }
        return !(obj instanceof Collection ? ((Collection)obj).isEmpty() : obj.toString().length() <= 0);
    }

    static boolean isTrue(Object obj, SqlType sqlType) {
        if (sqlType == null || sqlType.getValue() == null) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    String str = ((String)obj).trim();
                    return str.length() > 0 && !str.toLowerCase().equals("false");
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue() > 0L;
                }
                if (obj.getClass().isEnum()) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (obj == null) {
            return sqlType.getValue().toLowerCase().equals("null");
        }
        if (obj.getClass().isEnum()) {
            if (obj.toString().equals(sqlType.getValue())) {
                return true;
            }
            if (sqlType.getMetaType() == SqlMetaType.ENUM_STRING) {
                Method m = SqlUtils.getMethodEnumToValue(obj.getClass());
                if (m != null) {
                    return ((String)SqlUtils.invokeMethod(m, obj)).equals(sqlType.getValue());
                }
                return false;
            }
            if (sqlType.getMetaType() == SqlMetaType.ENUM_INT) {
                Method m = SqlUtils.getMethodEnumToValue(obj.getClass());
                if (m != null) {
                    return SqlUtils.invokeMethod(m, obj).toString().equals(sqlType.getValue());
                }
                return false;
            }
            return false;
        }
        return obj.toString().equals(sqlType.getValue());
    }

    static Byte[] toBytes(byte[] barr) {
        if (barr == null) {
            return null;
        }
        Byte[] res = new Byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = new Byte(barr[i]);
        }
        return res;
    }

    static byte[] toBytes(Byte[] barr) {
        if (barr == null) {
            return null;
        }
        byte[] res = new byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = barr[i] != null ? barr[i] : (byte)0;
        }
        return res;
    }

    public static String getFeature(Map<String, Object> features, String name) {
        Object o = features.get(name);
        return o != null && o instanceof String ? (String)o : null;
    }

    public static Boolean isFeature(Map<String, Object> features, String name, Boolean defaultValue) {
        Object o = features.get(name);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    public static boolean isEmpty(StringBuilder sb) {
        if (sb == null) {
            return true;
        }
        String s = sb.toString().trim();
        return s.length() == 0;
    }
}

