/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlProcessContext;

public class SqlUtils {
    static final String SUPPVAL_ID = "id";
    static final String SUPPVAL_GTYPE = "gtype";
    static final String SUPPVAL_TYPE = "type";
    static final String SUPPVAL_DISCRIMINATOR = "discr";

    public static Object getEnumToValue(Object obj) {
        if (obj == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            try {
                return MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Class getEnumToClass(Class clazz) {
        if (clazz == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_IN")) {
            Method m = MethodUtils.getMatchingAccessibleMethod((Class)clazz, (String)methodName, (Class[])new Class[0]);
            if (m == null) continue;
            return m.getReturnType();
        }
        return null;
    }

    public static Object getValueToEnum(Class<?> objClass, Object val) {
        if (val == null) {
            return null;
        }
        for (String methodName : SqlProcessContext.getFeatures("METHODS_ENUM_OUT")) {
            try {
                return MethodUtils.invokeStaticMethod(objClass, (String)methodName, (Object)val);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static Object convertBigDecimal(Class<?> attributeType, Object resultValue) {
        if (resultValue == null || !(resultValue instanceof BigDecimal)) {
            return resultValue;
        }
        BigDecimal result = (BigDecimal)resultValue;
        if (attributeType == Byte.class || attributeType == Byte.TYPE) {
            return result.byteValue();
        }
        if (attributeType == Integer.class || attributeType == Integer.TYPE) {
            return result.intValue();
        }
        if (attributeType == Long.class || attributeType == Long.TYPE) {
            return result.longValue();
        }
        if (attributeType == Short.class || attributeType == Short.TYPE) {
            return result.shortValue();
        }
        return result;
    }

    public static Byte[] toBytes(byte[] barr) {
        if (barr == null) {
            return null;
        }
        Byte[] res = new Byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = new Byte(barr[i]);
        }
        return res;
    }

    public static byte[] toBytes(Byte[] barr) {
        if (barr == null) {
            return null;
        }
        byte[] res = new byte[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            res[i] = barr[i] != null ? barr[i] : (byte)0;
        }
        return res;
    }

    public static boolean isEmpty(StringBuilder sb) {
        if (sb == null) {
            return true;
        }
        String s = sb.toString().trim();
        return s.length() == 0;
    }

    public static String beforeChar(String s, char c) {
        int ix = s.indexOf(c);
        if (ix < 0) {
            return s;
        }
        return s.substring(0, ix);
    }

    public static String afterChar(String s, char c) {
        int ix = s.indexOf(c);
        if (ix < 0) {
            return null;
        }
        return s.substring(ix + 1);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return new Date(cal.getTime().getTime());
    }

    public static Time getTime(int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.clear(1);
        cal.clear(2);
        cal.clear(5);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return new Time(cal.getTime().getTime());
    }

    public static java.util.Date getDateTime(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal.getTime();
    }

    public static Map<String, Object> getDefaultFeatures(String filterPrefix) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        if (filterPrefix != null && !filterPrefix.endsWith("_")) {
            filterPrefix = filterPrefix + "_";
        }
        String fullPrefix = filterPrefix != null ? filterPrefix + "DEFAULT_" : null;
        int fullPrefixLength = fullPrefix != null ? fullPrefix.length() : 0;
        String shortPrefix = "DEFAULT_";
        int shortPrefixLength = shortPrefix.length();
        for (Field f : SqlFeature.class.getDeclaredFields()) {
            String featureName;
            if (fullPrefix != null && f.getName().startsWith(fullPrefix) && features.get(featureName = f.getName().substring(fullPrefixLength)) == null) {
                try {
                    features.put(featureName, f.get(null));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            if (!f.getName().startsWith(shortPrefix) || features.get(featureName = f.getName().substring(shortPrefixLength)) != null) continue;
            try {
                features.put(featureName, f.get(null));
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return features;
    }

    public static String getIdsKey(Object[] resultValues, Map<String, SqlMappingIdentity> identities, String fullName) {
        String idsKey = "";
        int i = 0;
        SqlMappingIdentity ident = identities.get(fullName);
        for (List<Integer> identityIndexes : ident.allIdentityIndexes) {
            for (Integer identityIndex : identityIndexes) {
                Object o = resultValues[identityIndex];
                if (o == null) continue;
                if (i > 0) {
                    idsKey = idsKey + '-';
                }
                idsKey = idsKey + identityIndex;
                idsKey = idsKey + '-';
                idsKey = idsKey + o;
                break;
            }
            ++i;
        }
        return idsKey;
    }

    public static String getIdsKey(Object[] resultValues, Integer mainIdentityIndex) {
        String idsKey = "" + mainIdentityIndex + "-" + resultValues[mainIdentityIndex];
        return idsKey;
    }

    public static List<Integer> asList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (array == null) {
            return list;
        }
        for (int item : array) {
            list.add(item);
        }
        return list;
    }
}

