/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.SqlProviderType;

public abstract class SqlDateTimeType
extends SqlProviderType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Date.class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"DATETIME"};
    }

    @Override
    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        query.addScalar(dbName, this.getProviderSqlType());
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
        if (resultValue instanceof Timestamp) {
            ((Timestamp)resultValue).setNanos(0);
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, Timestamp.class, Date.class)) {
                return;
            }
        } else if (resultValue instanceof Date) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, Timestamp.class, Date.class)) {
                return;
            }
        } else {
            if (ingoreError) {
                this.logger.error("Incorrect datetime " + resultValue + " for " + attributeName + " in " + resultInstance);
                return;
            }
            throw new SqlRuntimeException("Incorrect datetime " + resultValue + " for " + attributeName + " in " + resultInstance);
        }
        if (!ingoreError) {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
        this.logger.error("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlNullType());
        } else if (inputValue instanceof Timestamp) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Timestamp)inputValue);
            cal.set(14, 0);
            query.setParameter(paramName, cal.getTime(), this.getProviderSqlType());
        } else if (inputValue instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)inputValue);
            cal.set(14, 0);
            query.setParameter(paramName, cal.getTime(), this.getProviderSqlType());
        } else if (ingoreError) {
            this.logger.error("Incorrect datetime " + inputValue + " for " + paramName);
        } else {
            throw new SqlRuntimeException("Incorrect datetime " + inputValue + " for " + paramName);
        }
    }
}

