/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.SqlDefaultType;

public abstract class SqlDateTimeType
extends SqlDefaultType {
    @Override
    public Class<?>[] getClassTypesForDefault() {
        return new Class[]{Timestamp.class, Date.class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"DATETIME"};
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult for META type " + this + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue + ", resultType" + (resultValue != null ? resultValue.getClass() : null));
        }
        if (resultValue instanceof Timestamp) {
            ((Timestamp)resultValue).setNanos(0);
        }
        super.setResult(runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter for META type " + this + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputTypes=" + inputTypes);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof Timestamp) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Timestamp)inputValue);
            cal.set(14, 0);
            query.setParameter(paramName, cal.getTime(), this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)inputValue);
            cal.set(14, 0);
            query.setParameter(paramName, cal.getTime(), this.getProviderSqlType(), new Class[0]);
        } else {
            this.error(ingoreError, "Incorrect datetime " + inputValue + " for " + paramName);
        }
    }
}

