/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.plugin.SqlFromToPlugin;
import org.sqlproc.engine.type.IdentitySetter;
import org.sqlproc.engine.type.OutValueSetter;

public class JdbcQuery
implements SqlQuery {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    Connection connection;
    String queryString;
    List<String> scalars = new ArrayList<String>();
    Map<String, Object> scalarTypes = new HashMap<String, Object>();
    List<String> parameters = new ArrayList<String>();
    Map<String, Object> parameterValues = new HashMap<String, Object>();
    Map<String, Object> parameterTypes = new HashMap<String, Object>();
    Map<String, Object> parameterOutValueTypes = new HashMap<String, Object>();
    Map<String, OutValueSetter> parameterOutValueSetters = new HashMap<String, OutValueSetter>();
    Map<Integer, Integer> parameterOutValuesToPickup = new LinkedHashMap<Integer, Integer>();
    List<String> identities = new ArrayList<String>();
    Map<String, IdentitySetter> identitySetters = new HashMap<String, IdentitySetter>();
    Map<String, Object> identityTypes = new HashMap<String, Object>();
    SqlControl sqlControl;
    Integer timeout;
    Integer firstResult;
    Integer maxResults;
    Integer fetchSize;
    boolean ordered;
    boolean logError;
    private static final Map<String, Object> NO_MORE_DATA = new LinkedHashMap<String, Object>();
    static final Pattern CALL = Pattern.compile("\\s*\\{?\\s*(\\?)?\\s*=?\\s*call\\s*(.*?)\\s*}?\\s*");

    public JdbcQuery(Connection connection, String queryString) {
        this.connection = connection;
        this.queryString = queryString;
    }

    @Override
    public Object getQuery() {
        return this.connection;
    }

    @Override
    public SqlQuery setSqlControl(SqlControl sqlControl) {
        this.sqlControl = sqlControl;
        if (sqlControl != null) {
            this.timeout = sqlControl.getMaxTimeout();
            this.firstResult = sqlControl.getFirstResult();
            this.maxResults = sqlControl.getMaxResults();
            this.fetchSize = sqlControl.getFetchSize();
        } else {
            this.timeout = null;
            this.firstResult = null;
            this.maxResults = null;
            this.fetchSize = null;
        }
        return this;
    }

    @Override
    public SqlQuery setOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    @Override
    public List<Map<String, Object>> list(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        String sql;
        String query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        SqlFromToPlugin.LimitType limitType = this.maxResults != null ? runtimeCtx.getPluginFactory().getSqlFromToPlugin().limitQuery(runtimeCtx, this.queryString, queryResult, this.firstResult, this.maxResults, this.ordered) : null;
        String string = query = limitType != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + query);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(query, this.parameterValues)) != null) {
            query = sql;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement(query);
            if (this.sqlControl != null && this.sqlControl.getMaxTimeout() != null) {
                ps.setQueryTimeout(this.timeout);
            }
            if (this.fetchSize != null) {
                ps.setFetchSize(this.fetchSize);
            }
            this.setParameters(ps, limitType, 1);
            rs = ps.executeQuery();
            if (this.fetchSize != null) {
                rs.setFetchSize(this.fetchSize);
            }
            List<Map<String, Object>> list = this.getResults(rs);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + (list != null ? Integer.valueOf(list.size()) : "null"));
            }
            List<Map<String, Object>> list2 = list;
            return list2;
        }
        catch (SQLException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Map<String, Object> unique(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        List<Map<String, Object>> list = this.list(runtimeCtx);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Map<String, Object> first = list.get(0);
        int i = 1;
        if (i < size) {
            throw new RuntimeException("TODO UNIQUE");
        }
        return first;
    }

    @Override
    public int query(SqlRuntimeContext runtimeCtx, SqlQuery.SqlQueryRowProcessor sqlQueryRowProcessor) throws SqlProcessorException {
        String sql;
        String query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        SqlFromToPlugin.LimitType limitType = this.maxResults != null ? runtimeCtx.getPluginFactory().getSqlFromToPlugin().limitQuery(runtimeCtx, this.queryString, queryResult, this.firstResult, this.maxResults, this.ordered) : null;
        String string = query = limitType != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + query);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(query, this.parameterValues)) != null) {
            query = sql;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        int rownum = 0;
        try {
            ps = this.connection.prepareStatement(query);
            if (this.sqlControl != null && this.sqlControl.getMaxTimeout() != null) {
                ps.setQueryTimeout(this.timeout);
            }
            if (this.fetchSize != null) {
                ps.setFetchSize(this.fetchSize);
            }
            this.setParameters(ps, limitType, 1);
            rs = ps.executeQuery();
            if (this.fetchSize != null) {
                rs.setFetchSize(this.fetchSize);
            }
            Map<String, Object> row22 = this.getOneResult(rs);
            while (row22 != NO_MORE_DATA && sqlQueryRowProcessor.processRow(row22, ++rownum)) {
                row22 = this.getOneResult(rs);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + rownum);
            }
            int row22 = rownum;
            return row22;
        }
        catch (SQLException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public int update(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        String sql;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update, query=" + this.queryString);
        }
        if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null && (sql = this.sqlControl.getLowLevelSqlCallback().handleInputValues(this.queryString, this.parameterValues)) != null) {
            this.queryString = sql;
        }
        Statement ps = null;
        try {
            boolean retrieveIdentityFromStatement = this.isSetJDBCIdentity();
            ps = retrieveIdentityFromStatement ? this.connection.prepareStatement(this.queryString, 1) : this.connection.prepareStatement(this.queryString);
            if (this.sqlControl != null && this.sqlControl.getMaxTimeout() != null) {
                ps.setQueryTimeout(this.timeout);
            }
            this.setParameters((PreparedStatement)ps, null, 1);
            int updated = ps.executeUpdate();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update, number of updated rows=" + updated);
            }
            if (!this.identities.isEmpty()) {
                String identityName = this.identities.get(0);
                if (retrieveIdentityFromStatement) {
                    this.getGeneratedKeys(identityName, ps);
                } else {
                    this.doIdentitySelect(identityName);
                }
            }
            int n = updated;
            return n;
        }
        catch (SQLException ex) {
            throw this.newSqlProcessorException(ex, this.queryString);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private boolean isSetJDBCIdentity() {
        for (String identityName : this.identities) {
            IdentitySetter identitySetter = this.identitySetters.get(identityName);
            if (!identitySetter.getIdentitySelect().equals(SqlFeature.JDBC.name())) continue;
            return true;
        }
        return false;
    }

    protected void getGeneratedKeys(String identityName, Statement statement) {
        IdentitySetter identitySetter = this.identitySetters.get(identityName);
        Object identityType = this.identityTypes.get(identityName);
        if (identityType == null) {
            identityType = this.parameterTypes.get(identityName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", getGeneratedKeys(), identityType=" + identityType);
        }
        ResultSet rs = null;
        Object identityValue = null;
        try {
            rs = statement.getGeneratedKeys();
            while (rs.next()) {
                identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                if (!rs.wasNull()) continue;
                identityValue = null;
            }
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + identityValue);
            }
        }
        catch (SQLException ex) {
            throw new SqlProcessorException("Statement.getGeneratedKeys() failed.", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void doIdentitySelect(String identityName) {
        IdentitySetter identitySetter = this.identitySetters.get(identityName);
        Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", select=" + identitySetter.getIdentitySelect() + ", identityType=" + identityType);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Object identityValue = null;
        try {
            ps = this.connection.prepareStatement(identitySetter.getIdentitySelect());
            rs = ps.executeQuery();
            while (rs.next()) {
                identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                if (!rs.wasNull()) continue;
                identityValue = null;
            }
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + identityValue);
            }
        }
        catch (SQLException ex) {
            throw new SqlProcessorException("Identity select failed.", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public List<Map<String, Object>> callList(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callList, query=" + this.queryString);
        }
        Statement cs = null;
        ResultSet rs = null;
        List<Map<String, Object>> list = null;
        boolean hasResultSet = false;
        String query = null;
        try {
            Matcher matcher = CALL.matcher(this.queryString);
            if (!matcher.matches()) {
                throw new SqlProcessorException("'" + this.queryString + "' isn't the correct call statement");
            }
            query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
            cs = this.connection.prepareCall(query);
            if (this.sqlControl != null && this.sqlControl.getMaxTimeout() != null) {
                cs.setQueryTimeout(this.timeout);
            }
            if (this.fetchSize != null) {
                cs.setFetchSize(this.fetchSize);
            }
            this.setParameters((PreparedStatement)cs, null, 1);
            hasResultSet = cs.execute();
            if (hasResultSet || cs.getMoreResults()) {
                rs = cs.getResultSet();
                if (this.fetchSize != null) {
                    rs.setFetchSize(this.fetchSize);
                }
                list = this.getResults(rs);
                this.getParameters((CallableStatement)cs, false);
            } else {
                rs = (ResultSet)this.getParameters((CallableStatement)cs, true).values().toArray()[0];
                if (this.fetchSize != null) {
                    rs.setFetchSize(this.fetchSize);
                }
                list = this.getResults(rs);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + (list != null ? Integer.valueOf(list.size()) : "null"));
            }
            List<Map<String, Object>> list2 = list;
            return list2;
        }
        catch (SQLException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Map<String, Object> callUnique(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        List<Map<String, Object>> list = this.callList(runtimeCtx);
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Map<String, Object> first = list.get(0);
        int i = 1;
        if (i < size) {
            throw new RuntimeException("TODO UNIQUE");
        }
        return first;
    }

    @Override
    public int callUpdate(SqlRuntimeContext runtimeCtx) throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callUpdate, query=" + this.queryString);
        }
        Statement cs = null;
        ResultSet rs = null;
        String query = null;
        try {
            Matcher matcher = CALL.matcher(this.queryString);
            if (!matcher.matches()) {
                throw new SqlProcessorException("'" + this.queryString + "' isn't the correct call statement");
            }
            query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{ call " + matcher.group(2) + "}";
            cs = this.connection.prepareCall(query);
            if (this.sqlControl != null && this.sqlControl.getMaxTimeout() != null) {
                cs.setQueryTimeout(this.timeout);
            }
            this.setParameters((PreparedStatement)cs, null, 1);
            cs.execute();
            int updated = cs.getUpdateCount();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callUpdate, number of updated rows=" + updated);
            }
            this.getParameters((CallableStatement)cs, false);
            int n = updated;
            return n;
        }
        catch (SQLException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public Map<String, Object> callFunction() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callFunction, query=" + this.queryString);
        }
        Statement cs = null;
        ResultSet rs = null;
        List<Map<String, Object>> list = null;
        Map<String, Object> result = null;
        boolean hasResultSet = false;
        String query = null;
        try {
            Matcher matcher = CALL.matcher(this.queryString);
            if (!matcher.matches()) {
                throw new SqlProcessorException("'" + this.queryString + "' isn't the correct call statement");
            }
            query = matcher.group(1) != null ? "{? = call " + matcher.group(2) + "}" : "{call " + matcher.group(2) + "}";
            cs = this.connection.prepareCall(query);
            if (this.sqlControl != null && this.sqlControl.getMaxTimeout() != null) {
                cs.setQueryTimeout(this.timeout);
            }
            if (this.fetchSize != null) {
                cs.setFetchSize(this.fetchSize);
            }
            this.setParameters((PreparedStatement)cs, null, 1);
            hasResultSet = cs.execute();
            if (hasResultSet) {
                rs = cs.getResultSet();
                if (this.fetchSize != null) {
                    rs.setFetchSize(this.fetchSize);
                }
                if ((list = this.getResults(rs)) != null && !list.isEmpty()) {
                    result = list.get(0);
                }
                this.getParameters((CallableStatement)cs, false);
            } else {
                result = this.getParameters((CallableStatement)cs, true);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("callFunction, result=" + result);
            }
            Map<String, Object> map = result;
            return map;
        }
        catch (SQLException ex) {
            throw this.newSqlProcessorException(ex, query);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public SqlQuery addScalar(String columnAlias) {
        this.scalars.add(columnAlias);
        return this;
    }

    @Override
    public SqlQuery addScalar(String columnAlias, Object type, Class<?> ... moreTypes) {
        if (type != null && !(type instanceof JdbcSqlType) && !(type instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.scalars.add(columnAlias);
        this.scalarTypes.put(columnAlias, type);
        return this;
    }

    @Override
    public SqlQuery setParameter(String name, Object val) throws SqlProcessorException {
        this.parameters.add(name);
        this.parameterValues.put(name, val);
        return this;
    }

    @Override
    public SqlQuery setParameter(String name, Object val, Object type, Class<?> ... moreTypes) throws SqlProcessorException {
        if (type != null && !(type instanceof JdbcSqlType) && !(type instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        if (val != null && val instanceof IdentitySetter) {
            this.identities.add(name);
            this.identitySetters.put(name, (IdentitySetter)val);
            this.identityTypes.put(name, type);
        } else if (val != null && val instanceof OutValueSetter) {
            if (!this.parameterTypes.containsKey(name)) {
                this.parameters.add(name);
                this.parameterTypes.put(name, type);
            }
            this.parameterOutValueTypes.put(name, type);
            this.parameterOutValueSetters.put(name, (OutValueSetter)val);
        } else {
            this.parameters.add(name);
            this.parameterValues.put(name, val);
            this.parameterTypes.put(name, type);
        }
        return this;
    }

    @Override
    public SqlQuery setParameterList(String name, Object[] vals) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlQuery setParameterList(String name, Object[] vals, Object type, Class<?> ... moreTypes) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    protected void setParameters(PreparedStatement ps, SqlFromToPlugin.LimitType limitType, int start) throws SQLException, SqlProcessorException {
        int ix = start;
        ix = this.setLimits(ps, limitType, ix, false);
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            String name = this.parameters.get(i);
            Object type = this.parameterTypes.get(name);
            if (this.parameterValues.containsKey(name)) {
                Object value = this.parameterValues.get(name);
                if (type != null) {
                    if (type instanceof JdbcSqlType) {
                        JdbcSqlType sqlType = (JdbcSqlType)type;
                        try {
                            if (value == null) {
                                if (this.logger.isTraceEnabled()) {
                                    this.logger.trace("setNull, ix=" + (ix + i) + ", type=" + type);
                                }
                                ps.setNull(ix + i, sqlType.getDatabaseSqlType());
                            }
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("setParameters, ix=" + (ix + i) + ", value=" + value);
                            }
                            sqlType.set(ps, ix + i, value);
                        }
                        catch (ClassCastException cce) {
                            StringBuilder sb = new StringBuilder("Not compatible input value of type ").append(value != null ? value.getClass() : "null");
                            sb.append(". The JDBC type for ").append(name).append(" is ").append(sqlType != null ? sqlType.getClass() : "null");
                            sb.append(".");
                            throw new SqlProcessorException(sb.toString(), cce);
                        }
                    } else if (value == null) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("setNull, ix=" + (ix + i) + ", type=" + type);
                        }
                        ps.setNull(ix + i, (Integer)type);
                    } else {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("setNull, ix=" + (ix + i) + ", type=" + type);
                        }
                        ps.setObject(ix + i, value, (Integer)type);
                    }
                } else {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("setObject, ix=" + (ix + i) + ", type=" + type);
                    }
                    ps.setObject(ix + i, value);
                }
            }
            if (!this.parameterOutValueSetters.containsKey(name)) continue;
            CallableStatement cs = (CallableStatement)ps;
            if (type != null) {
                if (type instanceof JdbcSqlType) {
                    cs.registerOutParameter(ix + i, (int)((JdbcSqlType)type).getDatabaseSqlType());
                } else {
                    cs.registerOutParameter(ix + i, (int)((Integer)type));
                }
            } else {
                throw new SqlProcessorException("OUT parameter type for callable statement is null");
            }
            this.parameterOutValuesToPickup.put(i, ix + i);
        }
        ix = this.setLimits(ps, limitType, ix + this.parameters.size(), true);
    }

    protected int setLimits(PreparedStatement ps, SqlFromToPlugin.LimitType limitType, int ix, boolean afterSql) throws SQLException {
        if (limitType == null) {
            return ix;
        }
        if (afterSql && !limitType.afterSql) {
            return ix;
        }
        if (!afterSql && limitType.afterSql) {
            return ix;
        }
        if (limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        if (limitType.alsoFirst) {
            if (limitType.zeroBasedFirst) {
                ps.setInt(ix++, this.firstResult);
            } else {
                ps.setInt(ix++, this.firstResult);
            }
        }
        if (!limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        return ix;
    }

    protected Map<String, Object> getParameters(CallableStatement cs, boolean isFunction) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        boolean resultInited = false;
        for (int i : this.parameterOutValuesToPickup.keySet()) {
            int ix = this.parameterOutValuesToPickup.get(i);
            String name = this.parameters.get(i);
            Object type = this.parameterOutValueTypes.get(name);
            if (type == null) {
                type = this.parameterTypes.get(name);
            }
            OutValueSetter outValueSetter = this.parameterOutValueSetters.get(name);
            Object outValue = null;
            outValue = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(cs, ix) : cs.getObject(ix);
            Object _outValue = outValueSetter.setOutValue(outValue);
            if (resultInited) continue;
            result.put(name, _outValue);
            resultInited = true;
        }
        return result;
    }

    protected List<Map<String, Object>> getResults(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (rs == null) {
            return result;
        }
        Map<String, Object> row = this.getOneResult(rs);
        while (row != NO_MORE_DATA) {
            if (this.sqlControl != null && this.sqlControl.getLowLevelSqlCallback() != null) {
                this.sqlControl.getLowLevelSqlCallback().handleOutputValues(row);
            }
            result.add(row);
            row = this.getOneResult(rs);
        }
        return result;
    }

    protected Map<String, Object> getOneResult(ResultSet rs) throws SQLException {
        if (rs == null) {
            return NO_MORE_DATA;
        }
        if (rs.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            int n = this.scalars.size();
            for (int i = 0; i < n; ++i) {
                String name = this.scalars.get(i);
                Object type = this.scalarTypes.get(name);
                Object value = null;
                value = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(rs, name) : rs.getObject(name);
                if (rs.wasNull()) {
                    value = null;
                }
                row.put(name, value);
            }
            return row;
        }
        return NO_MORE_DATA;
    }

    @Override
    public int[] executeBatch(String[] statements) throws SqlProcessorException {
        if (statements == null) {
            return null;
        }
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            for (String statement : statements) {
                if (statement == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("executeBatch, add " + statement);
                }
                stmt.addBatch(statement);
            }
            int[] result = stmt.executeBatch();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("executeBatch, result " + SqlUtils.asList(result));
            }
            int[] nArray = result;
            return nArray;
        }
        catch (SQLException ex) {
            throw new SqlProcessorException(ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected SqlProcessorException newSqlProcessorException(SQLException ex, String query) {
        if (this.logError) {
            this.logger.error("Failed SQL command '" + query + "': " + ex.getMessage());
            return new SqlProcessorException(ex);
        }
        return new SqlProcessorException(ex, query);
    }

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }
}

