/*
 * Decompiled with CFR 0.152.
 */
package dot.cc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import dot.cc.exception.GenerateTokenException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;

public class DotEngine {
    private final JwtBuilder jwtBuilder;
    private final ObjectMapper objectMapper;
    private String dot_engine_api_url = "http://api.dot.cc/api/createToken";
    private final String app_key;
    private final String app_secret;
    private boolean debug = false;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private static final String FORMAT = "{\"room\":\"%s\",\"user_id\":\"%s\",\"app_key\":\"%s\",\"expires\":%d,\"role\":\"%S\",\"nonce\":%d}";

    public void enableLog() {
        this.debug = true;
    }

    public DotEngine(String appKey, String appSecret) {
        this.app_key = appKey;
        this.app_secret = appSecret;
        this.jwtBuilder = Jwts.builder().signWith(SignatureAlgorithm.HS256, this.app_secret.getBytes()).setHeaderParam("alg", (Object)"HS256").setHeaderParam("typ", (Object)"JWT");
        this.jwtBuilder.setSubject("test").compact();
        this.objectMapper = new ObjectMapper();
    }

    public void setDotE2ngineApiUrl(String url) {
        this.dot_engine_api_url = url;
    }

    public String getJWTData(String room, String user, long expireTime, String role, int nonce) throws GenerateTokenException {
        return String.format(FORMAT, room, user, this.app_key, expireTime, role, nonce);
    }

    public String createToken(String room, String user, long expireTime) throws GenerateTokenException {
        return this.createToken(room, user, expireTime, "");
    }

    private String createToken(String room, String user, long expireTime, String role) throws GenerateTokenException {
        int not = new Random().nextInt(9999999);
        String srcData = this.getJWTData(room, user, expireTime, role, not);
        if (this.debug) {
            System.out.println("get jwt src data=" + srcData);
        }
        long time = System.currentTimeMillis();
        String data = this.jwtBuilder.setSubject(srcData).compact();
        if (this.debug) {
            System.out.println("get jwt src cost=" + (System.currentTimeMillis() - time) + "ms encode =" + data);
        }
        String responseJson = this.getResponseJson(data);
        if (this.debug) {
            System.out.println("responseJson=" + responseJson);
        }
        if (responseJson.length() > 0) {
            try {
                JsonNode jsonpObject = this.objectMapper.readTree(responseJson);
                JsonNode e = jsonpObject.get("e");
                if (e != null && e.asText().length() > 0) {
                    throw new GenerateTokenException(e.asText());
                }
                return jsonpObject.get("d").get("token").asText();
            }
            catch (IOException e) {
                throw new GenerateTokenException("can'n parse response :" + responseJson + "\n" + e.getMessage());
            }
        }
        throw new GenerateTokenException("response return failure");
    }

    private String getResponseJson(String data) throws GenerateTokenException {
        BufferedInputStream in = null;
        try {
            if (this.debug) {
                System.out.println("start send request to " + this.dot_engine_api_url);
            }
            URL url = new URL(this.dot_engine_api_url);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(this.connectTimeout);
            urlConn.setReadTimeout(this.readTimeout);
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setRequestMethod("POST");
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConn.connect();
            BufferedOutputStream out = new BufferedOutputStream(urlConn.getOutputStream());
            StringBuilder paramsContent = new StringBuilder();
            paramsContent.append("app_key=").append(URLEncoder.encode(this.app_key, "UTF-8"));
            paramsContent.append("&sign=").append(URLEncoder.encode(data, "UTF-8"));
            out.write(paramsContent.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = urlConn.getResponseCode();
            if (this.debug) {
                System.out.println("httpcode=" + responseCode);
            }
            if (responseCode != 200) {
                throw new GenerateTokenException("send request failure   responseCode=" + responseCode);
            }
            in = new BufferedInputStream(urlConn.getInputStream());
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[8192];
            int lg = -1;
            while ((lg = in.read(buffer, 0, buffer.length)) > 0) {
                sb.append(new String(buffer, 0, lg));
            }
            in.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            if (this.debug) {
                System.err.println("err " + e);
            }
            throw new GenerateTokenException("send request failure  \n" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

