/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients;

import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.OptionsValidator;
import cloud.metaapi.sdk.clients.RetryOptions;
import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.error_handler.ApiException;
import cloud.metaapi.sdk.clients.error_handler.ConflictException;
import cloud.metaapi.sdk.clients.error_handler.ForbiddenException;
import cloud.metaapi.sdk.clients.error_handler.InternalException;
import cloud.metaapi.sdk.clients.error_handler.NotFoundException;
import cloud.metaapi.sdk.clients.error_handler.TooManyRequestsException;
import cloud.metaapi.sdk.clients.error_handler.UnauthorizedException;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.models.Error;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.JsonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.MultipartBody;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public class HttpClient {
    private int requestTimeout;
    private int connectTimeout;
    private int retries;
    private int minRetryDelay;
    private int maxRetryDelay;

    public HttpClient() throws ValidationException {
        this(60000, 60000);
    }

    public HttpClient(int requestTimeout, int connectTimeout) throws ValidationException {
        this(requestTimeout, connectTimeout, new RetryOptions());
    }

    public HttpClient(int requestTimeout, int connectTimeout, RetryOptions retryOpts) throws ValidationException {
        OptionsValidator validator = new OptionsValidator();
        validator.validateNonZeroInt(retryOpts.minDelayInSeconds, "retryOpts.minDelayInSeconds");
        validator.validateNonZeroInt(retryOpts.maxDelayInSeconds, "retryOpts.maxDelayInSeconds");
        this.requestTimeout = requestTimeout;
        this.connectTimeout = connectTimeout;
        this.retries = retryOpts.retries;
        this.minRetryDelay = retryOpts.minDelayInSeconds * 1000;
        this.maxRetryDelay = retryOpts.maxDelayInSeconds * 1000;
    }

    public CompletableFuture<String> request(HttpRequestOptions options) {
        return this.request(options, 0);
    }

    public CompletableFuture<String> request(HttpRequestOptions options, int retryCounter) {
        return this.makeCheckedRequest(options, retryCounter, Date.from(Instant.now().plusMillis(this.maxRetryDelay * this.retries)).getTime()).thenApply(response -> (String)response.getBody());
    }

    public <T> CompletableFuture<T> requestJson(HttpRequestOptions options, Class<T> valueType) {
        return this.requestJson(options, valueType, 0);
    }

    public <T> CompletableFuture<T> requestJson(HttpRequestOptions options, Class<T> valueType, int retryCounter) {
        return this.request(options, retryCounter).thenApply(response -> {
            try {
                return JsonMapper.getInstance().readValue(response, valueType);
            }
            catch (JsonProcessingException e) {
                throw new CompletionException(e);
            }
        });
    }

    protected CompletableFuture<HttpResponse<String>> makeCheckedRequest(HttpRequestOptions options, int retryCounter, long endTime) {
        return this.makeRequest(options).handle((response, error) -> {
            int localRetryCounter = retryCounter;
            int retryAfterSeconds = 0;
            if (response != null && response.getStatus() == 202) {
                retryAfterSeconds = Integer.valueOf(response.getHeaders().getFirst("retry-after"));
            }
            Throwable throwable = error = error != null ? new ApiException(error.getMessage(), 0, error.getCause()) : this.checkHttpError((HttpResponse<String>)response);
            if (error != null) {
                localRetryCounter = this.handleError((Throwable)error, localRetryCounter, endTime).join();
                return this.makeCheckedRequest(options, localRetryCounter, endTime).join();
            }
            if (retryAfterSeconds != 0) {
                this.handleRetry(endTime, retryAfterSeconds * 1000).join();
                response = this.makeCheckedRequest(options, localRetryCounter, endTime).join();
            }
            return response;
        });
    }

    private CompletableFuture<Void> handleRetry(long endTime, int retryAfter) {
        return Async.run(() -> {
            if (endTime > Date.from(Instant.now().plusMillis(retryAfter)).getTime()) {
                try {
                    Thread.sleep(retryAfter);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
            } else {
                throw new CompletionException(new TimeoutException("Timed out waiting for the end of the process of calculating metrics"));
            }
        });
    }

    private CompletableFuture<Integer> handleError(Throwable error, int retryCounter, long endTime) {
        return Async.supply(() -> {
            try {
                long retryTime;
                if (Arrays.asList(ConflictException.class, InternalException.class, ApiException.class).indexOf(error.getClass()) != -1 && retryCounter < this.retries) {
                    int pause = (int)Math.min(Math.pow(2.0, retryCounter) * (double)this.minRetryDelay, (double)this.maxRetryDelay);
                    Thread.sleep(pause);
                    return retryCounter + 1;
                }
                if (error instanceof TooManyRequestsException && (retryTime = ((TooManyRequestsException)error).metadata.recommendedRetryTime.getDate().getTime()) < endTime) {
                    Thread.sleep(retryTime - Date.from(Instant.now()).getTime());
                    return retryCounter;
                }
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
            throw new CompletionException(error);
        });
    }

    protected CompletableFuture<HttpResponse<String>> makeRequest(HttpRequestOptions options) {
        return Async.supply(() -> {
            try {
                GetRequest request = null;
                if (options.getMethod() == HttpRequestOptions.Method.GET) {
                    request = Unirest.get((String)options.getUrl());
                } else {
                    HttpRequestWithBody bodyRequest = null;
                    switch (options.getMethod()) {
                        case POST: {
                            bodyRequest = Unirest.post((String)options.getUrl());
                            break;
                        }
                        case PUT: {
                            bodyRequest = Unirest.put((String)options.getUrl());
                            break;
                        }
                        case DELETE: {
                            bodyRequest = Unirest.delete((String)options.getUrl());
                            break;
                        }
                    }
                    if (options.getBodyJson().isPresent()) {
                        String jsonString = JsonMapper.getInstance().writeValueAsString(options.getBodyJson().get());
                        request = bodyRequest.body(jsonString).header("content-type", "application/json");
                    } else if (options.getBodyFields().isPresent()) {
                        Map<String, Object> fields = options.getBodyFields().get();
                        if (fields.isEmpty()) {
                            request = bodyRequest;
                        } else {
                            MultipartBody multipartBody = bodyRequest.fields(null);
                            fields.forEach((name, value) -> {
                                if (value instanceof HttpRequestOptions.FileStreamField) {
                                    HttpRequestOptions.FileStreamField fileField = (HttpRequestOptions.FileStreamField)value;
                                    multipartBody.field(name, fileField.getStream(), fileField.getFileName());
                                } else {
                                    multipartBody.field(name, value.toString());
                                }
                            });
                            request = multipartBody;
                        }
                    } else {
                        request = bodyRequest;
                    }
                }
                GetRequest finalRequest = request;
                finalRequest.connectTimeout(this.connectTimeout);
                finalRequest.socketTimeout(this.requestTimeout);
                finalRequest.headers(options.getHeaders());
                options.getQueryParameters().forEach((arg_0, arg_1) -> HttpClient.lambda$null$6((HttpRequest)finalRequest, arg_0, arg_1));
                return finalRequest.asString();
            }
            catch (JsonProcessingException | UnirestException e) {
                throw new CompletionException(e);
            }
        });
    }

    private ApiException checkHttpError(HttpResponse<String> response) {
        try {
            Error error;
            int statusType = response.getStatus() / 100;
            if (statusType != 4 && statusType != 5) {
                return null;
            }
            try {
                error = (Error)JsonMapper.getInstance().readValue((String)response.getBody(), Error.class);
            }
            catch (JsonProcessingException e) {
                error = null;
            }
            switch (response.getStatus()) {
                case 400: {
                    return new ValidationException(error != null ? error.message : response.getStatusText(), error != null && error.details != null ? JsonMapper.getInstance().treeToValue((TreeNode)error.details, Object.class) : null);
                }
                case 401: {
                    return new UnauthorizedException(error != null ? error.message : response.getStatusText());
                }
                case 403: {
                    return new ForbiddenException(error != null ? error.message : response.getStatusText());
                }
                case 404: {
                    return new NotFoundException(error != null ? error.message : response.getStatusText());
                }
                case 409: {
                    return new ConflictException(error != null ? error.message : response.getStatusText());
                }
                case 429: {
                    return new TooManyRequestsException(error != null ? error.message : response.getStatusText(), error != null && error.metadata != null ? (TooManyRequestsException.TooManyRequestsExceptionMetadata)JsonMapper.getInstance().treeToValue((TreeNode)error.metadata, TooManyRequestsException.TooManyRequestsExceptionMetadata.class) : null);
                }
                case 500: {
                    return new InternalException(error != null ? error.message : response.getStatusText());
                }
            }
            return new ApiException(error != null ? error.message : response.getStatusText(), response.getStatus());
        }
        catch (JsonProcessingException err) {
            return new ApiException(err.getMessage(), 0, err.getCause());
        }
    }

    private static /* synthetic */ void lambda$null$6(HttpRequest finalRequest, String key, Object value) {
        if (value instanceof Collection) {
            finalRequest.queryString(key, (Collection)value);
        } else {
            finalRequest.queryString(key, value);
        }
    }
}

