/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class HttpRequestOptions {
    private String url;
    private Method method;
    private Map<String, Object> queryParameters = new ConcurrentHashMap<String, Object>();
    private Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private Optional<Map<String, Object>> bodyFields = Optional.empty();
    private Optional<Object> bodyJson = Optional.empty();

    public HttpRequestOptions(String url, Method method) {
        this.setUrl(url);
        this.setMethod(method);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setBody(Object jsonBody) {
        this.bodyJson = Optional.of(jsonBody);
        this.bodyFields = Optional.empty();
    }

    public void setBody(Map<String, Object> fields) {
        this.bodyFields = Optional.of(fields);
        this.bodyJson = Optional.empty();
    }

    public Optional<Object> getBodyJson() {
        return this.bodyJson;
    }

    public Optional<Map<String, Object>> getBodyFields() {
        return this.bodyFields;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static class FileStreamField {
        private InputStream stream;
        private String fileName;

        public FileStreamField(File file) throws FileNotFoundException {
            this.setFile(file);
        }

        public FileStreamField(InputStream stream, String fileName) {
            this.setFile(stream, fileName);
        }

        public void setFile(File file) throws FileNotFoundException {
            this.setFile(new FileInputStream(file), file.getName());
        }

        public void setFile(InputStream stream, String fileName) {
            this.stream = stream;
            this.fileName = fileName;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

