/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.meta_api.OutOfOrderListener;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.util.Js;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class PacketOrderer {
    private OutOfOrderListener outOfOrderListener;
    private int orderingTimeoutInSeconds;
    private Map<String, Boolean> isOutOfOrderEmitted = new ConcurrentHashMap<String, Boolean>();
    private Map<String, Long> sequenceNumberByInstance = new ConcurrentHashMap<String, Long>();
    private Map<String, Integer> lastSessionStartTimestamp = new ConcurrentHashMap<String, Integer>();
    private Map<String, List<Packet>> packetsByInstance = new ConcurrentHashMap<String, List<Packet>>();
    private int waitListSizeLimit = 100;
    private Timer outOfOrderJob;

    public PacketOrderer(OutOfOrderListener outOfOrderListener, int orderingTimeoutInSeconds) {
        this.outOfOrderListener = outOfOrderListener;
        this.orderingTimeoutInSeconds = orderingTimeoutInSeconds;
    }

    public void start() {
        final PacketOrderer self = this;
        this.sequenceNumberByInstance = new ConcurrentHashMap<String, Long>();
        this.lastSessionStartTimestamp = new ConcurrentHashMap<String, Integer>();
        this.packetsByInstance = new ConcurrentHashMap<String, List<Packet>>();
        if (this.outOfOrderJob == null) {
            this.outOfOrderJob = new Timer();
            this.outOfOrderJob.schedule(new TimerTask(){

                @Override
                public void run() {
                    self.emitOutOfOrderEvents();
                }
            }, 1000L, 1000L);
        }
    }

    public void stop() {
        if (this.outOfOrderJob != null) {
            this.outOfOrderJob.cancel();
            this.outOfOrderJob = null;
        }
    }

    public List<JsonNode> restoreOrder(JsonNode packet) {
        long sequenceNumber;
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        long l = sequenceNumber = packet.has("sequenceNumber") ? packet.get("sequenceNumber").asLong() : -1L;
        if (sequenceNumber == -1L) {
            result.add(packet);
            return result;
        }
        String accountId = packet.get("accountId").asText();
        int instanceIndex = packet.has("instanceIndex") ? packet.get("instanceIndex").asInt() : 0;
        String host = packet.hasNonNull("host") ? packet.get("host").asText() : null;
        String instanceId = accountId + ":" + instanceIndex + ":" + Js.or(host, 0);
        if (packet.get("type").asText().equals("synchronizationStarted") && packet.has("synchronizationId")) {
            this.isOutOfOrderEmitted.put(instanceId, false);
            this.sequenceNumberByInstance.put(instanceId, sequenceNumber);
            this.lastSessionStartTimestamp.put(instanceId, packet.get("sequenceTimestamp").asInt());
            if (this.packetsByInstance.containsKey(instanceId)) {
                this.packetsByInstance.get(instanceId).removeIf(waitPacket -> waitPacket.packet.get("sequenceTimestamp").asInt() < packet.get("sequenceTimestamp").asInt());
            }
            result.add(packet);
            result.addAll(this.findNextPacketsFromWaitList(instanceId));
            return result;
        }
        if (this.lastSessionStartTimestamp.containsKey(instanceId) && packet.get("sequenceTimestamp").asInt() < this.lastSessionStartTimestamp.get(instanceId)) {
            return result;
        }
        if (this.sequenceNumberByInstance.containsKey(instanceId) && sequenceNumber == this.sequenceNumberByInstance.get(instanceId)) {
            result.add(packet);
            return result;
        }
        if (this.sequenceNumberByInstance.containsKey(instanceId) && sequenceNumber == this.sequenceNumberByInstance.get(instanceId) + 1L) {
            this.sequenceNumberByInstance.put(instanceId, this.sequenceNumberByInstance.get(instanceId) + 1L);
            result.add(packet);
            result.addAll(this.findNextPacketsFromWaitList(instanceId));
            return result;
        }
        if (this.packetsByInstance.get(instanceId) == null) {
            this.packetsByInstance.put(instanceId, new ArrayList());
        }
        List<Packet> waitList = this.packetsByInstance.get(instanceId);
        Packet p = new Packet();
        p.instanceId = instanceId;
        p.accountId = accountId;
        p.instanceIndex = instanceIndex;
        p.sequenceNumber = sequenceNumber;
        p.packet = packet;
        p.receivedAt = new IsoTime(Date.from(Instant.now()));
        waitList.add(p);
        waitList.sort((e1, e2) -> e1.sequenceNumber - e2.sequenceNumber > 0L ? 1 : -1);
        while (waitList.size() > this.waitListSizeLimit) {
            waitList.remove(0);
        }
        return result;
    }

    public void onStreamClosed(String instanceId) {
        this.packetsByInstance.remove(instanceId);
        this.lastSessionStartTimestamp.remove(instanceId);
        this.sequenceNumberByInstance.remove(instanceId);
    }

    public void onReconnected(List<String> reconnectAccountIds) {
        new ArrayList<String>(this.packetsByInstance.keySet()).forEach(instanceId -> {
            if (reconnectAccountIds.contains(this.getAccountIdFromInstance((String)instanceId))) {
                this.packetsByInstance.remove(instanceId);
            }
        });
        new ArrayList<String>(this.lastSessionStartTimestamp.keySet()).forEach(instanceId -> {
            if (reconnectAccountIds.contains(this.getAccountIdFromInstance((String)instanceId))) {
                this.lastSessionStartTimestamp.remove(instanceId);
            }
        });
        new ArrayList<String>(this.sequenceNumberByInstance.keySet()).forEach(instanceId -> {
            if (reconnectAccountIds.contains(this.getAccountIdFromInstance((String)instanceId))) {
                this.sequenceNumberByInstance.remove(instanceId);
            }
        });
    }

    private String getAccountIdFromInstance(String instanceId) {
        return instanceId.split(":")[0];
    }

    private List<JsonNode> findNextPacketsFromWaitList(String instanceId) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        List waitList = this.packetsByInstance.getOrDefault(instanceId, new ArrayList());
        while (!(waitList.isEmpty() || ((Packet)waitList.get((int)0)).sequenceNumber != this.sequenceNumberByInstance.get(instanceId) && ((Packet)waitList.get((int)0)).sequenceNumber != this.sequenceNumberByInstance.get(instanceId) + 1L)) {
            result.add(((Packet)waitList.get((int)0)).packet);
            if (((Packet)waitList.get((int)0)).sequenceNumber == this.sequenceNumberByInstance.get(instanceId) + 1L) {
                this.sequenceNumberByInstance.put(instanceId, this.sequenceNumberByInstance.get(instanceId) + 1L);
            }
            waitList.remove(0);
        }
        if (waitList.isEmpty()) {
            this.packetsByInstance.remove(instanceId);
        }
        return result;
    }

    private void emitOutOfOrderEvents() {
        this.packetsByInstance.values().forEach(waitList -> {
            if (!waitList.isEmpty()) {
                String instanceId;
                Packet packet = (Packet)waitList.get(0);
                if (packet == null) {
                    return;
                }
                Instant receivedAtPlusTimeout = packet.receivedAt.getDate().toInstant().plusSeconds(this.orderingTimeoutInSeconds);
                if (receivedAtPlusTimeout.compareTo(Instant.now()) < 0 && (instanceId = packet.instanceId) != null && !this.isOutOfOrderEmitted.getOrDefault(instanceId, false).booleanValue()) {
                    this.isOutOfOrderEmitted.put(instanceId, true);
                    if (this.sequenceNumberByInstance.containsKey(instanceId)) {
                        this.outOfOrderListener.onOutOfOrderPacket(packet.accountId, packet.instanceIndex, this.sequenceNumberByInstance.get(instanceId) + 1L, packet.sequenceNumber, packet.packet, packet.receivedAt);
                    }
                }
            }
        });
    }

    protected class Packet {
        public String instanceId;
        public String accountId;
        public String host;
        public int instanceIndex;
        public long sequenceNumber;
        public JsonNode packet;
        public IsoTime receivedAt;

        protected Packet() {
        }
    }
}

