/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.HistoryFileManager;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryHistoryStorage
extends HistoryStorage {
    private String accountId;
    private HistoryFileManager fileManager;
    private List<MetatraderDeal> deals = new ArrayList<MetatraderDeal>();
    private List<MetatraderOrder> historyOrders = new ArrayList<MetatraderOrder>();
    private Map<String, Long> lastDealTimeByInstanceIndex = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> lastHistoryOrderTimeByInstanceIndex = new ConcurrentHashMap<String, Long>();

    public MemoryHistoryStorage(String accountId) {
        this(accountId, null);
    }

    public MemoryHistoryStorage(String accountId, String application) {
        this.accountId = accountId;
        if (application == null) {
            application = "MetaApi";
        }
        this.fileManager = ServiceProvider.createHistoryFileManager(this.accountId, application, this);
        this.fileManager.startUpdateJob();
    }

    @Override
    public CompletableFuture<Void> initialize() {
        return this.loadDataFromDisk();
    }

    @Override
    public List<MetatraderDeal> getDeals() {
        return this.deals;
    }

    @Override
    public List<MetatraderOrder> getHistoryOrders() {
        return this.historyOrders;
    }

    @Override
    public Map<String, Long> getLastDealTimeByInstanceIndex() {
        return this.lastDealTimeByInstanceIndex;
    }

    @Override
    public Map<String, Long> getLastHistoryOrderTimeByInstanceIndex() {
        return this.lastHistoryOrderTimeByInstanceIndex;
    }

    @Override
    public CompletableFuture<Void> clear() {
        this.deals.clear();
        this.historyOrders.clear();
        this.lastDealTimeByInstanceIndex.clear();
        this.lastHistoryOrderTimeByInstanceIndex.clear();
        return this.fileManager.deleteStorageFromDisk();
    }

    @Override
    public CompletableFuture<Void> loadData() {
        return this.loadDataFromDisk();
    }

    public CompletableFuture<Void> loadDataFromDisk() {
        return Async.run(() -> {
            HistoryFileManager.History history = this.fileManager.getHistoryFromDisk().join();
            this.deals = new ArrayList<MetatraderDeal>(history.deals);
            this.historyOrders = new ArrayList<MetatraderOrder>(history.historyOrders);
            this.lastDealTimeByInstanceIndex = history.lastDealTimeByInstanceIndex != null ? history.lastDealTimeByInstanceIndex : new ConcurrentHashMap<String, Long>();
            this.lastHistoryOrderTimeByInstanceIndex = history.lastHistoryOrderTimeByInstanceIndex != null ? history.lastHistoryOrderTimeByInstanceIndex : new ConcurrentHashMap<String, Long>();
        });
    }

    @Override
    public CompletableFuture<Void> updateStorage() {
        return this.updateDiskStorage();
    }

    public CompletableFuture<Void> updateDiskStorage() {
        return this.fileManager.updateDiskStorage();
    }

    @Override
    public CompletableFuture<IsoTime> getLastHistoryOrderTime(Integer instanceNumber) {
        long result = 0L;
        if (instanceNumber != null) {
            result = this.lastHistoryOrderTimeByInstanceIndex.containsKey("" + instanceNumber) ? this.lastHistoryOrderTimeByInstanceIndex.get("" + instanceNumber) : 0L;
        } else {
            for (long time : this.lastHistoryOrderTimeByInstanceIndex.values()) {
                if (time <= result) continue;
                result = time;
            }
        }
        return CompletableFuture.completedFuture(new IsoTime(Date.from(Instant.ofEpochMilli(result))));
    }

    @Override
    public CompletableFuture<IsoTime> getLastDealTime(Integer instanceNumber) {
        long result = 0L;
        if (instanceNumber != null) {
            result = this.lastDealTimeByInstanceIndex.containsKey("" + instanceNumber) ? this.lastDealTimeByInstanceIndex.get("" + instanceNumber) : 0L;
        } else {
            for (long time : this.lastDealTimeByInstanceIndex.values()) {
                if (time <= result) continue;
                result = time;
            }
        }
        return CompletableFuture.completedFuture(new IsoTime(Date.from(Instant.ofEpochMilli(result))));
    }

    @Override
    public CompletableFuture<Void> onHistoryOrderAdded(String instanceIndex, MetatraderOrder historyOrder) {
        Integer instance = this.getInstanceNumber(instanceIndex);
        int insertIndex = 0;
        int replacementIndex = -1;
        Date newHistoryOrderTime = this.getOrderDoneTime(historyOrder);
        if (!this.lastHistoryOrderTimeByInstanceIndex.containsKey("" + instance) || this.lastHistoryOrderTimeByInstanceIndex.get("" + instance) < newHistoryOrderTime.getTime()) {
            this.lastHistoryOrderTimeByInstanceIndex.put("" + instance, newHistoryOrderTime.getTime());
        }
        for (int i = this.historyOrders.size() - 1; i >= 0; --i) {
            MetatraderOrder order = this.historyOrders.get(i);
            Date historyOrderTime = this.getOrderDoneTime(order);
            int timeComparing = historyOrderTime.compareTo(newHistoryOrderTime);
            if (timeComparing >= 0 && (timeComparing != 0 || order.id.compareTo(historyOrder.id) > 0)) continue;
            if (timeComparing == 0 && order.id.equals(historyOrder.id) && order.type == historyOrder.type) {
                replacementIndex = i;
                break;
            }
            insertIndex = i + 1;
            break;
        }
        if (replacementIndex != -1) {
            this.historyOrders.set(replacementIndex, historyOrder);
            this.fileManager.setStartNewOrderIndex(replacementIndex);
        } else {
            this.historyOrders.add(insertIndex, historyOrder);
            this.fileManager.setStartNewOrderIndex(insertIndex);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDealAdded(String instanceIndex, MetatraderDeal deal) {
        Integer instance = this.getInstanceNumber(instanceIndex);
        int insertIndex = 0;
        int replacementIndex = -1;
        Date newDealTime = deal.time.getDate();
        if (!this.lastDealTimeByInstanceIndex.containsKey("" + instance) || this.lastDealTimeByInstanceIndex.get("" + instance) < newDealTime.getTime()) {
            this.lastDealTimeByInstanceIndex.put("" + instance, newDealTime.getTime());
        }
        for (int i = this.deals.size() - 1; i >= 0; --i) {
            MetatraderDeal d = this.deals.get(i);
            Date dealTime = d.time.getDate();
            int timeComparing = dealTime.compareTo(newDealTime);
            if (timeComparing >= 0 && (timeComparing != 0 || d.id.compareTo(deal.id) > 0) && (timeComparing != 0 || !d.id.equals(deal.id) || d.entryType.toString().compareTo(deal.entryType.toString()) > 0)) continue;
            if (timeComparing == 0 && d.id.equals(deal.id) && d.entryType == deal.entryType) {
                replacementIndex = i;
                break;
            }
            insertIndex = i + 1;
            break;
        }
        if (replacementIndex != -1) {
            this.deals.set(replacementIndex, deal);
            this.fileManager.setStartNewDealIndex(replacementIndex);
        } else {
            this.deals.add(insertIndex, deal);
            this.fileManager.setStartNewDealIndex(insertIndex);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDealSynchronizationFinished(String instanceIndex, String synchronizationId) {
        Integer instance = this.getInstanceNumber(instanceIndex);
        this.dealSynchronizationFinished.add("" + instance);
        return this.updateDiskStorage();
    }

    private Date getOrderDoneTime(MetatraderOrder order) {
        return order.doneTime != null ? order.doneTime.getDate() : Date.from(Instant.ofEpochSecond(0L));
    }
}

