/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.ReconnectListener;
import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.models.MarketDataSubscription;
import cloud.metaapi.sdk.clients.meta_api.models.MarketDataUnsubscription;
import cloud.metaapi.sdk.clients.meta_api.models.MarketTradeOptions;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountInformation;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderBook;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderCandle;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeals;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderHistoryOrders;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderPosition;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolPrice;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderSymbolSpecification;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTick;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTrade;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTradeResponse;
import cloud.metaapi.sdk.clients.meta_api.models.PendingTradeOptions;
import cloud.metaapi.sdk.clients.meta_api.models.StopOptions;
import cloud.metaapi.sdk.clients.meta_api.models.SynchronizationOptions;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.ConnectionHealthMonitor;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MemoryHistoryStorage;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import cloud.metaapi.sdk.meta_api.TerminalState;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.Js;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaApiConnection
extends SynchronizationListener
implements ReconnectListener {
    private static Logger logger = LogManager.getLogger(MetaApiConnection.class);
    private MetaApiWebsocketClient websocketClient;
    private MetatraderAccount account;
    private ConnectionRegistry connectionRegistry;
    private IsoTime historyStartTime = null;
    private TerminalState terminalState;
    private HistoryStorage historyStorage;
    private ConnectionHealthMonitor healthMonitor;
    private Map<String, Subscriptions> subscriptions = new ConcurrentHashMap<String, Subscriptions>();
    private Map<String, State> stateByInstanceIndex = new ConcurrentHashMap<String, State>();
    private List<SynchronizationListener> synchronizationListeners = new ArrayList<SynchronizationListener>();
    private boolean closed = false;

    public MetaApiConnection(MetaApiWebsocketClient websocketClient, MetatraderAccount account, HistoryStorage historyStorage, ConnectionRegistry connectionRegistry) {
        this(websocketClient, account, historyStorage, connectionRegistry, null);
    }

    public MetaApiConnection(MetaApiWebsocketClient websocketClient, MetatraderAccount account, HistoryStorage historyStorage, ConnectionRegistry connectionRegistry, IsoTime historyStartTime) {
        this.websocketClient = websocketClient;
        this.account = account;
        this.connectionRegistry = connectionRegistry;
        this.historyStartTime = historyStartTime;
        this.terminalState = new TerminalState();
        this.historyStorage = historyStorage != null ? historyStorage : new MemoryHistoryStorage(account.getId(), connectionRegistry.getApplication());
        this.healthMonitor = new ConnectionHealthMonitor(this);
        websocketClient.addSynchronizationListener(account.getId(), this);
        websocketClient.addSynchronizationListener(account.getId(), this.terminalState);
        websocketClient.addSynchronizationListener(account.getId(), this.historyStorage);
        websocketClient.addSynchronizationListener(account.getId(), this.healthMonitor);
        websocketClient.addReconnectListener(this, account.getId());
    }

    public CompletableFuture<MetatraderAccountInformation> getAccountInformation() {
        return this.websocketClient.getAccountInformation(this.account.getId());
    }

    public CompletableFuture<List<MetatraderPosition>> getPositions() {
        return this.websocketClient.getPositions(this.account.getId());
    }

    public CompletableFuture<MetatraderPosition> getPosition(String positionId) {
        return this.websocketClient.getPosition(this.account.getId(), positionId);
    }

    public CompletableFuture<List<MetatraderOrder>> getOrders() {
        return this.websocketClient.getOrders(this.account.getId());
    }

    public CompletableFuture<MetatraderOrder> getOrder(String orderId) {
        return this.websocketClient.getOrder(this.account.getId(), orderId);
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTicket(String ticket) {
        return this.websocketClient.getHistoryOrdersByTicket(this.account.getId(), ticket);
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByPosition(String positionId) {
        return this.websocketClient.getHistoryOrdersByPosition(this.account.getId(), positionId);
    }

    public CompletableFuture<MetatraderHistoryOrders> getHistoryOrdersByTimeRange(IsoTime startTime, IsoTime endTime, int offset, int limit) {
        return this.websocketClient.getHistoryOrdersByTimeRange(this.account.getId(), startTime, endTime, offset, limit);
    }

    public CompletableFuture<MetatraderDeals> getDealsByTicket(String ticket) {
        return this.websocketClient.getDealsByTicket(this.account.getId(), ticket);
    }

    public CompletableFuture<MetatraderDeals> getDealsByPosition(String positionId) {
        return this.websocketClient.getDealsByPosition(this.account.getId(), positionId);
    }

    public CompletableFuture<MetatraderDeals> getDealsByTimeRange(IsoTime startTime, IsoTime endTime, int offset, int limit) {
        return this.websocketClient.getDealsByTimeRange(this.account.getId(), startTime, endTime, offset, limit);
    }

    public CompletableFuture<Void> removeHistory() {
        return this.removeHistory(null);
    }

    public CompletableFuture<Void> removeHistory(String application) {
        this.historyStorage.clear();
        return this.websocketClient.removeHistory(this.account.getId(), application);
    }

    public CompletableFuture<Void> removeApplication() {
        this.historyStorage.clear();
        return this.websocketClient.removeApplication(this.account.getId());
    }

    public CompletableFuture<MetatraderTradeResponse> createMarketBuyOrder(String symbol, double volume, Double stopLoss, Double takeProfit, MarketTradeOptions options) {
        return this.createMarketBuyOrder(symbol, volume, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createMarketBuyOrder(String symbol, double volume, StopOptions stopLoss, StopOptions takeProfit, MarketTradeOptions options) {
        return this.createMarketBuyOrder(symbol, volume, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createMarketBuyOrder(String symbol, double volume, Object stopLoss, Object takeProfit, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY;
        trade.symbol = symbol;
        trade.volume = volume;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createMarketSellOrder(String symbol, double volume, Double stopLoss, Double takeProfit, MarketTradeOptions options) {
        return this.createMarketSellOrder(symbol, volume, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createMarketSellOrder(String symbol, double volume, StopOptions stopLoss, StopOptions takeProfit, MarketTradeOptions options) {
        return this.createMarketSellOrder(symbol, volume, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createMarketSellOrder(String symbol, double volume, Object stopLoss, Object takeProfit, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL;
        trade.symbol = symbol;
        trade.volume = volume;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createLimitBuyOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        return this.createLimitBuyOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createLimitBuyOrder(String symbol, double volume, double openPrice, StopOptions stopLoss, StopOptions takeProfit, PendingTradeOptions options) {
        return this.createLimitBuyOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createLimitBuyOrder(String symbol, double volume, double openPrice, Object stopLoss, Object takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY_LIMIT;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createLimitSellOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        return this.createLimitSellOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createLimitSellOrder(String symbol, double volume, double openPrice, StopOptions stopLoss, StopOptions takeProfit, PendingTradeOptions options) {
        return this.createLimitSellOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createLimitSellOrder(String symbol, double volume, double openPrice, Object stopLoss, Object takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL_LIMIT;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopBuyOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        return this.createStopBuyOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopBuyOrder(String symbol, double volume, double openPrice, StopOptions stopLoss, StopOptions takeProfit, PendingTradeOptions options) {
        return this.createStopBuyOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createStopBuyOrder(String symbol, double volume, double openPrice, Object stopLoss, Object takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY_STOP;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopSellOrder(String symbol, double volume, double openPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        return this.createStopSellOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopSellOrder(String symbol, double volume, double openPrice, StopOptions stopLoss, StopOptions takeProfit, PendingTradeOptions options) {
        return this.createStopSellOrder(symbol, volume, openPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createStopSellOrder(String symbol, double volume, double openPrice, Object stopLoss, Object takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL_STOP;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopLimitBuyOrder(String symbol, double volume, double openPrice, double stopLimitPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        return this.createStopLimitBuyOrder(symbol, volume, openPrice, stopLimitPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopLimitBuyOrder(String symbol, double volume, double openPrice, double stopLimitPrice, StopOptions stopLoss, StopOptions takeProfit, PendingTradeOptions options) {
        return this.createStopLimitBuyOrder(symbol, volume, openPrice, stopLimitPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createStopLimitBuyOrder(String symbol, double volume, double openPrice, double stopLimitPrice, Object stopLoss, Object takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_BUY_STOP_LIMIT;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        trade.stopLimitPrice = stopLimitPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopLimitSellOrder(String symbol, double volume, double openPrice, double stopLimitPrice, Double stopLoss, Double takeProfit, PendingTradeOptions options) {
        return this.createStopLimitSellOrder(symbol, volume, openPrice, stopLimitPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    public CompletableFuture<MetatraderTradeResponse> createStopLimitSellOrder(String symbol, double volume, double openPrice, double stopLimitPrice, StopOptions stopLoss, StopOptions takeProfit, PendingTradeOptions options) {
        return this.createStopLimitSellOrder(symbol, volume, openPrice, stopLimitPrice, (Object)stopLoss, (Object)takeProfit, options);
    }

    private CompletableFuture<MetatraderTradeResponse> createStopLimitSellOrder(String symbol, double volume, double openPrice, double stopLimitPrice, Object stopLoss, Object takeProfit, PendingTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_TYPE_SELL_STOP_LIMIT;
        trade.symbol = symbol;
        trade.volume = volume;
        trade.openPrice = openPrice;
        trade.stopLimitPrice = stopLimitPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> modifyPosition(String positionId, Double stopLoss, Double takeProfit) {
        return this.modifyPosition(positionId, (Object)stopLoss, (Object)takeProfit);
    }

    public CompletableFuture<MetatraderTradeResponse> modifyPosition(String positionId, StopOptions stopLoss, StopOptions takeProfit) {
        return this.modifyPosition(positionId, (Object)stopLoss, (Object)takeProfit);
    }

    private CompletableFuture<MetatraderTradeResponse> modifyPosition(String positionId, Object stopLoss, Object takeProfit) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_MODIFY;
        trade.positionId = positionId;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closePositionPartially(String positionId, double volume, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_PARTIAL;
        trade.positionId = positionId;
        trade.volume = volume;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closePosition(String positionId, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_CLOSE_ID;
        trade.positionId = positionId;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closeBy(String positionId, String oppositePositionId, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITION_CLOSE_BY;
        trade.positionId = positionId;
        trade.closeByPositionId = oppositePositionId;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> closePositionsBySymbol(String symbol, MarketTradeOptions options) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.POSITIONS_CLOSE_SYMBOL;
        trade.symbol = symbol;
        if (options != null) {
            this.copyModelProperties(options, trade);
        }
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> modifyOrder(String orderId, double openPrice, Double stopLoss, Double takeProfit) {
        return this.modifyOrder(orderId, openPrice, (Object)stopLoss, (Object)takeProfit);
    }

    public CompletableFuture<MetatraderTradeResponse> modifyOrder(String orderId, double openPrice, StopOptions stopLoss, StopOptions takeProfit) {
        return this.modifyOrder(orderId, openPrice, (Object)stopLoss, (Object)takeProfit);
    }

    private CompletableFuture<MetatraderTradeResponse> modifyOrder(String orderId, double openPrice, Object stopLoss, Object takeProfit) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_MODIFY;
        trade.orderId = orderId;
        trade.openPrice = openPrice;
        this.generateStopOptions(trade, stopLoss, takeProfit);
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<MetatraderTradeResponse> cancelOrder(String orderId) {
        MetatraderTrade trade = new MetatraderTrade();
        trade.actionType = MetatraderTrade.ActionType.ORDER_CANCEL;
        trade.orderId = orderId;
        return this.websocketClient.trade(this.account.getId(), trade);
    }

    public CompletableFuture<Void> reconnect() {
        return this.websocketClient.reconnect(this.account.getId());
    }

    public CompletableFuture<Boolean> synchronize(String instanceIndex) {
        return Async.supply(() -> {
            String synchronizationId;
            Integer instance = this.getInstanceNumber(instanceIndex);
            String host = this.getHostName(instanceIndex);
            IsoTime lastHistoryOrderTime = this.historyStorage.getLastHistoryOrderTime(instance).join();
            IsoTime startingHistoryOrderTime = this.historyStartTime == null || lastHistoryOrderTime.getDate().compareTo(this.historyStartTime.getDate()) > 0 ? lastHistoryOrderTime : this.historyStartTime;
            IsoTime lastDealTime = this.historyStorage.getLastDealTime(instance).join();
            IsoTime startingDealTime = this.historyStartTime == null || lastDealTime.getDate().compareTo(this.historyStartTime.getDate()) > 0 ? lastDealTime : this.historyStartTime;
            this.getState((String)instanceIndex).lastSynchronizationId = synchronizationId = RandomStringUtils.randomAlphanumeric((int)32);
            return this.websocketClient.synchronize(this.account.getId(), instance, host, synchronizationId, startingHistoryOrderTime, startingDealTime).join();
        });
    }

    public CompletableFuture<Void> initialize() {
        return this.historyStorage.initialize();
    }

    public CompletableFuture<Void> subscribe() {
        if (!this.closed) {
            this.websocketClient.ensureSubscribe(this.account.getId(), null);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> subscribeToMarketData(String symbol) {
        return this.subscribeToMarketData(symbol, new ArrayList<MarketDataSubscription>(), 0, null);
    }

    public CompletableFuture<Void> subscribeToMarketData(String symbol, List<MarketDataSubscription> subscriptions) {
        return this.subscribeToMarketData(symbol, subscriptions, 0, null);
    }

    public CompletableFuture<Void> subscribeToMarketData(String symbol, List<MarketDataSubscription> subscriptions, Integer instanceIndex) {
        return this.subscribeToMarketData(symbol, subscriptions, instanceIndex, null);
    }

    public CompletableFuture<Void> subscribeToMarketData(String symbol, List<MarketDataSubscription> subscriptions, Integer instanceIndex, Long timeoutInSeconds) {
        Subscriptions subscriptionsItem = new Subscriptions();
        subscriptionsItem.subscriptions = subscriptions;
        this.subscriptions.put(symbol, subscriptionsItem);
        return ((CompletableFuture)this.websocketClient.subscribeToMarketData(this.account.getId(), instanceIndex, symbol, subscriptions).thenApply(res -> this.terminalState.waitForPrice(symbol, timeoutInSeconds))).thenApply(res -> null);
    }

    public CompletableFuture<Void> unsubscribeFromMarketData(String symbol) {
        return this.unsubscribeFromMarketData(symbol, new ArrayList<MarketDataUnsubscription>(), 0);
    }

    public CompletableFuture<Void> unsubscribeFromMarketData(String symbol, List<MarketDataUnsubscription> subscriptions) {
        return this.unsubscribeFromMarketData(symbol, subscriptions, 0);
    }

    public CompletableFuture<Void> unsubscribeFromMarketData(String symbol, List<MarketDataUnsubscription> subscriptions, int instanceIndex) {
        if (subscriptions.size() == 0) {
            this.subscriptions.remove(symbol);
        } else if (this.subscriptions.containsKey(symbol)) {
            this.subscriptions.get((Object)symbol).subscriptions = this.subscriptions.get((Object)symbol).subscriptions.stream().filter(s -> !subscriptions.stream().filter(s2 -> s.type.equals(s2.type)).findFirst().isPresent()).collect(Collectors.toList());
            if (this.subscriptions.get((Object)symbol).subscriptions.size() == 0) {
                this.subscriptions.remove(symbol);
            }
        }
        return this.websocketClient.unsubscribeFromMarketData(this.account.getId(), instanceIndex, symbol, subscriptions);
    }

    @Override
    public CompletableFuture<Void> onSubscriptionDowngraded(String instanceIndex, String symbol, List<MarketDataSubscription> updates, List<MarketDataUnsubscription> unsubscriptions) {
        List<Object> subscriptions;
        List<Object> list = subscriptions = this.subscriptions.containsKey(symbol) ? this.subscriptions.get((Object)symbol).subscriptions : new ArrayList();
        if (unsubscriptions.size() != 0) {
            if (subscriptions.size() != 0) {
                for (MarketDataUnsubscription marketDataUnsubscription : unsubscriptions) {
                    subscriptions = subscriptions.stream().filter(s -> s.type.equals(subscription.type)).collect(Collectors.toList());
                }
            }
            this.unsubscribeFromMarketData(symbol, unsubscriptions);
        }
        if (updates.size() != 0) {
            if (subscriptions.size() != 0) {
                for (MarketDataSubscription marketDataSubscription : updates) {
                    subscriptions.stream().filter(s -> s.type.equals(subscription.type)).forEach(s -> {
                        s.intervalInMilliseconds = subscription.intervalInMilliseconds;
                    });
                }
            }
            this.subscribeToMarketData(symbol, updates);
        }
        if (subscriptions.size() != 0) {
            this.subscriptions.remove(symbol);
        }
        return CompletableFuture.completedFuture(null);
    }

    public List<String> getSubscribedSymbols() {
        return new ArrayList<String>(this.subscriptions.keySet());
    }

    public List<MarketDataSubscription> getSubscriptions(String symbol) {
        if (this.subscriptions.containsKey(symbol)) {
            return this.subscriptions.get((Object)symbol).subscriptions;
        }
        return null;
    }

    public CompletableFuture<List<String>> getSymbols() {
        return this.websocketClient.getSymbols(this.account.getId());
    }

    public CompletableFuture<MetatraderSymbolSpecification> getSymbolSpecification(String symbol) {
        return this.websocketClient.getSymbolSpecification(this.account.getId(), symbol);
    }

    public CompletableFuture<MetatraderSymbolPrice> getSymbolPrice(String symbol) {
        return this.websocketClient.getSymbolPrice(this.account.getId(), symbol);
    }

    public CompletableFuture<MetatraderCandle> getCandle(String symbol, String timeframe) {
        return this.websocketClient.getCandle(this.account.getId(), symbol, timeframe);
    }

    public CompletableFuture<MetatraderTick> getTick(String symbol) {
        return this.websocketClient.getTick(this.account.getId(), symbol);
    }

    public CompletableFuture<MetatraderBook> getBook(String symbol) {
        return this.websocketClient.getBook(this.account.getId(), symbol);
    }

    public CompletableFuture<Void> saveUptime(Map<String, Double> uptime) {
        return this.websocketClient.saveUptime(this.account.getId(), uptime);
    }

    public TerminalState getTerminalState() {
        return this.terminalState;
    }

    public HistoryStorage getHistoryStorage() {
        return this.historyStorage;
    }

    public void addSynchronizationListener(SynchronizationListener listener) {
        this.synchronizationListeners.add(listener);
        this.websocketClient.addSynchronizationListener(this.account.getId(), listener);
    }

    public void removeSynchronizationListener(SynchronizationListener listener) {
        this.synchronizationListeners.remove(listener);
        this.websocketClient.removeSynchronizationListener(this.account.getId(), listener);
    }

    @Override
    public CompletableFuture<Void> onConnected(String instanceIndex, int replicas) {
        String key = RandomStringUtils.randomAlphanumeric((int)32);
        State state = this.getState(instanceIndex);
        state.shouldSynchronize = key;
        state.synchronizationRetryIntervalInSeconds = 1;
        state.isSynchronized = false;
        this.ensureSynchronized(instanceIndex, key);
        ArrayList<Integer> indices = new ArrayList<Integer>(replicas);
        for (int i = 0; i < replicas; ++i) {
            indices.add(i);
        }
        for (Map.Entry<String, State> e : new ArrayList<Map.Entry<String, State>>(this.stateByInstanceIndex.entrySet())) {
            if (indices.indexOf(this.getInstanceNumber(e.getValue().instanceIndex)) != -1) continue;
            this.stateByInstanceIndex.remove(e.getKey());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDisconnected(String instanceIndex) {
        State state = this.getState(instanceIndex);
        state.lastDisconnectedSynchronizationId = state.lastSynchronizationId;
        state.lastSynchronizationId = null;
        state.shouldSynchronize = "";
        state.isSynchronized = false;
        state.disconnected = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDealSynchronizationFinished(String instanceIndex, String synchronizationId) {
        State state = this.getState(instanceIndex);
        state.dealsSynchronized.add(synchronizationId);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderSynchronizationFinished(String instanceIndex, String synchronizationId) {
        State state = this.getState(instanceIndex);
        state.ordersSynchronized.add(synchronizationId);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onAccountInformationUpdated(String instanceIndex, MetatraderAccountInformation accountInformation) {
        for (String symbol : new ArrayList<String>(this.getSubscribedSymbols())) {
            if (this.terminalState.getPrice(symbol).isPresent()) continue;
            Integer instance = this.getInstanceNumber(instanceIndex);
            this.subscribeToMarketData(symbol, this.subscriptions.get((Object)symbol).subscriptions, instance).exceptionally(err -> {
                logger.error("[" + new IsoTime() + "] MetaApi websocket client for account " + this.account.getId() + ":" + instanceIndex + " failed to resubscribe to symbol " + symbol, err);
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onReconnected() {
        this.stateByInstanceIndex.clear();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onStreamClosed(String instanceIndex) {
        this.stateByInstanceIndex.remove(instanceIndex);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Boolean> isSynchronized(String instanceIndex, String synchronizationId) {
        boolean result = false;
        for (State s : this.stateByInstanceIndex.values()) {
            if (instanceIndex != null && !s.instanceIndex.equals(instanceIndex)) continue;
            if (synchronizationId == null) {
                synchronizationId = s.lastSynchronizationId;
            }
            boolean isSynchronized = s.ordersSynchronized.contains(synchronizationId) && s.dealsSynchronized.contains(synchronizationId);
            result = result || isSynchronized;
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<Void> waitSynchronized() {
        return this.waitSynchronized(null);
    }

    public CompletableFuture<Void> waitSynchronized(SynchronizationOptions options) {
        if (options == null) {
            options = new SynchronizationOptions();
        }
        SynchronizationOptions opts = options;
        return Async.run(() -> {
            int intervalInMilliseconds;
            String instanceIndex = opts.instanceIndex;
            String synchronizationId = opts.synchronizationId;
            int timeoutInSeconds = opts.timeoutInSeconds != null ? opts.timeoutInSeconds : 300;
            int n = intervalInMilliseconds = opts.intervalInMilliseconds != null ? opts.intervalInMilliseconds : 1000;
            String applicationPattern = opts.applicationPattern != null ? opts.applicationPattern : (this.account.getApplication().equals("CopyFactory") ? "CopyFactory.*|RPC" : "RPC");
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)timeoutInSeconds;
            try {
                boolean isSynchronized;
                while (!(isSynchronized = this.isSynchronized(instanceIndex, synchronizationId).get().booleanValue()) && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds);
                }
                State state = null;
                if (instanceIndex == null) {
                    for (State s2 : this.stateByInstanceIndex.values()) {
                        if (!this.isSynchronized(s2.instanceIndex, synchronizationId).join().booleanValue()) continue;
                        state = s2;
                        instanceIndex = s2.instanceIndex;
                    }
                } else {
                    String finalInstanceIndex = instanceIndex;
                    state = this.stateByInstanceIndex.values().stream().filter(s -> s.instanceIndex.equals(finalInstanceIndex)).findFirst().orElse(null);
                }
                if (!isSynchronized) {
                    throw new TimeoutException("Timed out waiting for account MetApi to synchronize to MetaTrader account " + this.account.getId() + ", synchronization id " + (synchronizationId != null ? synchronizationId : (state != null && state.lastSynchronizationId != null ? state.lastSynchronizationId : (state != null && state.lastDisconnectedSynchronizationId != null ? state.lastDisconnectedSynchronizationId : null))));
                }
                this.websocketClient.waitSynchronized(this.account.getId(), this.getInstanceNumber(instanceIndex), applicationPattern, Long.valueOf(timeoutInSeconds)).get();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> close() {
        return Async.run(() -> {
            if (!this.closed) {
                this.stateByInstanceIndex.clear();
                this.websocketClient.unsubscribe(this.account.getId()).join();
                this.websocketClient.removeSynchronizationListener(this.account.getId(), this);
                this.websocketClient.removeSynchronizationListener(this.account.getId(), this.terminalState);
                this.websocketClient.removeSynchronizationListener(this.account.getId(), this.historyStorage);
                this.websocketClient.removeSynchronizationListener(this.account.getId(), this.healthMonitor);
                for (SynchronizationListener listener : this.synchronizationListeners) {
                    this.websocketClient.removeSynchronizationListener(this.account.getId(), listener);
                }
                this.websocketClient.removeReconnectListener(this);
                this.connectionRegistry.remove(this.account.getId());
                this.healthMonitor.stop();
                this.closed = true;
            }
        });
    }

    public boolean isSynchronized() {
        return this.stateByInstanceIndex.values().stream().filter(state -> state.isSynchronized).findFirst().isPresent();
    }

    public MetatraderAccount getAccount() {
        return this.account;
    }

    public ConnectionHealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    private void generateStopOptions(MetatraderTrade trade, Object stopLoss, Object takeProfit) {
        if (stopLoss != null) {
            if (stopLoss instanceof Double) {
                trade.stopLoss = (Double)stopLoss;
            } else {
                trade.stopLoss = ((StopOptions)stopLoss).value;
                trade.stopLossUnits = ((StopOptions)stopLoss).units;
            }
        }
        if (takeProfit != null) {
            if (takeProfit instanceof Double) {
                trade.takeProfit = (Double)takeProfit;
            } else {
                trade.takeProfit = ((StopOptions)takeProfit).value;
                trade.takeProfitUnits = ((StopOptions)takeProfit).units;
            }
        }
    }

    private void ensureSynchronized(String instanceIndex, String key) {
        block4: {
            State state = this.getState(instanceIndex);
            if (state != null && !this.closed) {
                try {
                    Boolean synchronizationResult = this.synchronize(instanceIndex).join();
                    if (synchronizationResult != null && synchronizationResult.booleanValue()) {
                        state.isSynchronized = true;
                        state.synchronizationRetryIntervalInSeconds = 1;
                    }
                }
                catch (CompletionException e) {
                    logger.error("MetaApi websocket client for account " + this.account.getId() + ":" + instanceIndex + " failed to synchronize", e.getCause());
                    if (!state.shouldSynchronize.equals(key)) break block4;
                    Js.setTimeout(() -> this.ensureSynchronized(instanceIndex, key), 1000 * state.synchronizationRetryIntervalInSeconds);
                    state.synchronizationRetryIntervalInSeconds = Math.min(state.synchronizationRetryIntervalInSeconds * 2, 300);
                }
            }
        }
    }

    private State getState(String instanceIndex) {
        if (!this.stateByInstanceIndex.containsKey(instanceIndex)) {
            final String stateInstanceIndex = instanceIndex;
            this.stateByInstanceIndex.put(instanceIndex, new State(){
                {
                    this.instanceIndex = stateInstanceIndex;
                    this.synchronizationRetryIntervalInSeconds = 1;
                }
            });
        }
        return this.stateByInstanceIndex.get(instanceIndex);
    }

    private void copyModelProperties(Object source, Object target) {
        Field[] publicFields = source.getClass().getFields();
        for (int i = 0; i < publicFields.length; ++i) {
            Field sourceField = publicFields[i];
            try {
                Field targetField = target.getClass().getField(sourceField.getName());
                targetField.set(target, sourceField.get(source));
                continue;
            }
            catch (NoSuchFieldException targetField) {
                continue;
            }
            catch (Exception e) {
                logger.error("Cannot copy model property " + sourceField.getName(), (Throwable)e);
            }
        }
    }

    private static class Subscriptions {
        List<MarketDataSubscription> subscriptions;

        private Subscriptions() {
        }
    }

    private static class State {
        public String instanceIndex;
        public Set<String> ordersSynchronized = new HashSet<String>();
        public Set<String> dealsSynchronized = new HashSet<String>();
        public String shouldSynchronize = "";
        public Integer synchronizationRetryIntervalInSeconds;
        public boolean isSynchronized = false;
        public String lastDisconnectedSynchronizationId = "";
        public String lastSynchronizationId = "";
        public boolean disconnected = false;

        private State() {
        }
    }
}

