/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.TimeoutException;
import cloud.metaapi.sdk.clients.error_handler.NotFoundException;
import cloud.metaapi.sdk.clients.error_handler.ValidationException;
import cloud.metaapi.sdk.clients.meta_api.ExpertAdvisorClient;
import cloud.metaapi.sdk.clients.meta_api.HistoricalMarketDataClient;
import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.meta_api.MetatraderAccountClient;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountDto;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountUpdateDto;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderCandle;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderTick;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.ExpertAdvisor;
import cloud.metaapi.sdk.meta_api.HistoryFileManager;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MetaApiConnection;
import cloud.metaapi.sdk.util.Async;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class MetatraderAccount {
    private MetatraderAccountDto data;
    private MetatraderAccountClient metatraderAccountClient;
    private ConnectionRegistry connectionRegistry;
    private HistoricalMarketDataClient historicalMarketDataClient;
    private ExpertAdvisorClient expertAdvisorClient;

    public MetatraderAccount(MetatraderAccountDto data, MetatraderAccountClient metatraderAccountClient, MetaApiWebsocketClient metaApiWebsocketClient, ConnectionRegistry connectionRegistry, ExpertAdvisorClient expertAdvisorClient, HistoricalMarketDataClient historicalMarketDataClient) {
        this.data = data;
        this.metatraderAccountClient = metatraderAccountClient;
        this.connectionRegistry = connectionRegistry;
        this.expertAdvisorClient = expertAdvisorClient;
        this.historicalMarketDataClient = historicalMarketDataClient;
    }

    public String getId() {
        return this.data._id;
    }

    public String getName() {
        return this.data.name;
    }

    public String getType() {
        return this.data.type;
    }

    public String getLogin() {
        return this.data.login;
    }

    public String getServer() {
        return this.data.server;
    }

    public String getProvisioningProfileId() {
        return this.data.provisioningProfileId;
    }

    public String getApplication() {
        return this.data.application;
    }

    public int getMagic() {
        return this.data.magic;
    }

    public MetatraderAccountDto.DeploymentState getState() {
        return this.data.state;
    }

    public MetatraderAccountDto.ConnectionStatus getConnectionStatus() {
        return this.data.connectionStatus;
    }

    public String getAccessToken() {
        return this.data.accessToken;
    }

    public boolean isManualTrades() {
        return this.data.manualTrades;
    }

    public List<MetatraderAccountDto.Extension> getExtensions() {
        return this.data.extensions;
    }

    public Map<String, Object> getMetadata() {
        return this.data.metadata;
    }

    public List<String> getTags() {
        return this.data.tags;
    }

    public List<MetatraderAccountDto.CopyFactoryRole> getCopyFactoryRoles() {
        return this.data.copyFactoryRoles;
    }

    public int getResourceSlots() {
        return this.data.resourceSlots;
    }

    public String getBaseCurrency() {
        return this.data.baseCurrency;
    }

    public String getReliability() {
        return this.data.reliability;
    }

    public int getVersion() {
        return this.data.version;
    }

    public CompletableFuture<Void> reload() {
        return this.metatraderAccountClient.getAccount(this.getId()).thenAccept(account -> {
            this.data = account;
        });
    }

    public CompletableFuture<Void> remove() {
        return Async.supply(() -> {
            this.connectionRegistry.remove(this.getId());
            try {
                block5: {
                    this.metatraderAccountClient.deleteAccount(this.getId()).get();
                    HistoryFileManager fileManager = ServiceProvider.createHistoryFileManager(this.getId(), "MetaApi", null);
                    fileManager.deleteStorageFromDisk().get();
                    if (!this.getType().equals("self-hosted")) {
                        try {
                            this.reload().get();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof NotFoundException) break block5;
                            throw e.getCause();
                        }
                    }
                }
                return null;
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<Void> deploy() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Async.run(() -> {
            try {
                this.metatraderAccountClient.deployAccount(this.getId()).get();
                this.reload().get();
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> undeploy() {
        return Async.run(() -> {
            this.connectionRegistry.remove(this.getId());
            this.metatraderAccountClient.undeployAccount(this.getId()).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> redeploy() {
        return Async.run(() -> {
            this.metatraderAccountClient.redeployAccount(this.getId()).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> increaseReliability() {
        return Async.run(() -> {
            this.metatraderAccountClient.increaseReliability(this.getId()).join();
            this.reload().join();
        });
    }

    public CompletableFuture<Void> waitDeployed(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Async.run(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (this.getState() != MetatraderAccountDto.DeploymentState.DEPLOYED && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                if (this.getState() != MetatraderAccountDto.DeploymentState.DEPLOYED) {
                    throw new TimeoutException("Timed out waiting for account " + this.getId() + " to be deployed");
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> waitUndeployed(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Async.run(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (this.getState() != MetatraderAccountDto.DeploymentState.UNDEPLOYED && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                if (this.getState() != MetatraderAccountDto.DeploymentState.UNDEPLOYED) {
                    throw new TimeoutException("Timed out waiting for account " + this.getId() + " to be undeployed");
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> waitRemoved(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Async.run(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                throw new TimeoutException("Timed out waiting for account " + this.getId() + " to be deleted");
            }
            catch (Exception e) {
                if (e.getCause() instanceof NotFoundException) {
                    result.complete(null);
                } else {
                    result.completeExceptionally(e);
                }
                return;
            }
        });
        return result;
    }

    public CompletableFuture<Void> waitConnected() {
        return this.waitConnected(null, null);
    }

    public CompletableFuture<Void> waitConnected(Integer timeoutInSeconds, Integer intervalInMilliseconds) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Async.run(() -> {
            long startTime = Instant.now().getEpochSecond();
            long timeoutTime = startTime + (long)(timeoutInSeconds != null ? timeoutInSeconds : 300);
            try {
                this.reload().get();
                while (this.getConnectionStatus() != MetatraderAccountDto.ConnectionStatus.CONNECTED && timeoutTime > Instant.now().getEpochSecond()) {
                    Thread.sleep(intervalInMilliseconds != null ? (long)intervalInMilliseconds.intValue() : 1000L);
                    this.reload().get();
                }
                if (this.getConnectionStatus() != MetatraderAccountDto.ConnectionStatus.CONNECTED) {
                    throw new TimeoutException("Timed out waiting for account " + this.getId() + " to connect to the broker");
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<MetaApiConnection> connect() {
        return this.connect(null, null);
    }

    public CompletableFuture<MetaApiConnection> connect(HistoryStorage historyStorage) {
        return this.connect(historyStorage, null);
    }

    public CompletableFuture<MetaApiConnection> connect(HistoryStorage historyStorage, IsoTime historyStartTime) {
        return this.connectionRegistry.connect(this, historyStorage, historyStartTime);
    }

    public CompletableFuture<Void> update(MetatraderAccountUpdateDto account) {
        return Async.run(() -> {
            this.metatraderAccountClient.updateAccount(this.getId(), account).join();
            this.reload().join();
        });
    }

    public CompletableFuture<List<ExpertAdvisor>> getExpertAdvisors() {
        return Async.supply(() -> {
            this.checkExpertAdvisorAllowed();
            List<ExpertAdvisorClient.ExpertAdvisorDto> advisors = this.expertAdvisorClient.getExpertAdvisors(this.getId()).join();
            return advisors.stream().map(e -> new ExpertAdvisor((ExpertAdvisorClient.ExpertAdvisorDto)e, this.getId(), this.expertAdvisorClient)).collect(Collectors.toList());
        });
    }

    public CompletableFuture<ExpertAdvisor> getExpertAdvisor(String expertId) {
        return Async.supply(() -> {
            this.checkExpertAdvisorAllowed();
            ExpertAdvisorClient.ExpertAdvisorDto advisor = this.expertAdvisorClient.getExpertAdvisor(this.getId(), expertId).join();
            return new ExpertAdvisor(advisor, this.getId(), this.expertAdvisorClient);
        });
    }

    public CompletableFuture<ExpertAdvisor> createExpertAdvisor(String expertId, ExpertAdvisorClient.NewExpertAdvisorDto expert) {
        return Async.supply(() -> {
            this.checkExpertAdvisorAllowed();
            this.expertAdvisorClient.updateExpertAdvisor(this.getId(), expertId, expert).join();
            return this.getExpertAdvisor(expertId).join();
        });
    }

    public CompletableFuture<List<MetatraderCandle>> getHistoricalCandles(String symbol, String timeframe) {
        return this.historicalMarketDataClient.getHistoricalCandles(this.getId(), symbol, timeframe, null, null);
    }

    public CompletableFuture<List<MetatraderCandle>> getHistoricalCandles(String symbol, String timeframe, IsoTime startTime) {
        return this.historicalMarketDataClient.getHistoricalCandles(this.getId(), symbol, timeframe, startTime, null);
    }

    public CompletableFuture<List<MetatraderCandle>> getHistoricalCandles(String symbol, String timeframe, IsoTime startTime, Integer limit) {
        return this.historicalMarketDataClient.getHistoricalCandles(this.getId(), symbol, timeframe, startTime, limit);
    }

    public CompletableFuture<List<MetatraderTick>> getHistoricalTicks(String symbol) {
        return this.historicalMarketDataClient.getHistoricalTicks(this.getId(), symbol, null, null, null);
    }

    public CompletableFuture<List<MetatraderTick>> getHistoricalTicks(String symbol, IsoTime startTime) {
        return this.historicalMarketDataClient.getHistoricalTicks(this.getId(), symbol, startTime, null, null);
    }

    public CompletableFuture<List<MetatraderTick>> getHistoricalTicks(String symbol, IsoTime startTime, Integer offset, Integer limit) {
        return this.historicalMarketDataClient.getHistoricalTicks(this.getId(), symbol, startTime, offset, limit);
    }

    private void checkExpertAdvisorAllowed() throws CompletionException {
        if (this.getVersion() != 4 || !this.getType().equals("cloud-g1")) {
            throw new CompletionException(new ValidationException("Custom expert advisor is available only for MT4 G1 accounts", (Object)null));
        }
    }
}

