/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api.reservoir;

import cloud.metaapi.sdk.meta_api.reservoir.AvlTree;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class AvlTreeReservoir<T>
extends AvlTree<Node> {
    public static int switchToAlgorithmZConstant = 22;
    public static String debug = "none";
    private Long interval;
    private RandomGenerator rng;
    private int reservoirSize;
    private int totalItemCount = 0;
    private int lastDeletedIndex = -1;
    private int numToSkip = -1;
    private Algorithm currentAlgorithm;
    private int algorithmXCount = 0;
    private int switchThreshold;
    private Integer evictNext = null;
    private int initialIndex = 0;
    private double W;
    protected AvlTree<T> valueTree;
    private Algorithm algorithmR = () -> {
        int localItemCount = this.totalItemCount + 1;
        int randomValue = (int)Math.floor(this.rng.random() * (double)localItemCount);
        int toSkip = 0;
        while (randomValue >= this.reservoirSize) {
            ++toSkip;
            randomValue = (int)Math.floor(this.rng.random() * (double)(++localItemCount));
        }
        this.evictNext = randomValue;
        return toSkip;
    };
    private Algorithm algorithmZ = () -> {
        double x;
        double y;
        int term = this.totalItemCount - this.reservoirSize + 1;
        int toSkip = 0;
        do {
            int numer_lim;
            int denom;
            double rhs;
            double lhs;
            double randomValue = this.rng.random();
            x = (double)this.totalItemCount * (this.W - 1.0);
            toSkip = (int)Math.floor(x);
            double subterm = (double)(this.totalItemCount + 1) / (double)term;
            int termSkip = term + toSkip;
            if ((lhs = Math.exp(Math.log(randomValue * (subterm *= subterm) * (double)termSkip / ((double)this.totalItemCount + x)) / (double)this.reservoirSize)) <= (rhs = ((double)this.totalItemCount + x) / (double)termSkip * (double)term / (double)this.totalItemCount)) {
                this.W = rhs / lhs;
                break;
            }
            y = randomValue * (double)(this.totalItemCount + 1) / (double)term * (double)(this.totalItemCount + toSkip + 1) / ((double)this.totalItemCount + x);
            if (this.reservoirSize < toSkip) {
                denom = this.totalItemCount;
                numer_lim = term + toSkip;
            } else {
                denom = this.totalItemCount - this.reservoirSize + toSkip;
                numer_lim = this.totalItemCount + 1;
            }
            for (int numer = this.totalItemCount + toSkip; numer >= numer_lim; --numer) {
                y = y * (double)numer / (double)denom;
                --denom;
            }
            this.W = Math.exp(-Math.log(this.rng.random()) / (double)this.reservoirSize);
        } while (!(Math.exp(Math.log(y) / (double)this.reservoirSize) <= ((double)this.totalItemCount + x) / (double)this.totalItemCount));
        return toSkip;
    };
    private Algorithm algorithmX = () -> {
        int localItemCount = this.totalItemCount;
        double randomValue = this.rng.random();
        int toSkip = 0;
        if (this.totalItemCount <= this.switchThreshold) {
            ++this.algorithmXCount;
            double quotient = (double)this.algorithmXCount / (double)(++localItemCount);
            while (quotient > randomValue) {
                ++toSkip;
                ++this.algorithmXCount;
                quotient = quotient * (double)this.algorithmXCount / (double)(++localItemCount);
            }
            return toSkip;
        }
        this.currentAlgorithm = this.algorithmZ;
        return this.currentAlgorithm.execute();
    };

    public AvlTreeReservoir(Comparator<T> comparer, int reservoirSize) {
        this(comparer, reservoirSize, null, null);
    }

    public AvlTreeReservoir(Comparator<T> comparer, int reservoirSize, Long storagePeriodInMilliseconds) {
        this(comparer, reservoirSize, storagePeriodInMilliseconds, null);
    }

    public AvlTreeReservoir(Comparator<T> comparer, int reservoirSize, Long storagePeriodInMilliseconds, RandomGenerator randomNumberGen) {
        super((a, b) -> a.index - b.index);
        this.interval = storagePeriodInMilliseconds;
        this.rng = randomNumberGen != null ? randomNumberGen : () -> Math.random();
        this.reservoirSize = reservoirSize != 0 ? reservoirSize : 1;
        this.currentAlgorithm = this.algorithmX;
        this.switchThreshold = switchToAlgorithmZConstant * this.reservoirSize;
        if (debug.equals("R")) {
            this.currentAlgorithm = this.algorithmR;
        } else if (debug.equals("X")) {
            this.switchThreshold = Integer.MAX_VALUE;
        } else if (debug.equals("Z")) {
            this.currentAlgorithm = this.algorithmZ;
        }
        this.W = Math.exp(-Math.log(this.rng.random()) / (double)reservoirSize);
        this.valueTree = new AvlTree<T>(comparer);
    }

    public void removeOldRecords() {
        Node element;
        while (this.interval != null && (element = (Node)this.at(0)) != null && Date.from(ServiceProvider.getNow()).getTime() > element.time + this.interval) {
            this.removeAt(0);
            int deletedIndexDiff = element.index - this.lastDeletedIndex;
            this.lastDeletedIndex = element.index;
            this.valueTree.remove(element.data);
            this.totalItemCount -= deletedIndexDiff;
            this.algorithmXCount = Math.max(0, this.algorithmXCount - deletedIndexDiff);
        }
    }

    public int pushSome(T value) {
        return this.pushSome(Arrays.asList(value));
    }

    public int pushSome(List<T> values) {
        int len = Math.min(this.size(), this.reservoirSize);
        for (final T arg : values) {
            this.removeOldRecords();
            Node value = new Node(){
                {
                    this.index = AvlTreeReservoir.this.initialIndex;
                    this.time = Date.from(ServiceProvider.getNow()).getTime();
                    this.data = arg;
                }
            };
            this.addSample(value);
            ++this.initialIndex;
        }
        return len;
    }

    public int fromObject(Node value) {
        return this.fromObject(Arrays.asList(value));
    }

    public int fromObject(List<Node> values) {
        int len = Math.min(this.size(), this.reservoirSize);
        for (final Node arg : values) {
            this.removeOldRecords();
            Node value = new Node(){
                {
                    this.index = arg.index;
                    this.time = arg.time;
                    this.data = arg.data;
                }
            };
            this.addSample(value);
            ++this.initialIndex;
        }
        return len;
    }

    public List<T> toValueList() {
        return this.toList().stream().map(value -> value.data).collect(Collectors.toList());
    }

    private void addSample(Node sample) {
        if (this.size() < this.reservoirSize) {
            this.insert(sample);
            this.valueTree.insert(sample.data);
        } else {
            if (this.numToSkip < 0) {
                this.numToSkip = this.currentAlgorithm.execute();
            }
            if (this.numToSkip == 0) {
                this.replaceRandomSample(sample, this);
            }
            --this.numToSkip;
        }
        ++this.totalItemCount;
    }

    private void replaceRandomSample(Node sample, AvlTreeReservoir<T> reservoir) {
        int randomIndex;
        if (this.evictNext != null) {
            randomIndex = this.evictNext;
            this.evictNext = null;
        } else {
            randomIndex = (int)Math.floor(this.rng.random() * (double)this.reservoirSize);
        }
        Node value = (Node)reservoir.at(randomIndex);
        reservoir.removeAt(randomIndex);
        this.valueTree.remove(value.data);
        this.valueTree.insert(sample.data);
        reservoir.insert(sample);
    }

    @FunctionalInterface
    public static interface Algorithm {
        public int execute();
    }

    @FunctionalInterface
    public static interface RandomGenerator {
        public double random();
    }

    public class Node {
        public int index;
        public long time;
        public T data;
    }
}

