/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.util;

import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.ConnectionRegistry;
import cloud.metaapi.sdk.meta_api.HistoryFileManager;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MetaApiConnection;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import java.time.Instant;

public class ServiceProvider {
    private static HistoryFileManager historyFileManagerMock = null;
    private static MetaApiConnection metaApiConnectionMock = null;
    private static MetaApiConnectionProvider metaApiConnectionMockProvider = null;
    private static Instant nowInstantMock = null;
    private static Double randomMock = null;

    public static void reset() {
        historyFileManagerMock = null;
        metaApiConnectionMock = null;
        metaApiConnectionMockProvider = null;
        nowInstantMock = null;
    }

    public static HistoryFileManager createHistoryFileManager(String accountId, String application, HistoryStorage storage) {
        if (historyFileManagerMock != null) {
            return historyFileManagerMock;
        }
        return new HistoryFileManager(accountId, application, storage);
    }

    public static void setHistoryFileManagerMock(HistoryFileManager mock) {
        historyFileManagerMock = mock;
    }

    public static MetaApiConnection createMetaApiConnection(MetaApiWebsocketClient websocketClient, MetatraderAccount account, HistoryStorage historyStorage, ConnectionRegistry connectionRegistry, IsoTime historyStartTime) {
        if (metaApiConnectionMock != null) {
            return metaApiConnectionMock;
        }
        if (metaApiConnectionMockProvider != null) {
            return metaApiConnectionMockProvider.create(websocketClient, account, historyStorage, connectionRegistry, historyStartTime);
        }
        return new MetaApiConnection(websocketClient, account, historyStorage, connectionRegistry, historyStartTime);
    }

    public static void setMetApiConnectionMock(MetaApiConnection mock) {
        metaApiConnectionMock = mock;
        metaApiConnectionMockProvider = null;
    }

    public static void setMetApiConnectionMock(MetaApiConnectionProvider mockProvider) {
        metaApiConnectionMockProvider = mockProvider;
        metaApiConnectionMock = null;
    }

    public static Instant getNow() {
        if (nowInstantMock != null) {
            return nowInstantMock;
        }
        return Instant.now();
    }

    public static void setNowInstantMock(Instant instant) {
        nowInstantMock = instant;
    }

    public static double getRandom() {
        return randomMock != null ? randomMock : Math.random();
    }

    public static void setRandom(Double value) {
        randomMock = value;
    }

    public static interface MetaApiConnectionProvider {
        public MetaApiConnection create(MetaApiWebsocketClient var1, MetatraderAccount var2, HistoryStorage var3, ConnectionRegistry var4, IsoTime var5);
    }
}

