/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.clients.meta_api;

import cloud.metaapi.sdk.clients.HttpClient;
import cloud.metaapi.sdk.clients.HttpRequestOptions;
import cloud.metaapi.sdk.clients.MetaApiClient;
import cloud.metaapi.sdk.clients.meta_api.models.AccountsFilter;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountDto;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountIdDto;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderAccountUpdateDto;
import cloud.metaapi.sdk.clients.meta_api.models.NewMetatraderAccountDto;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;

public class MetatraderAccountClient
extends MetaApiClient {
    private static Logger logger = Logger.getLogger(MetatraderAccountClient.class);

    public MetatraderAccountClient(HttpClient httpClient, String token) {
        super(httpClient, token);
    }

    public MetatraderAccountClient(HttpClient httpClient, String token, String domain) {
        super(httpClient, token, domain);
    }

    public CompletableFuture<List<MetatraderAccountDto>> getAccounts(AccountsFilter accountsFilter) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("getAccounts");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts", HttpRequestOptions.Method.GET);
        if (accountsFilter != null) {
            opts.getQueryParameters().putAll(this.transformModelToMap(accountsFilter));
        }
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, MetatraderAccountDto[].class).thenApply(array -> Arrays.asList(array));
    }

    public CompletableFuture<MetatraderAccountDto> getAccountByToken() {
        if (this.isNotAccountToken()) {
            return this.handleNoAccessError("getAccountByToken");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/accessToken/" + this.token, HttpRequestOptions.Method.GET);
        return this.httpClient.requestJson(opts, MetatraderAccountDto.class);
    }

    public CompletableFuture<MetatraderAccountDto> getAccount(String id) {
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + id, HttpRequestOptions.Method.GET);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.requestJson(opts, MetatraderAccountDto.class);
    }

    public CompletableFuture<MetatraderAccountIdDto> createAccount(NewMetatraderAccountDto account) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("createAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody(account);
        return this.httpClient.requestJson(opts, MetatraderAccountIdDto.class);
    }

    public CompletableFuture<Void> deployAccount(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("deployAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + id + "/deploy", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> undeployAccount(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("undeployAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + id + "/undeploy", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> redeployAccount(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("redeployAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + id + "/redeploy", HttpRequestOptions.Method.POST);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> deleteAccount(String id) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("deleteAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + id, HttpRequestOptions.Method.DELETE);
        opts.getHeaders().put("auth-token", this.token);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    public CompletableFuture<Void> updateAccount(String id, MetatraderAccountUpdateDto account) {
        if (this.isNotJwtToken()) {
            return this.handleNoAccessError("updateAccount");
        }
        HttpRequestOptions opts = new HttpRequestOptions(this.host + "/users/current/accounts/" + id, HttpRequestOptions.Method.PUT);
        opts.getHeaders().put("auth-token", this.token);
        opts.setBody(account);
        return this.httpClient.request(opts).thenApply(body -> null);
    }

    private Map<String, Object> transformModelToMap(Object model) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Field[] publicFields = model.getClass().getFields();
        for (int i = 0; i < publicFields.length; ++i) {
            Field field = publicFields[i];
            try {
                if (field.get(model) == null) continue;
                result.put(field.getName(), field.get(model));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.error((Object)"Cannot transform model to map", (Throwable)e);
            }
        }
        return result;
    }
}

