/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.MetaApiWebsocketClient;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.meta_api.MetaApiConnection;
import cloud.metaapi.sdk.meta_api.MetatraderAccount;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ConnectionRegistry {
    private MetaApiWebsocketClient metaApiWebsocketClient;
    private Map<String, MetaApiConnection> connections;
    private String application;

    public ConnectionRegistry(MetaApiWebsocketClient metaApiWebsocketClient) {
        this(metaApiWebsocketClient, null);
    }

    public ConnectionRegistry(MetaApiWebsocketClient metaApiWebsocketClient, String application) {
        this.metaApiWebsocketClient = metaApiWebsocketClient;
        this.application = application != null ? application : "MetaApi";
        this.connections = new HashMap<String, MetaApiConnection>();
    }

    public CompletableFuture<MetaApiConnection> connect(MetatraderAccount account, HistoryStorage historyStorage) {
        return this.connect(account, historyStorage, null);
    }

    public CompletableFuture<MetaApiConnection> connect(MetatraderAccount account, HistoryStorage historyStorage, IsoTime historyStartTime) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.connections.containsKey(account.getId())) {
                return this.connections.get(account.getId());
            }
            MetaApiConnection connection = ServiceProvider.createMetaApiConnection(this.metaApiWebsocketClient, account, historyStorage, this, historyStartTime);
            connection.initialize().join();
            connection.subscribe().join();
            this.connections.put(account.getId(), connection);
            return connection;
        });
    }

    public void remove(String accountId) {
        this.connections.remove(accountId);
    }

    public String getApplication() {
        return this.application;
    }
}

