/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.SynchronizationListener;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.models.IsoTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class HistoryStorage
extends SynchronizationListener {
    private boolean orderSynchronizationFinished = false;
    private boolean dealSynchronizationFinished = false;

    public abstract List<MetatraderDeal> getDeals();

    public abstract List<MetatraderOrder> getHistoryOrders();

    public abstract void reset();

    public abstract CompletableFuture<Void> loadData();

    public abstract CompletableFuture<Void> updateStorage();

    public boolean isOrderSynchronizationFinished() {
        return this.orderSynchronizationFinished;
    }

    public boolean isDealSynchronizationFinished() {
        return this.dealSynchronizationFinished;
    }

    public abstract CompletableFuture<IsoTime> getLastHistoryOrderTime();

    public abstract CompletableFuture<IsoTime> getLastDealTime();

    @Override
    public abstract CompletableFuture<Void> onHistoryOrderAdded(MetatraderOrder var1);

    @Override
    public abstract CompletableFuture<Void> onDealAdded(MetatraderDeal var1);

    @Override
    public CompletableFuture<Void> onDealSynchronizationFinished(String synchronizationId) {
        this.dealSynchronizationFinished = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onOrderSynchronizationFinished(String synchronizationId) {
        this.orderSynchronizationFinished = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onConnected() {
        this.orderSynchronizationFinished = false;
        this.dealSynchronizationFinished = false;
        return CompletableFuture.completedFuture(null);
    }
}

