/*
 * Decompiled with CFR 0.152.
 */
package cloud.metaapi.sdk.meta_api;

import cloud.metaapi.sdk.clients.meta_api.models.MetatraderDeal;
import cloud.metaapi.sdk.clients.meta_api.models.MetatraderOrder;
import cloud.metaapi.sdk.clients.models.IsoTime;
import cloud.metaapi.sdk.meta_api.HistoryFileManager;
import cloud.metaapi.sdk.meta_api.HistoryStorage;
import cloud.metaapi.sdk.util.ServiceProvider;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MemoryHistoryStorage
extends HistoryStorage {
    private String accountId;
    private HistoryFileManager fileManager;
    private List<MetatraderDeal> deals = new ArrayList<MetatraderDeal>();
    private List<MetatraderOrder> historyOrders = new ArrayList<MetatraderOrder>();

    public MemoryHistoryStorage(String accountId) {
        this(accountId, null);
    }

    public MemoryHistoryStorage(String accountId, String application) {
        this.accountId = accountId;
        if (application == null) {
            application = "MetaApi";
        }
        this.fileManager = ServiceProvider.createHistoryFileManager(this.accountId, application, this);
        this.fileManager.startUpdateJob();
    }

    @Override
    public List<MetatraderDeal> getDeals() {
        return this.deals;
    }

    @Override
    public List<MetatraderOrder> getHistoryOrders() {
        return this.historyOrders;
    }

    @Override
    public void reset() {
        this.deals.clear();
        this.historyOrders.clear();
        this.fileManager.deleteStorageFromDisk();
    }

    @Override
    public CompletableFuture<Void> loadData() {
        return this.loadDataFromDisk();
    }

    public CompletableFuture<Void> loadDataFromDisk() {
        return CompletableFuture.runAsync(() -> {
            HistoryFileManager.History history = this.fileManager.getHistoryFromDisk().join();
            this.deals = new ArrayList<MetatraderDeal>(history.deals);
            this.historyOrders = new ArrayList<MetatraderOrder>(history.historyOrders);
        });
    }

    @Override
    public CompletableFuture<Void> updateStorage() {
        return this.updateDiskStorage();
    }

    public CompletableFuture<Void> updateDiskStorage() {
        return this.fileManager.updateDiskStorage();
    }

    @Override
    public CompletableFuture<IsoTime> getLastHistoryOrderTime() {
        Date maxOrderDoneTime = Date.from(Instant.ofEpochSecond(0L));
        for (MetatraderOrder order : this.historyOrders) {
            Date orderDoneTime = this.getOrderDoneTime(order);
            if (orderDoneTime.compareTo(maxOrderDoneTime) <= 0) continue;
            maxOrderDoneTime = orderDoneTime;
        }
        return CompletableFuture.completedFuture(new IsoTime(maxOrderDoneTime));
    }

    @Override
    public CompletableFuture<IsoTime> getLastDealTime() {
        Date maxDealTime = Date.from(Instant.ofEpochSecond(0L));
        for (MetatraderDeal deal : this.deals) {
            if (deal.time.getDate().compareTo(maxDealTime) <= 0) continue;
            maxDealTime = deal.time.getDate();
        }
        return CompletableFuture.completedFuture(new IsoTime(maxDealTime));
    }

    @Override
    public CompletableFuture<Void> onHistoryOrderAdded(MetatraderOrder historyOrder) {
        int insertIndex = 0;
        int replacementIndex = -1;
        Date newHistoryOrderTime = this.getOrderDoneTime(historyOrder);
        for (int i = this.historyOrders.size() - 1; i >= 0; --i) {
            MetatraderOrder order = this.historyOrders.get(i);
            Date historyOrderTime = this.getOrderDoneTime(order);
            int timeComparing = historyOrderTime.compareTo(newHistoryOrderTime);
            if (timeComparing >= 0 && (timeComparing != 0 || order.id.compareTo(historyOrder.id) > 0)) continue;
            if (timeComparing == 0 && order.id.equals(historyOrder.id) && order.type == historyOrder.type) {
                replacementIndex = i;
                break;
            }
            insertIndex = i + 1;
            break;
        }
        if (replacementIndex != -1) {
            this.historyOrders.set(replacementIndex, historyOrder);
            this.fileManager.setStartNewOrderIndex(replacementIndex);
        } else {
            this.historyOrders.add(insertIndex, historyOrder);
            this.fileManager.setStartNewOrderIndex(insertIndex);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> onDealAdded(MetatraderDeal newDeal) {
        int insertIndex = 0;
        int replacementIndex = -1;
        Date newDealTime = newDeal.time.getDate();
        for (int i = this.deals.size() - 1; i >= 0; --i) {
            MetatraderDeal deal = this.deals.get(i);
            Date dealTime = deal.time.getDate();
            int timeComparing = dealTime.compareTo(newDealTime);
            if (timeComparing >= 0 && (timeComparing != 0 || deal.id.compareTo(newDeal.id) > 0)) continue;
            if (timeComparing == 0 && deal.id.equals(newDeal.id) && deal.entryType == newDeal.entryType) {
                replacementIndex = i;
                break;
            }
            insertIndex = i + 1;
            break;
        }
        if (replacementIndex != -1) {
            this.deals.set(replacementIndex, newDeal);
            this.fileManager.setStartNewDealIndex(replacementIndex);
        } else {
            this.deals.add(insertIndex, newDeal);
            this.fileManager.setStartNewDealIndex(insertIndex);
        }
        return CompletableFuture.completedFuture(null);
    }

    private Date getOrderDoneTime(MetatraderOrder order) {
        return order.doneTime != null ? order.doneTime.getDate() : Date.from(Instant.ofEpochSecond(0L));
    }
}

